// "Build Engine & Tools" Copyright (c) 1993-1997 Ken Silverman
// Ken Silverman's official web site: "http://www.advsys.net/ken"
// See the included license file "BUILDLIC.TXT" for license info.
//
// This file has been modified from Ken Silverman's original release
// by Jonathon Fowler (jonof@edgenetwk.com)
//
// This implementation of MMULTI.C acts to join a communcation module
// into the game as though it were a COMMIT module communicating via
// an interrupt of farcall, instead this module is linked into the
// executable.

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "osd.h"
#include "pragmas.h"
#include "mmulti.h"
#include "compat.h"

#define BAKSIZ 16384
//#define SIMULATEERRORS 1
//#define SHOWSENDPACKETS
//#define SHOWGETPACKETS
//#define PRINTERRORS

#define updatecrc16(crc,dat) crc = (((crc<<8)&65535)^crctable[((((unsigned short)crc)>>8)&65535)^dat])

static long incnt[MAXPLAYERS], outcntplc[MAXPLAYERS], outcntend[MAXPLAYERS];
static char errorgotnum[MAXPLAYERS];
static char errorfixnum[MAXPLAYERS];
static char errorresendnum[MAXPLAYERS];
#ifdef PRINTERRORS
static char lasterrorgotnum[MAXPLAYERS];
#endif

static long crctable[256];

static char lastpacket[576], inlastpacket = 0;
static short lastpacketfrom, lastpacketleng;

extern long totalclock;  //MUST EXTERN 1 ANNOYING VARIABLE FROM GAME
static long timeoutcount = 60, resendagaincount = 4, lastsendtime[MAXPLAYERS];

static short bakpacketptr[MAXPLAYERS][256], bakpacketlen[MAXPLAYERS][256];
static char bakpacketbuf[BAKSIZ];
static long bakpacketplc = 0;

short myconnectindex, numplayers;
short connecthead, connectpoint2[MAXPLAYERS];
char syncstate = 0;

extern char mapfilename[255], mapfilefromgroup;

gcomtype gcom;


static void initcrc(void)
{
	long i, j, k, a;

	for(j=0;j<256;j++)      //Calculate CRC table
	{
		k = (j<<8); a = 0;
		for(i=7;i>=0;i--)
		{
			if (((k^a)&0x8000) > 0)
				a = ((a<<1)&65535) ^ 0x1021;   //0x1021 = genpoly
			else
				a = ((a<<1)&65535);
			k = ((k<<1)&65535);
		}
		crctable[j] = (a&65535);
	}
}

static long getcrc(char *buffer, short bufleng)
{
	long i, j;

	j = 0;
	for(i=bufleng-1;i>=0;i--) updatecrc16(j,buffer[i]);
	return(j&65535);
}


void initmultiplayers(char damultioption, char dacomrateoption, char dapriority)
{
	long i;

	initcrc();
	for(i=0;i<MAXPLAYERS;i++) {
		incnt[i] = 0L;
		outcntplc[i] = 0L;
		outcntend[i] = 0L;
		bakpacketlen[i][255] = -1;
	}

	numplayers = 1; myconnectindex = 0;

	connecthead = 0;
	for(i=MAXPLAYERS-1;i>=0;i--)
		connectpoint2[i] = -1, connectnum[i] = 0x7fffffff;

	if (!damultioption) return;

	if (setupmultiplayergame()) {
		// failed initializing networking
		damultioption = 0;
	}

	// these get set by the comm module
	//numplayers = gcom.numplayers;
	//myconnectindex = gcom.myconnectindex-1;
#ifdef SIMULATEERRORS
	srand(myconnectindex*24572457+345356);
#endif

	for(i=0;i<MAXPLAYERS;i++) lastsendtime[i] = totalclock;
}

void setpackettimeout(long datimeoutcount, long daresendagaincount)
{
	long i;

	timeoutcount = datimeoutcount;
	resendagaincount = daresendagaincount;
	for(i=0;i<numplayers;i++) lastsendtime[i] = totalclock;
}

void uninitmultiplayers(void)
{
	endmultiplayergame();
}

void sendlogon(void)
{
}

void sendlogoff(void)
{
	long i;
	char tempbuf[2];

	tempbuf[0] = 255;
	tempbuf[1] = myconnectindex;
	for(i=connecthead;i>=0;i=connectpoint2[i])
		if (i != myconnectindex)
			sendpacket(i,tempbuf,2L);
}

long getoutputcirclesize(void)
{
	return(0);
}

void setsocket(short newsocket)
{
}

static void dosendpackets(long other)
{
	long i, j, k, messleng;
	unsigned short dacrc;

	if (outcntplc[other] == outcntend[other]) return;

#ifdef PRINTERRORS
	if (errorgotnum[other] > lasterrorgotnum[other])
	{
		lasterrorgotnum[other]++;
		printOSD(" MeWant %ld\n",incnt[other]&255);
	}
#endif

	if (outcntplc[other]+1 == outcntend[other])
	{     //Send 1 sub-packet
		k = 0;
		gcom.buffer[k++] = (outcntplc[other]&255);
		gcom.buffer[k++] = (errorgotnum[other]&7)+((errorresendnum[other]&7)<<3);
		gcom.buffer[k++] = (incnt[other]&255);

		j = bakpacketptr[other][outcntplc[other]&255];
		messleng = bakpacketlen[other][outcntplc[other]&255];
		for(i=0;i<messleng;i++)
			gcom.buffer[k++] = bakpacketbuf[(i+j)&(BAKSIZ-1)];
		outcntplc[other]++;
	}
	else
	{     //Send 2 sub-packets
		k = 0;
		gcom.buffer[k++] = (outcntplc[other]&255);
		gcom.buffer[k++] = (errorgotnum[other]&7)+((errorresendnum[other]&7)<<3)+128;
		gcom.buffer[k++] = (incnt[other]&255);

			//First half-packet
		j = bakpacketptr[other][outcntplc[other]&255];
		messleng = bakpacketlen[other][outcntplc[other]&255];
		gcom.buffer[k++] = (char)(messleng&255);
		gcom.buffer[k++] = (char)(messleng>>8);
		for(i=0;i<messleng;i++)
			gcom.buffer[k++] = bakpacketbuf[(i+j)&(BAKSIZ-1)];
		outcntplc[other]++;

			//Second half-packet
		j = bakpacketptr[other][outcntplc[other]&255];
		messleng = bakpacketlen[other][outcntplc[other]&255];
		for(i=0;i<messleng;i++)
			gcom.buffer[k++] = bakpacketbuf[(i+j)&(BAKSIZ-1)];
		outcntplc[other]++;

	}

	dacrc = getcrc(gcom.buffer,k);
	gcom.buffer[k++] = (dacrc&255);
	gcom.buffer[k++] = (dacrc>>8);

	gcom.other = other+1;
	gcom.numbytes = k;

#ifdef SHOWSENDPACKETS
	printOSD("Send(%ld): ",gcom.other);
	for(i=0;i<gcom.numbytes;i++) printOSD("%2x ",gcom.buffer[i]);
	printOSD("\n");
#endif

#ifdef SIMULATEERRORS
	if (!(rand()&SIMULATEERRORS)) gcom.buffer[rand()%gcom.numbytes] = (rand()&255);
	if (rand()&SIMULATEERRORS)
#endif
		{ gcom.command = CMD_SEND; callcommit(); }
}

void dropplayer(short goneindex)
{
	long i, j, k;

	connectnum[goneindex] = 0x7fffffff; numplayers--;

	j = 0;
	for(i=0;i<MAXPLAYERS;i++)
		if (connectnum[i] != 0x7fffffff)
		{
			if (j == 0) connecthead = i; else connectpoint2[k] = i;
			k = i; j++;
		}
	connectpoint2[k] = -1;
}

void sendpacket(long other, char *bufptr, long messleng)
{
	long i, j, k, l,cnt;
	unsigned short dacrc;

	if (numplayers < 2) return;

	i = 0;
	if (bakpacketlen[other][(outcntend[other]-1)&255] == messleng)
	{
		j = bakpacketptr[other][(outcntend[other]-1)&255];
		for(i=messleng-1;i>=0;i--)
			if (bakpacketbuf[(i+j)&(BAKSIZ-1)] != bufptr[i]) break;
	}
	bakpacketlen[other][outcntend[other]&255] = messleng;

	if (i < 0)   //Point to last packet to save space on bakpacketbuf
		bakpacketptr[other][outcntend[other]&255] = j;
	else
	{
		bakpacketptr[other][outcntend[other]&255] = bakpacketplc;
		for(i=0;i<messleng;i++)
			bakpacketbuf[(bakpacketplc+i)&(BAKSIZ-1)] = bufptr[i];
		bakpacketplc = ((bakpacketplc+messleng)&(BAKSIZ-1));
	}
	outcntend[other]++;

	lastsendtime[other] = totalclock;
	dosendpackets(other);
}

void processreservedmessage(short tempbufleng, char *datempbuf)
{
	switch (datempbuf[0]) {
		case 253:
			// server status message
			datempbuf++;
			switch (datempbuf[0]) {
				case 0:	// probe game information
				case 1:	// join game
					break;
			}
			break;

		case 254:
			// server status response
			datempbuf++;
			switch (datempbuf[0]) {
				case 0:	// probe game information
				case 1:	// join game
					break;
			}
			break;

		case 255:
			// logout
			dropplayer(datempbuf[1]);
			break;

		default: break;
	}
}

short getpacket (short *other, char *bufptr)
{
	long i, j, messleng;
	unsigned short dacrc;

	if (numplayers < 2) return(0);

	for(i=connecthead;i>=0;i=connectpoint2[i])
		if (i != myconnectindex)
		{
			if (totalclock < lastsendtime[i]) lastsendtime[i] = totalclock;
			if (totalclock > lastsendtime[i]+timeoutcount)
			{
#ifdef PRINTERRORS
					printOSD(" TimeOut!\n");
#endif
					errorgotnum[i] = errorfixnum[i]+1;

					if ((outcntplc[i] == outcntend[i]) && (outcntplc[i] > 0))
						{ outcntplc[i]--; lastsendtime[i] = totalclock; }
					else
						lastsendtime[i] += resendagaincount;
					dosendpackets(i);
				//}
			}
		}

	if (inlastpacket != 0)
	{
			//2ND half of good double-packet
		inlastpacket = 0;
		*other = lastpacketfrom;
		memcpy(bufptr,lastpacket,lastpacketleng);
		if (lastpacketleng > 0 && bufptr[0] >= 200) {
			processreservedmessage(lastpacketleng,bufptr);
		}
		return(lastpacketleng);
	}

	gcom.command = CMD_GET;
	callcommit();

#ifdef SHOWGETPACKETS
	if (gcom.other != -1)
	{
		printOSD(" Get(%ld): ",gcom.other);
		for(i=0;i<gcom.numbytes;i++) printOSD("%2x ",gcom.buffer[i]);
		printOSD("\n");
	}
#endif

	if (gcom.other < 0) return(0);
	*other = gcom.other-1;

	messleng = gcom.numbytes;

	dacrc = ((unsigned short)gcom.buffer[messleng-2]);
	dacrc += (((unsigned short)gcom.buffer[messleng-1])<<8);
	if (dacrc != getcrc(gcom.buffer,messleng-2))        //CRC check
	{
#ifdef PRINTERRORS
		printOSD("%ld CRC\n",gcom.buffer[0]);
#endif
		errorgotnum[*other] = errorfixnum[*other]+1;
		return(0);
	}

	while ((errorfixnum[*other]&7) != ((gcom.buffer[1]>>3)&7))
		errorfixnum[*other]++;

	if ((gcom.buffer[1]&7) != (errorresendnum[*other]&7))
	{
		errorresendnum[*other]++;
		outcntplc[*other] = (outcntend[*other]&0xffffff00)+gcom.buffer[2];
		if (outcntplc[*other] > outcntend[*other]) outcntplc[*other] -= 256;
	}

	if (gcom.buffer[0] != (incnt[*other]&255))   //CNT check
	{
		if (((incnt[*other]-gcom.buffer[0])&255) > 32)
		{
			errorgotnum[*other] = errorfixnum[*other]+1;
#ifdef PRINTERRORS
			printOSD("%ld CNT\n",gcom.buffer[0]);
#endif
		}
#ifdef PRINTERRORS
		else
		{
			if (!(gcom.buffer[1]&128))           //single else double packet
				printOSD("%ld cnt\n",gcom.buffer[0]);
			else
			{
				if (((gcom.buffer[0]+1)&255) == (incnt[*other]&255))
				{
								 //GOOD! Take second half of double packet
#ifdef PRINTERRORS
					printOSD("%ld-%ld . \n",gcom.buffer[0],(gcom.buffer[0]+1)&255);
#endif
					messleng = ((long)gcom.buffer[3]) + (((long)gcom.buffer[4])<<8);
					lastpacketleng = gcom.numbytes-7-messleng;
					memcpy(bufptr,&gcom.buffer[messleng+5],lastpacketleng);
					incnt[*other]++;
					if (lastpacketleng > 0 && bufptr[0] >= 200) {
						processreservedmessage(lastpacketleng,bufptr);
					}
					return(lastpacketleng);
				}
				else
					printOSD("%ld-%ld cnt \n",gcom.buffer[0],(gcom.buffer[0]+1)&255);
			}
		}
#endif
		return(0);
	}

		//PACKET WAS GOOD!
	if ((gcom.buffer[1]&128) == 0)           //Single packet
	{
#ifdef PRINTERRORS
		printOSD("%ld   \n",gcom.buffer[0]);
#endif

		messleng = gcom.numbytes-5;

		memcpy(bufptr,&gcom.buffer[3],messleng);

		incnt[*other]++;
		if (messleng > 0 && bufptr[0] >= 200) {
			processreservedmessage(messleng,bufptr);
		}
		return(messleng);
	}

														 //Double packet
#ifdef PRINTERRORS
	printOSD("%ld-%ld  \n",gcom.buffer[0],(gcom.buffer[0]+1)&255);
#endif

	messleng = ((long)gcom.buffer[3]) + (((long)gcom.buffer[4])<<8);
	lastpacketleng = gcom.numbytes-7-messleng;
	inlastpacket = 1; lastpacketfrom = *other;

	memcpy(bufptr,&gcom.buffer[5],messleng);
	memcpy(lastpacket,&gcom.buffer[messleng+5],lastpacketleng);

	incnt[*other] += 2;
	if (messleng > 0 && bufptr[0] >= 200) {
		processreservedmessage(messleng,bufptr);
	}
	return(messleng);
}

void flushpackets(void)
{
	/*long i;

	if (numplayers < 2) return;

	do
	{
		gcom.command = CMD_GET;
		callcommit();
	} while (gcom.other >= 0);

	for(i=connecthead;i>=0;i=connectpoint2[i])
	{
		incnt[i] = 0L;
		outcntplc[i] = 0L;
		outcntend[i] = 0L;
		errorgotnum[i] = 0;
		errorfixnum[i] = 0;
		errorresendnum[i] = 0;
		lastsendtime[i] = totalclock;
	}*/
}

void genericmultifunction(long other, char *bufptr, long messleng, long command)
{
	if (numplayers < 2) return;

	gcom.command = command;
	gcom.numbytes = min(messleng,MAXPACKETSIZE);
	copybuf(bufptr,gcom.buffer,(gcom.numbytes+3)>>2);
	gcom.other = other+1;
	callcommit();
}

