// Compatibility declarations for things which might not be present in
// certain build environments

#ifndef __compat_h__
#define __compat_h__

#ifndef O_BINARY
#define  O_BINARY 0
#endif
#ifndef O_TEXT
#define  O_TEXT   0
#endif
#ifndef S_IRGRP
#define  S_IRGRP  0
#endif
#ifndef S_IWGRP
#define  S_IWGRP  0
#endif

#define FP_OFF(__p) ((unsigned)(__p))

#ifdef UNDERSCORES
# ifdef __MINGW32__
#  define ASMSYM(x) "_"##x
# else
#  define ASMSYM(x) _##x
# endif
#else
#define ASMSYM(x) x
#endif

#ifndef SEEK_SET
# define SEEK_SET 0
#endif
#ifndef SEEK_CUR
# define SEEK_CUR 1
#endif
#ifndef SEEK_END
# define SEEK_END 2
#endif

#ifndef min
#define min(a,b) ( ((a) < (b)) ? (a) : (b) )
#endif

#ifndef max
#define max(a,b) ( ((a) > (b)) ? (a) : (b) )
#endif

typedef __int64 int64;
#define stricmp strcasecmp
#define strcmpi strcasecmp

#endif // __compat_h__

