// UDP Multiplayer Module
// for the Build Engine
// by Jonathon Fowler (jonof@edgenetwk.com


#include "osd.h"

#define MAXPLAYERS 16
#define GAMEPORT  0x4949


// extern'ed variables
short numplayers = 0, myconnectindex = 0;
short connecthead, connectpoint2[MAXPLAYERS];
char syncstate = 0;
char multioption = 0;



/*
	BUILD2.TXT l.991
	1.   First, let me describe the new network mode.  Instead of
	     a master/slave system, every computer sends its own controls
	     to every other.  You are currently using the master/slave
	     system which sends 2(n-1) packets per frame where n is the
	     number of players.  My new network mode sends n(n-1) packets
	     per frame and treats every player evenly.

	BUILDINF.TXT l.127
	Packet format for DUKE3D (specifically for network mode 1, n(n-1) mode):

	Example bunch of packets:
	A  B  C   D  E  F     G      H      I   J  K  L  M   N...       O
	---------------------------------------------------------------------
	d9 00 d9  11 01 00  -  -   -  -   -  -   -  -  -  -  4f       16 31
	da 00 da  11 01 00  -  -   -  -   -  -   -  -  -  -  b2       b7 9d
	db 00 db  11 01 00  -  -   -  -   -  -   -  -  -  -  b1       24 62
	dc 00 dc  11 01 00  -  -   -  -   -  -   -  -  -  -  ca       1d 58
	dd 00 dd  11 01 00  -  -   -  -   -  -   -  -  -  -  a9       94 14
	de 00 de  11 01 05  00 00  -  -   03 00  -  -  -  -  c5       50 b9
	df 00 df  11 01 0f  a1 ff  fe 09  00 00  26 -  -  -  e2       88 6f
	e0 00 e0  11 01 04  -  -   -  -   fd ff  -  -  -  -  77       51 d7
	e1 00 e1  11 01 03  1f 00  ff 09  -  -   -  -  -  -  ac       14 b7
	e2 00 e2  11 01 0b  9c 00  fb 09  -  -   24 -  -  -  f8       6c 22

	GAME sends fields D-N
	MMULTI adds fields A-C and O for error correction.

	A: Packet count sending modulo 256
	B: Error state.  Usually 0.  To request a resend, bit 0 is set.  In order
	      to catch up on networks, sending many packets is bad, so 2 packets
	      are sent in 1 IPX packet.  To send 2 packets in 1 packet, bit 1 is set.
	      In special cases, this value may be different.
	C: Packet count receiving modulo 256

	D: Message header byte.  These are all the possible values currently.  You
	      are probably only interested in case 17.  Note that fields E-N apply
	      to case 17 only.
	     0: send movement info from master to slave (network mode 0 only)
	     1: send movement info from slave to master (network mode 0 only)
	     4: user-typed messages
	     5: Re-start level with given parameters
	     6: Send player name
	     7: Play Remote Ridicule sound
	     8: Re-start level with given parameters for a user map
	    17: send movement info to everybody else (network mode 1 only)
	   250: Wait for Everybody (Don't start until everybody's done loading)
	   253: Signon [AAAABBBBBBBBBB] A=myconnectnum, B=mynetworkaddress
	   254: Signon acknowledgement
	   255: Player quit to DOS

	E: Timing byte used to calculate lag time.  This prevents the 2 computer's
	      timers from drifting apart.

	F: Bits field byte.  Fields G-M are sent only when certain bits
	      in this byte are set.

	G: X momentum update (2 bytes).  Sent only if ((F&1) != 0)

	H: Y momentum update (2 bytes).  Sent only if ((F&2) != 0)

	I: Angle momentum update (2 bytes).  Sent only if ((F&4) != 0)

	J: The states of 8 different keys (1 byte).  Sent only if ((F&8) != 0)
	K: The states of 8 different keys (1 byte).  Sent only if ((F&16) != 0)
	L: The states of 8 different keys (1 byte).  Sent only if ((F&32) != 0)
	M: The states of 8 different keys (1 byte).  Sent only if ((F&64) != 0)

	N: Sync checking byte.  Useful for debugging programming errors.  Can be a
	   variable number of bytes.  Actual number of sync checking bytes is
	   calculated by length of the whole packet minus the rest of the bytes sent.

	O: CRC-16

 */


//
// initmultiplayers
//   damultioption - 0 = singleplayer, !0 = network game
//   dacomrateoption - unused
//   dapriority - unused
//
void initmultiplayers(char damultioption, char dacomrateoption, char dapriority)
{
	int i;

	connecthead = 0;
	for(i=MAXPLAYERS-1;i>=0;i--)
		connectpoint2[i] = -1;//, connectnum[i] = 0x7fffffff;

	multioption = damultioption;

	printOSD("initmultiplayers() called\n");
}


void uninitmultiplayers(void)
{
	printOSD("uninitmultiplayers() called\n");
}


//
// sendpacket
//   other - who to send the packet to
//   bufptr - pointer to message to send
//   messleng - length of message
//
void sendpacket(long other, char *bufptr, long messleng)
{
	printOSD("sendpacket() called\n");
}


//
// getpacket (short *other, char *bufptr)
//   returns the number of bytes of the packet received, 0 if no packet
//   other - who the packet was received from
//   bufptr - pointer to message that was received
//
short getpacket (short *other, char *bufptr)
{
	printOSD("getpacket() called\n");
	return 0;
}


void sendlogon(void)
{
	long i;

	printOSD("sendlogon() called\n");

	if (multioption <= 0)
		return;

	/* now, normally we'd want to send our IP address here.
	   while we can still do it, it won't work with NAT environments
	   since the address we'd end up sending will be the internal
	   address of our host, so we're going to have to make the master
	   whom we're connecting to work it out for us and fill in the
	   blanks when it sends the packet on to the other connections
	   already waiting in the game. To signify this I will send
	   0xFFFFFFFFl.

	   Other players will receive this packet with the IP address filled
	   and so will we, so we can get our own address that way.
	 */

//	sendpacket(-1,tempbuf,15);
}


void sendlogoff(void)
{
	printOSD("sendlogoff() called\n");
}


int getoutputcirclesize(void)
{
	return 0;
}


void setsocket(short newsocket)
{
}


void flushpackets(void)
{
	printOSD("flushpackets()\n");
}



