// SDL interface layer
// for the Build Engine
// by Jonathon Fowler (jonof@edgenetwk.com)

// video
extern long xres, yres, fullscreen, bytesperline, imageSize, frameplace;

// keys
#define KEYFIFOSIZ 64
extern char keystatus[256], keyfifo[KEYFIFOSIZ], keyfifoplc, keyfifoend;

// mouse
extern short mousex, mousey, mouseb;

extern char quitevent, pauseevent, appactive;


int initsystem(void);
void uninitsystem(void);

int handleevents(void);

int initinput(void);
void uninitinput(void);

int initmouse(void);
void uninitmouse(void);
void grabmouse(char a);
void readmousexy(short *x, short *y);
void readmousebstatus(short *b);

int inittimer(int);
void uninittimer(void);
void sampletimer(void);
long getticks(void);
void (*installusertimercallback(void (*callback)(void)))(void);

int checkvideomode(long *x, long *y, int fs);
int setvideomode(int x, int y, int fs);
void getvalidmodes(void);

void begindrawing(void);
void enddrawing(void);
void showframe(void);

int setpalette(int start, int num, char *dapal);
int getpalette(int start, int num, char *dapal);
