// Assembly-language function wrappers for a.asm functions
// for the Build Engine
// by Jonathon Fowler (jonof@edgenetwk.com)

#define ASM __asm__ __volatile__

#ifdef UNDERSCORES
#  define PF "_a_"
#else
#  define PF "a_"
#endif

#ifdef ENGINE
#  define EXTERN
#else
#  define EXTERN extern
#endif

#define TMPL(n) inline long n
#define TMPLV(n) inline void n
#define BEGIN	{ long r;
#define END	return r; }
#define CALL "call "PF
#define RAX "=a" (r)

#define PAX "a" (a)
#define PBX "b" (b)
#define PCX "c" (c)
#define PDX "d" (d)
#define PSI "S" (S)
#define PDI "D" (D)

#define AX "eax"
#define BX "ebx"
#define CX "ecx"
#define DX "edx"
#define SI "esi"
#define DI "edi"
#define MEM "memory"
#define CC "cc"


TMPLV(mmxoverlay)(void)
{
	ASM (CALL "mmxoverlay": : : AX,BX,CX,DX,MEM,CC );
}
//#pragma aux mmxoverlay modify [eax ebx ecx edx];

TMPLV(sethlinesizes)(long a, long b, long c)
{
	ASM (CALL "sethlinesizes": : PAX,PBX,PCX : DX,MEM,CC );
}
//#pragma aux sethlinesizes parm [eax][ebx][ecx];

TMPLV(setpalookupaddress)(void *a)
{
	ASM (CALL "setpalookupaddress": : PAX : MEM,CC );
}
//#pragma aux setpalookupaddress parm [eax];

TMPLV(setuphlineasm4)(long a, long b)
{
	ASM (CALL "setuphlineasm4": : PAX,PBX : MEM,CC );
}
//#pragma aux setuphlineasm4 parm [eax][ebx];

TMPLV(hlineasm4)(long a, long b, long c, long d, long S, long D)
{
	ASM (CALL "hlineasm4": : PAX,PBX,PCX,PDX,PSI,PDI : MEM,CC );
}
//#pragma aux hlineasm4 parm [eax][ebx][ecx][edx][esi][edi];

TMPLV(setuprhlineasm4)(long a, long b, long c, long d, long S, long D)
{
	ASM (CALL "setuprhlineasm4": : PAX,PBX,PCX,PDX,PSI,PDI : MEM,CC );
}
//#pragma aux setuprhlineasm4 parm [eax][ebx][ecx][edx][esi][edi];

TMPLV(rhlineasm4)(long a, long b, long c, long d, long S, long D)
{
	ASM (CALL "rhlineasm4": : PAX,PBX,PCX,PDX,PSI,PDI : MEM,CC );
}
//#pragma aux rhlineasm4 parm [eax][ebx][ecx][edx][esi][edi];

TMPLV(setuprmhlineasm4)(long a, long b, long c, long d, long S, long D)
{
	ASM (CALL "setuprmhlineasm4": : PAX,PBX,PCX,PDX,PSI,PDI : MEM,CC );
}
//#pragma aux setuprmhlineasm4 parm [eax][ebx][ecx][edx][esi][edi];

TMPLV(rmhlineasm4)(long a, long b, long c, long d, long S, long D)
{
	ASM (CALL "rmhlineasm4": : PAX,PBX,PCX,PDX,PSI,PDI : MEM,CC );
}
//#pragma aux rmhlineasm4 parm [eax][ebx][ecx][edx][esi][edi];

TMPLV(setupqrhlineasm4)(long a, long b, long c, long d, long S, long D)
{
	ASM (CALL "setupqrhlineasm4": : PAX,PBX,PCX,PDX,PSI,PDI : MEM,CC );
}
//#pragma aux setupqrhlineasm4 parm [eax][ebx][ecx][edx][esi][edi];

TMPLV(qrhlineasm4)(long a, long b, long c, long d, long S, long D)
{
	ASM (CALL "qrhlineasm4": : PAX,PBX,PCX,PDX,PSI,PDI : MEM,CC );
}
//#pragma aux qrhlineasm4 parm [eax][ebx][ecx][edx][esi][edi];

TMPLV(setvlinebpl)(long a)
{
	ASM (CALL "setvlinebpl": : PAX : MEM,CC );
}
//#pragma aux setvlinebpl parm [eax];

TMPLV(fixtransluscence)(long a)
{
	ASM (CALL "fixtransluscence": : PAX : MEM,CC );
}
//#pragma aux fixtransluscence parm [eax];

TMPL(prevlineasm1)(long a, long b, long c, long d, long S, long D)
BEGIN
	ASM (CALL "prevlineasm1": RAX : PAX,PBX,PCX,PDX,PSI,PDI : MEM,CC );
END
//#pragma aux prevlineasm1 parm [eax][ebx][ecx][edx][esi][edi];

TMPLV(vlineasm1)(long a, long b, long c, long d, long S, long D)
{
	ASM (CALL "vlineasm1": : PAX,PBX,PCX,PDX,PSI,PDI : MEM,CC );
}
//#pragma aux vlineasm1 parm [eax][ebx][ecx][edx][esi][edi];

TMPLV(setuptvlineasm)(long a)
{
	ASM (CALL "setuptvlineasm": : PAX : MEM,CC );
}
//#pragma aux setuptvlineasm parm [eax];

TMPL(tvlineasm1)(long a, long b, long c, long d, long S, long D)
BEGIN
	ASM (CALL "tvlineasm1": RAX : PAX,PBX,PCX,PDX,PSI,PDI : MEM,CC );
END
//#pragma aux tvlineasm1 parm [eax][ebx][ecx][edx][esi][edi];

TMPLV(setuptvlineasm2)(long a, long b, long c)
{
	ASM (CALL "setuptvlineasm2": : PAX,PBX,PCX : MEM,CC );
}
//#pragma aux setuptvlineasm2 parm [eax][ebx][ecx];

TMPLV(tvlineasm2)(long a, long b, long c, long d, long S, long D)
{
	ASM (CALL "tvlineasm2": : PAX,PBX,PCX,PDX,PSI,PDI : MEM,CC );
}
//#pragma aux tvlineasm2 parm [eax][ebx][ecx][edx][esi][edi];

TMPL(mvlineasm1)(long a, long b, long c, long d, long S, long D)
BEGIN
	ASM (CALL "mvlineasm1": RAX : PAX,PBX,PCX,PDX,PSI,PDI : MEM,CC );
END
//#pragma aux mvlineasm1 parm [eax][ebx][ecx][edx][esi][edi];

TMPLV(setupvlineasm)(long a)
{
	ASM (CALL "setupvlineasm": : PAX : MEM,CC );
}
//#pragma aux setupvlineasm parm [eax];

TMPLV(vlineasm4)(long c, long D)
{
	ASM (CALL "vlineasm4": : PCX,PDI : AX,BX,DX,SI,MEM,CC );
}
//#pragma aux vlineasm4 parm [ecx][edi] modify [eax ebx ecx edx esi edi];

TMPLV(setupmvlineasm)(long a)
{
	ASM (CALL "setupmvlineasm": : PAX : MEM,CC );
}
//#pragma aux setupmvlineasm parm [eax];

TMPLV(mvlineasm4)(long c, long D)
{
	ASM (CALL "mvlineasm4": : PCX,PDI : AX,BX,DX,SI,MEM,CC );
}
//#pragma aux mvlineasm4 parm [ecx][edi] modify [eax ebx ecx edx esi edi];

TMPLV(setupspritevline)(long a, long b, long c, long d, long S, long D)
{
	ASM (CALL "setupspritevline": : PAX,PBX,PCX,PDX,PSI,PDI : MEM,CC );
}
//#pragma aux setupspritevline parm [eax][ebx][ecx][edx][esi][edi];

TMPLV(spritevline)(long a, long b, long c, long d, long S, long D)
{
	ASM (CALL "spritevline": : PAX,PBX,PCX,PDX,PSI,PDI : MEM,CC );
}
//#pragma aux spritevline parm [eax][ebx][ecx][edx][esi][edi];

TMPLV(msetupspritevline)(long a, long b, long c, long d, long S, long D)
{
	ASM (CALL "msetupspritevline": : PAX,PBX,PCX,PDX,PSI,PDI : MEM,CC );
}
//#pragma aux msetupspritevline parm [eax][ebx][ecx][edx][esi][edi];

TMPLV(mspritevline)(long a, long b, long c, long d, long S, long D)
{
	ASM (CALL "mspritevline": : PAX,PBX,PCX,PDX,PSI,PDI : MEM,CC );
}
//#pragma aux mspritevline parm [eax][ebx][ecx][edx][esi][edi];

TMPLV(tsetupspritevline)(long a, long b, long c, long d, long S, long D)
{
	ASM (CALL "tsetupspritevline": : PAX,PBX,PCX,PDX,PSI,PDI : MEM,CC );
}
//#pragma aux tsetupspritevline parm [eax][ebx][ecx][edx][esi][edi];

TMPLV(tspritevline)(long a, long b, long c, long d, long S, long D)
{
	ASM (CALL "tspritevline": : PAX,PBX,PCX,PDX,PSI,PDI : MEM,CC );
}
//#pragma aux tspritevline parm [eax][ebx][ecx][edx][esi][edi];

TMPL(mhline)(long a, long b, long c, long d, long S, long D)
BEGIN
	ASM (CALL "mhline": RAX : PAX,PBX,PCX,PDX,PSI,PDI : MEM,CC );
END
//#pragma aux mhline parm [eax][ebx][ecx][edx][esi][edi];

TMPL(mhlineskipmodify)(long a, long b, long c, long d, long S, long D)
BEGIN
	ASM (CALL "mhlineskipmodify": RAX : PAX,PBX,PCX,PDX,PSI,PDI : MEM,CC );
END
//#pragma aux mhlineskipmodify parm [eax][ebx][ecx][edx][esi][edi];

TMPL(msethlineshift)(long a, long b)
BEGIN
	ASM (CALL "msethlineshift": RAX : PAX,PBX : MEM,CC );
END
//#pragma aux msethlineshift parm [eax][ebx];

TMPL(thline)(long a, long b, long c, long d, long S, long D)
BEGIN
	ASM (CALL "thline": RAX : PAX,PBX,PCX,PDX,PSI,PDI : MEM,CC );
END
//#pragma aux thline parm [eax][ebx][ecx][edx][esi][edi];

TMPL(thlineskipmodify)(long a, long b, long c, long d, long S, long D)
BEGIN
	ASM (CALL "thlineskipmodify": RAX : PAX,PBX,PCX,PDX,PSI,PDI : MEM,CC );
END
//#pragma aux thlineskipmodify parm [eax][ebx][ecx][edx][esi][edi];

TMPL(tsethlineshift)(long a, long b)
BEGIN
	ASM (CALL "tsethlineshift": RAX : PAX,PBX : MEM,CC );
END
//#pragma aux tsethlineshift parm [eax][ebx];

TMPL(setupslopevlin)(long a, long b, long c)
BEGIN
	ASM (CALL "setupslopevlin": RAX : PAX,PBX,PCX : DX,MEM,CC );
END
//#pragma aux setupslopevlin parm [eax][ebx][ecx] modify [edx];

TMPL(slopevlin)(long a, long b, long c, long d, long S, long D)
BEGIN
	ASM (CALL "slopevlin": RAX : PAX,PBX,PCX,PDX,PSI,PDI : MEM,CC );
END
//#pragma aux slopevlin parm [eax][ebx][ecx][edx][esi][edi];

TMPLV(settransnormal)(void)
{
	ASM (CALL "settransnormal": : : MEM,CC );
}
//#pragma aux settransnormal parm;

TMPLV(settransreverse)(void)
{
	ASM (CALL "settransreverse": : : MEM,CC );
}
//#pragma aux settransreverse parm;

TMPLV(setupdrawslab)(long a, long b)
{
	ASM (CALL "setupdrawslab": : PAX,PBX : MEM,CC );
}
//#pragma aux setupdrawslab parm [eax][ebx];

TMPLV(drawslab)(long a, long b, long c, long d, long S, long D)
{
	ASM (CALL "drawslab": : PAX,PBX,PCX,PDX,PSI,PDI : MEM,CC );
}
//#pragma aux drawslab parm [eax][ebx][ecx][edx][esi][edi];

TMPLV(stretchhline)(long a, long b, long c, long d, long S, long D)
{
	ASM (CALL "stretchhline": : PAX,PBX,PCX,PDX,PSI,PDI : MEM,CC );
}
//#pragma aux stretchhline parm [eax][ebx][ecx][edx][esi][edi];



#undef TMPL
#undef TMPLV
#undef BEGIN
#undef END
#undef CALL
#undef RAX

#undef PAX
#undef PBX
#undef PCX
#undef PDX
#undef PSI
#undef PDI

#undef AX
#undef BX
#undef CX
#undef DX
#undef SI
#undef DI
#undef MEM

#undef PF
#undef ASM

