#include "main.h"

static bool convert = 0;

#pragma pack(push)
#pragma pack(1)
typedef struct
{
	WORD fmt,trax,dtx;
} MIDIHEADER;

typedef struct
{
	DWORD mthd,hdsize;
	MIDIHEADER mhd;
} FILEHEADER;

typedef struct
{
	DWORD mtrk,size;
} TRACKHEADER;

#pragma pack(pop)

WORD _fastcall rev16(WORD);
DWORD _fastcall rev32(DWORD);

#define FixHeader(H) {(H).fmt=rev16((H).fmt);(H).trax=rev16((H).trax);(H).dtx=rev16((H).dtx);}
#define MThd 'dhTM'
#define MTrk 'krTM'
#define EVNT 'TNVE'

#define Q_MAX 128

static struct
{
	DWORD time;
	BYTE note;
	BYTE channel;
} ch_q[Q_MAX];

static void q_add(BYTE ch,BYTE note,DWORD tm)
{
	UINT n,_n=-1;
	for(n=0;n<Q_MAX;n++)
	{
		if (ch_q[n].note==note && ch_q[n].channel==ch)
		{
			ch_q[n].time=tm;
			return;
		}
		else if (ch_q[n].time==-1) _n=n;
	}
	if (_n!=-1)
	{
		ch_q[_n].channel=ch;
		ch_q[_n].time=tm;
		ch_q[_n].note=note;
	}
}

DWORD tr_sz;
DWORD cur_time=0,wr_time=0;

static void WriteDelta(HANDLE f,DWORD _d)
{
	DWORD d=_d-wr_time;
	wr_time=_d;
	if (d==0)
	{
		BYTE b=0;
		DWORD bw;
		WriteFile(f,&b,1,&bw,0);
		tr_sz++;
		return;
	}
	BYTE t;
	DWORD b;
	UINT n=5;
	bool w=0;
	do
	{
		n--;
		t=(d>>(7*n))&0x7F;
		if (t) w=1;
		if (w)
		{
			if (n)
				t|=0x80;
			WriteFile(f,&t,1,&b,0);
			tr_sz++;
		}
	}
	while(n);
}

static DWORD ReadDelta(BYTE* d)
{
	DWORD _d,l=0;
	_d=d[0]&0x7F;
	while(d[l]&0x80)
	{
		_d=(_d<<7)|(d[++l]&0x7F);
	}
	return _d;
}

DWORD _inline ReadDelta1(BYTE* d,DWORD *_l)
{
	DWORD r=d[0],l=0;
	while(!(d[l+1]&0x80))
	{
		r+=d[++l];
	}
	*_l=l+1;
	return r;
}

UINT _n1=0,_n2=0;

static void DoQueue(HANDLE f)
{
	while(1)
	{
		DWORD _i=-1;
		DWORD _mt=-1;
		UINT i;
		for(i=0;i<Q_MAX;i++)
		{
			if (ch_q[i].time<_mt) {_i=i;_mt=ch_q[i].time;}
		}
		if (_mt<=cur_time)
		{
			WriteDelta(f,_mt);
			DWORD b;
			BYTE t=0x80|ch_q[_i].channel;
			WriteFile(f,&t,1,&b,0);
			WriteFile(f,&ch_q[_i].note,1,&b,0);
			t=0x7F;
			WriteFile(f,&t,1,&b,0);
			ch_q[_i].time=-1;
			tr_sz+=3;
			_n2++;
		}
		else break;
	}
}
static bool hasevents;

static DWORD ProcessNote(HANDLE f,BYTE* e)
{
	hasevents=1;
	DoQueue(f);
	WriteDelta(f,cur_time);
	DWORD bw;
	BYTE i=e[0]&0xF;

	WriteFile(f,e,3,&bw,0);
	tr_sz+=3;
	DWORD l=3;
	DWORD _d=ReadDelta(e+l);
	while(e[l]&0x80) l++;
	l++;

	q_add(i,e[1],cur_time+_d);
	
	return l;
}

static DWORD ProcessDelta(HANDLE f,BYTE* d)
{
	DWORD l=0;
	cur_time+=ReadDelta1(d,&l);
	return l;
}

static bool et;

static DWORD WriteEvent(HANDLE f,BYTE* e)
{
	DWORD bw;
	if ((e[0]&0xF0)==0xF0 && e[0]!=0xFF)
	{
		UINT l=1;
		while(!(e[l]&0x80)) l++;
		return l;
	}
	else if (e[0]==0xFF)
	{
		if (e[1]==0x2F)
		{
			DWORD _ct=cur_time;
			cur_time=-2;
			DoQueue(f);
			cur_time=_ct;
			DWORD _ev=0x002FFF00;
			WriteFile(f,&_ev,4,&bw,0);
			tr_sz+=4;
			et=1;
			return 3;
		}
		else return 3+e[2];
	}
	DoQueue(f);
	WriteDelta(f,cur_time);
	DWORD l;
	if ((e[0]&0xF0)==0xC0 || (e[0]&0xF0)==0xD0) l=2;
	else l=3;
	hasevents=1;
	WriteFile(f,e,l,&bw,0);
	tr_sz+=l;
	return l;	
}

BYTE xmi_track0[19]={'M','T','r','k',0,0,0,11,0,0xFF,0x51,0x03,0x20,0x8d,0xb7,0,0xFF,0x2F,0};

static DWORD _stdcall xmi_rip(HANDLE src,HANDLE dst)
{
	if (!convert || dst==INVALID_HANDLE_VALUE)
	{
		DWORD br;
		ReadFile(src,buf,0x1e,&br,0);
		DWORD sz=rev32(*(DWORD*)(buf+0x1a));
		if (dst!=INVALID_HANDLE_VALUE)
		{
			ReadFile(src,buf+0x1e,sz,&br,0);
			sz+=0x1e;
			WriteFile(dst,buf,sz,&br,0);
		}
		else sz+=0x1e;
		return sz;
	}
	DWORD sz,br;
	ReadFile(src,buf,0x1e,&br,0);
	sz=rev32(*(DWORD*)(buf+0x1a));
	ReadFile(src,buf+0x1e,sz,&br,0);
	sz+=0x1e;

	FILEHEADER fhd=
	{
		MThd,
		0x06000000,
		0x0100,0x0000,0x0001	//0x0100
	};
	WriteFile(dst,&fhd,sizeof(fhd),&br,0);
	TRACKHEADER thd=
	{
		MTrk,0		
	};
	tr_sz=0;
	UINT ptr=0x22;
	DWORD ts;
	DWORD te;
	{
		UINT n;
		for(n=0;n<Q_MAX;n++) ch_q[n].time=-1;
	}
	WriteFile(dst,xmi_track0,sizeof(xmi_track0),&br,0);
	DWORD nf=0;
	cur_time=0;
	UINT nt=1;
_t:
	if (*(DWORD*)(buf+ptr)!=_rv('FORM')) goto fail;
	ptr+=4;
	ts=rev32(*(DWORD*)(buf+ptr));
	ptr+=4;
	nf=ptr+ts;
	if (nf&1) nf++;
	ptr+=4;
	while(*(DWORD*)(buf+ptr)!=_rv('EVNT'))
	{
		ptr+=4;
		ts=rev32(*(DWORD*)(buf+ptr));
		if (ts&1) ts++;
		ptr+=4+ts;
		if (ptr>=sz) goto _end;
		if (ptr>=nf) goto _t;
	}
	ptr+=4;
	ts=rev32(*(DWORD*)(buf+ptr));
	ptr+=4;
	te=ptr+ts;
	tr_sz=0;
	SetFilePointer(dst,8,0,FILE_CURRENT);
	et=0;
	wr_time=0;
	hasevents=0;
	while(ptr<te && !et)
	{
		if ((buf[ptr]&0x80)==0)
		{
			ptr+=ProcessDelta(dst,buf+ptr);
		}
		if ((buf[ptr]&0xF0)==0x90)
		{
			ptr+=ProcessNote(dst,buf+ptr);
		}
		else ptr+=WriteEvent(dst,buf+ptr);
	}
	SetFilePointer(dst,-tr_sz-8,0,FILE_CURRENT);
	if (hasevents)
	{
		thd.size=rev32(tr_sz);
		WriteFile(dst,&thd,8,&br,0);
		SetFilePointer(dst,tr_sz,0,FILE_CURRENT);
		nt++;
	}
	else SetEndOfFile(dst);
	ptr=nf;
	if (ptr&1) ptr++;
	if (ptr<sz-8 && *(DWORD*)(buf+ptr)==_rv('FORM')) goto _t;

_end:
	SetFilePointer(dst,10,0,FILE_BEGIN);
	nt=rev16(nt);
	WriteFile(dst,&nt,2,&br,0);
	return ptr;
fail:
	return RIP_ERROR;
}

static BYTE _t_hdr[]={'F','O','R','M',0,0,0,0x0e,'X','D','I','R','I','N','F','O',0,0,0,2};

bool _stdcall xmi_test(const void* _buf,DWORD max,char* info,char* ext)
{
	if (memcmp(_buf,_t_hdr,sizeof(_t_hdr))==0)
	{
		DWORD _s=rev32(*(DWORD*)((BYTE*)_buf+0x1a));
		if (_s<=max-0x1e && _s<BUF_SIZE)
		{
			if (*(DWORD*)((BYTE*)_buf+0x1e)==_rv('XMID') && *(DWORD*)((BYTE*)_buf+0x22)==_rv('FORM'))
			{
				*info=0;
				strcpy(ext,convert?"MID":"XMI");
				return 1;
			}			
		}
	}
	return 0;
}

static void _stdcall xmi_init(HKEY hk)
{
	DWORD s = sizeof(bool);
	RegQueryValueEx(hk,"xmi_convert",0,0,(BYTE*)&convert,&s);
}

static void _stdcall xmi_quit(HKEY hk)
{
	RegSetValueEx(hk,"xmi_convert",0,REG_BINARY,(BYTE*)&convert,sizeof(bool));
}

void _stdcall xmi_config(HWND wnd)
{
	cvt_cfg("XMI","convert to MID",&convert,wnd);
}

RIPPER XMI_ripper = {xmi_test,0,_rv('FORM'),0xFFFFFFFF,0,xmi_rip,xmi_init,xmi_quit,xmi_config,"XMI","XMIDI (MIDI clone)\x0D\x0AMIDI format used by Miles Sound System."};