#include "main.h"

static bool convert=1;

extern int IndexTab[16];
extern int StepTab[89];

DWORD __fastcall rev32(DWORD);

DWORD _stdcall iff_rip(HANDLE src,HANDLE dst);

bool iff_test(const void* b,DWORD max,char* info,DWORD id);

bool _stdcall vqa_test(const void* b,DWORD max,char* info,char* ext)
{
	if (iff_test(b,max,info,_rv('WVQA')))
	{
		*(DWORD*)ext = convert ? 'VAW' : 'AQV';
		return 1;
	}
	else return 0;
}

void InitWAV(HANDLE f,UINT freq,UINT nch,UINT bps)
{
	DWORD tmp;
	WAVEFORMATEX wfx=
	{
		WAVE_FORMAT_PCM,
		nch,
		freq,
		freq*nch*bps,
		bps*nch,
		bps*8,
		0
	};
	DWORD dw='FFIR';
	WriteFile(f,&dw,4,&tmp,0);
	dw=0;
	WriteFile(f,&dw,4,&tmp,0);
	dw='EVAW';
	WriteFile(f,&dw,4,&tmp,0);
	dw=0x20746D66;
	WriteFile(f,&dw,4,&tmp,0);
	dw=sizeof(WAVEFORMATEX);
	WriteFile(f,&dw,4,&tmp,0);
	WriteFile(f,&wfx,sizeof(WAVEFORMATEX),&tmp,0);
	dw='atad';
	WriteFile(f,&dw,4,&tmp,0);
	dw=0;
	WriteFile(f,&dw,4,&tmp,0);						
}

void CloseWAV(HANDLE f)
{
	DWORD _s=GetFileSize(f,0)-8;
	DWORD bw;
	SetFilePointer(f,4,0,FILE_BEGIN);
	WriteFile(f,&_s,4,&bw,0);
	_s-=20+sizeof(WAVEFORMATEX);
	SetFilePointer(f,24+sizeof(WAVEFORMATEX),0,FILE_BEGIN);
	WriteFile(f,&_s,4,&bw,0);
}

#define OUTBUF 4096

void WS_decode(BYTE* src,BYTE* out,DWORD os,DWORD s);

//static DWORD vqht[]={_rv('SN2J'),_rv('VQHD'),_rv('PINF'),_rv('FINF'),_rv('SND0'),_rv('SND1'),_rv('SND2'),_rv('SND0'),_rv('VQFR'),_rv('CMDS'),_rv('LINF'),_rv('CINF'),_rv('VQFL')};
//#define vqht_s (sizeof(vqht)/sizeof(DWORD))

DWORD _stdcall vqa_rip(HANDLE src,HANDLE dst)
{
	//if (!convert || dst==INVALID_HANDLE_VALUE) return iff_rip(src,dst);
	DWORD br;
	if (!convert)
	{
		DWORD hd[3];
		DWORD ds;
		ReadFile(src,hd,12,&br,0);
		WriteFile(dst,hd,12,&br,0);
		ds=rev32(hd[1]);
		if (ds>1024)
		{
			xfer(src,dst,ds-4);
			return ds+8;
		}
		else
		{
			DWORD ret=12;
			while(1)
			{
				UINT n;
				br=0;
				ReadFile(src,hd,8,&br,0);
				if (br!=8) break;
/*				for(n=0;n<vqht_s;n++)
				{
					if (hd[0]==vqht[n]) goto hok;
				}
				break;*/
hok:
				ret+=8;
				WriteFile(dst,hd,8,&br,0);
				ds=rev32(hd[1]);
				if (ds&1) ds++;
				ret+=ds;
				xfer(src,dst,ds);
			}
			return ret;
		}
	}
	DWORD dw;
	DWORD _of=SetFilePointer(src,0,0,FILE_CURRENT);
	SetFilePointer(src,4,0,FILE_CURRENT);
	DWORD sz;
	ReadFile(src,&sz,4,&br,0);
	sz=rev32(sz);
	DWORD ofs=12;
	DWORD _s;
	DWORD ds=0,pt=0;
	bool wav_started=0;
//	UINT sr=22050,ch=1,bps=2;

	int sample=0,index=0;
	if (sz<4096) sz=-1;
	while(ofs<sz)
	{
		SetFilePointer(src,ofs+_of,0,FILE_BEGIN);
		br=0;
		ReadFile(src,&dw,4,&br,0);
		if (!br) break;
		ReadFile(src,&_s,4,&br,0);
		if (!br) break;
		_s=rev32(_s);
//		if (ofs+_s>sz+8) return RIP_ERROR;
/*		UINT n;
		for(n=0;n<vqht_s;n++)
		{
			if (dw==vqht[n]) goto hok1;
		}
		{
			union
			{
				DWORD d;
				char c[5];
			} u;
			u.d=dw;
			u.c[4]=0;
			MessageBox(0,u.c,0,0);

		}
		break;
hok1:*/
		ofs+=8;
/*		if (dw==_rv('VQHD'))
		{
			WORD _sr;
			BYTE _ch,_bps;
			SetFilePointer(src,0x18,0,FILE_CURRENT);
			ReadFile(src,&_sr,2,&br,0);
			ReadFile(src,&_ch,1,&br,0);
			ReadFile(src,&_bps,1,&br,0);
//			sr=_sr;
//			ch=_ch;
//			bps=_bps>>3;
		}
		else */if (dw=='0DNS')
		{
			if (!wav_started)
			{
				InitWAV(dst,22050,1,2);
				wav_started=1;
			}
			xfer(src,dst,_s);
		}
		else if (dw=='1DNS')
		{
			if (!wav_started)
			{
				InitWAV(dst,22050,1,1);
				wav_started=1;
			}
			WORD s1h[2];
			ReadFile(src,s1h,4,&br,0);
			ReadFile(src,buf,s1h[0],&br,0);
			BYTE* out=buf+s1h[0];
			WS_decode(buf,out,s1h[0],s1h[1]);
			WriteFile(dst,out,s1h[0],&br,0);
		}
		else if (dw=='2DNS' && _s<BUF_SIZE-OUTBUF*2)
		{
			if (!wav_started)
			{
				InitWAV(dst,22050,1,2);
				wav_started=1;
			}
			ReadFile(src,buf,_s,&br,0);
			short* out=(short*)(buf+BUF_SIZE-OUTBUF*2);
			UINT n,no=0;
			UINT Code;
			int delta;
			for(n=0;n<2*_s;n++,no++)
			{
				if (no==OUTBUF)
				{
					WriteFile(dst,out,OUTBUF*2,&br,0);
					no=0;
				}

				if (n&1) Code=(buf[n>>1]>>4)&0x0F;
				else Code=buf[n>>1]&0x0F;
				delta=StepTab[index]>>3;
				if (Code & 4) delta+=StepTab[index];
				if (Code & 2) delta+=StepTab[index]>>1;
				if (Code & 1) delta+=StepTab[index]>>2;
				if (Code & 8) sample-=delta; else sample+=delta;
				if (sample>32767) sample=32767;
				else if (sample<-32768) sample=-32768;
				if (sample>0)
				{
					sample--;
				}
				else if (sample)
				{
					sample++;
				}
				out[no]=sample;
				index+=IndexTab[Code];
				if (index<0) index=0;
				else if (index>88) index=88;
			}
			if (no)
			{
				WriteFile(dst,out,no*2,&br,0);
				no=0;
			}
		}
		ofs+=_s;
		if (ofs&1) ofs++;
	}
	if (wav_started)
	{
		CloseWAV(dst);
		return ofs;
	}
	else return RIP_ERROR;
}

void _stdcall vqa_init(HKEY hk)
{
	DWORD s = sizeof(bool);
	RegQueryValueEx(hk,"vqa_convert",0,0,(BYTE*)&convert,&s);
}

void _stdcall vqa_quit(HKEY hk)
{
	RegSetValueEx(hk,"vqa_convert",0,REG_BINARY,(BYTE*)&convert,sizeof(bool));
}

typedef struct
{
	char *rn,*tx;
	bool cvt;
} DLGSTRUCT;

static BOOL CALLBACK DlgProc(HWND wnd,UINT msg,WPARAM wp,LPARAM lp)
{
	if (msg == WM_INITDIALOG)
	{
		DLGSTRUCT * st=(DLGSTRUCT*)lp;
		char tmp[64];
		wsprintf(tmp,"%s ripper settings",st->rn);
		SetWindowText(wnd,tmp);
		SetDlgItemText(wnd,IDC_CONVERT,st->tx);
		SendDlgItemMessage(wnd,IDC_CONVERT,BM_SETCHECK,st->cvt?BST_CHECKED:BST_UNCHECKED,0);
		return 1;
	}
	else if (msg == WM_COMMAND)
	{
		if (wp == IDOK)
		{
			EndDialog(wnd,SendDlgItemMessage(wnd,IDC_CONVERT,BM_GETCHECK,0,0)?1:0);
		}
		else if (wp == IDCANCEL)
		{
			EndDialog(wnd,-1);
		}
		return 1;
	}
	else return 0;	
}

void cvt_cfg(char* n,char* tx,bool* c,HWND w)
{
	DLGSTRUCT st={n,tx,*c};
	int r=DialogBoxParam(hIns,(char*)IDD_CVT,w,DlgProc,(long)&st);
	if (r!=-1) *c=r;
}

void _stdcall vqa_config(HWND wnd)
{
	cvt_cfg("VQA","extract sound only",&convert,wnd);
}

RIPPER VQA_ripper={vqa_test,0,_rv('FORM'),0xFFFFFFFF,0,vqa_rip,vqa_init,vqa_quit,vqa_config,"VQA",
"VQA - C&C movies"};