#include "main.h"

#pragma pack(push)
#pragma pack(1)

typedef struct
{
	BYTE rate,comp;
} BLOCK1HDR;

  typedef struct
{
	DWORD rate;
	BYTE bps;
	BYTE channels;
	BYTE unk[6];	
} BLOCK9HDR;

#pragma pack(pop)

#pragma pack(push)
#pragma pack(1)

typedef struct
{
	DWORD _riff,FileSize,_wave,_fmt,wf_size;
	WAVEFORMATEX format;
	DWORD _data,DataSize;
} WAV_HEADER;

#pragma pack(pop)

static DWORD wav_size=0;
static HANDLE hWav=0;
static DWORD wav_rate;
static BYTE wav_bps,wav_channels;
static bool convert = 1, expand = 0;

DWORD calc_rate(BYTE input)
{
	switch(input)
	{
	case 0x59:
	case 0x5A:
		return 6000;
	case 0x83:
		return 8000;
	case 0xA5:
	case 0xA6:
		return 11025;
	case 0xAD:
		return 12000;
	case 0xC2:
		return 16000;
	case 0xD3:
		return 22050;
	default:
		return 1000000/(256-input);
	}
}

bool OpenWAV(DWORD rate,BYTE bps,BYTE channels,HANDLE h)
{
	hWav=h;
	wav_size = 0;
	wav_rate=rate;wav_bps=bps;wav_channels=channels;
	SetFilePointer(hWav,sizeof(WAV_HEADER),0,FILE_BEGIN);
	return 1;
}

void WriteWAVData(BYTE* data,DWORD size)
{
	if (hWav)
	{
		DWORD bw;
		WriteFile(hWav,data,size,&bw,0);
		wav_size+=size;
	}
}

static void CloseWAV(bool keep)
{
	if (!hWav) return;
	if (keep)
	{
		DWORD bw;
		WAV_HEADER whd=
		{
			'FFIR',
			sizeof(WAV_HEADER)-8+wav_size,
			'EVAW',
			'\x20tmf',
			sizeof(WAVEFORMATEX),
			{
				WAVE_FORMAT_PCM,
				wav_channels,
				wav_rate,
				wav_rate*wav_channels*wav_bps/8,
				wav_channels*wav_bps/8,
				wav_bps,
				0		
			},
			'atad',wav_size
		};
		SetFilePointer(hWav,0,0,FILE_BEGIN);
		WriteFile(hWav,&whd,sizeof(whd),&bw,0);
	}
	hWav = 0;
}

#define CVF "Creative Voice File\x1a"
#define CVF_l 0x14

bool _stdcall test_voc(const void* hd,DWORD sz,char* info,char* ext)
{
	if (memcmp(hd,CVF,CVF_l)) return 0;
	if (sz<=CVF_l) return 0;
//	for(n=0;n<CVF_l;n++) if (((char*)hd)[n]!=CVF[n]) return 0;
	*info = 0;
	strcpy(ext,convert?"WAV":"VOC");
	return 1;
}


DWORD rip_voc1(HANDLE voc,HANDLE out)
{
	DWORD ret=0;
	DWORD br;
	BYTE voc_type;
	DWORD voc_size=0;

	ReadFile(voc,buf,0x14,&br,0);
	WriteFile(out,buf,0x14,&br,0);
	{
		WORD ofs;
		ReadFile(voc,&ofs,2,&br,0);
		if (br!=2) goto fail;
		WriteFile(out,&ofs,2,&br,0);
		ReadFile(voc,buf,ofs-0x16,&br,0);
		if (br != ofs-0x16) goto fail;
		WriteFile(out,buf,ofs-0x16,&br,0);
		ret=ofs;
	}
	while(1)
	{
		ReadFile(voc,&voc_type,1,&br,0);
		WriteFile(out,&voc_type,1,&br,0);
		ret++;
		if (voc_type==0) break;
		if (voc_type>=10) {goto fail;}
		ReadFile(voc,&voc_size,3,&br,0);
		WriteFile(out,&voc_size,3,&br,0);
		ret+=3;
		if (BUF_SIZE<voc_size) goto fail;
		ReadFile(voc,buf,voc_size,&br,0);
		WriteFile(out,buf,voc_size,&br,0);
		ret+=voc_size;		
	}
	goto _ok;
fail:
	ret = 0;
_ok:
	return ret;
}

DWORD _stdcall rip_voc(HANDLE voc,HANDLE out)
{
	if (!convert) return rip_voc1(voc,out);
	DWORD ret=0;
	DWORD br;
	BYTE voc_type;
	DWORD voc_size=0;
	SetFilePointer(voc,0x14,0,FILE_CURRENT);
	{
		WORD ofs;
		ReadFile(voc,&ofs,2,&br,0);
		SetFilePointer(voc,ofs-0x16,0,FILE_CURRENT);
		ret=ofs;
	}
	while(1)
	{
		ReadFile(voc,&voc_type,1,&br,0);
		ret++;
		if (voc_type==0) break;
		if (voc_type>=10) {goto fail;}
		ReadFile(voc,&voc_size,3,&br,0);
		ret+=3;
		switch(voc_type)
		{
		case 1:
			{
				DWORD s=voc_size-2;
				BLOCK1HDR b1h;
				ReadFile(voc,&b1h,2,&br,0);
				if (b1h.comp==0)
				{
					if (s>BUF_SIZE) goto fail;
					ReadFile(voc,buf,s,&br,0);
					if (!hWav) OpenWAV(calc_rate(b1h.rate),8,1,out);
					WriteWAVData(buf,s);
				}
				else SetFilePointer(voc,br=s,0,FILE_CURRENT);
			}
			break;
		case 2:
			if (hWav)
			{
				if (voc_size>BUF_SIZE) goto fail;
				ReadFile(voc,buf,voc_size,&br,0);
				WriteWAVData(buf,voc_size);
			}
			else 
			{
				SetFilePointer(voc,br=voc_size,0,FILE_CURRENT);
			}
			break;
		case 3:
			if (voc_size!=3)
			{
				goto fail;
			}
			if (hWav && expand)
			{
				WORD sl;
				ReadFile(voc,&sl,2,&br,0);
				SetFilePointer(voc,1,0,FILE_CURRENT);
				sl*=wav_bps/8*wav_channels;
				BYTE* tmp=(BYTE*)malloc(sl);
				if (tmp)
				{
					FillMemory(tmp,sl,wav_bps==8 ? 0x80 : 0);
					WriteWAVData(tmp,sl);
					free(tmp);
				}
			}
			else SetFilePointer(voc,br=3,0,FILE_CURRENT);
			break;
		case 9:
			{
				BLOCK9HDR b9h;
				ReadFile(voc,&b9h,12,&br,0);
				DWORD s=voc_size-12;
				if (s>BUF_SIZE) goto fail;
				ReadFile(voc,buf,s,&br,0);
				if (!hWav) OpenWAV(b9h.rate,b9h.bps,b9h.channels,out);
				WriteWAVData(buf,s);
			}
			break;
		default:
#ifdef _DEBUG
			{
				char tmp[100];
				wsprintf(tmp,"Unsupported block type: %u\n",voc_type);
				OutputDebugString(tmp);
			}
#endif
			SetFilePointer(voc,br=voc_size,0,FILE_CURRENT);
			break;
		}
		ret+=voc_size;
	}
	if (hWav) CloseWAV(1);
	else DBG("Warning: no data blocks extracted.");
	return ret;
fail:

	if (hWav) CloseWAV(0);
	return RIP_ERROR;
}

void _stdcall voc_init(HKEY hk)
{
	DWORD s = sizeof(bool);
	RegQueryValueEx(hk,"voc_convert",0,0,(BYTE*)&convert,&s);
	s = sizeof(bool);
	RegQueryValueEx(hk,"voc_expand",0,0,(BYTE*)&expand,&s);
}

void _stdcall voc_quit(HKEY hk)
{
	RegSetValueEx(hk,"voc_convert",0,REG_BINARY,(BYTE*)&convert,sizeof(bool));
	RegSetValueEx(hk,"voc_expand",0,REG_BINARY,(BYTE*)&expand,sizeof(bool));
}

BOOL CALLBACK VocDlgProc(HWND wnd,UINT msg,WPARAM wp,LPARAM lp)
{
	switch(msg)
	{
	case WM_INITDIALOG:
		SendDlgItemMessage(wnd,IDC_WAV,BM_SETCHECK,convert ? BST_CHECKED : BST_UNCHECKED,0);
		SendDlgItemMessage(wnd,IDC_EXPAND,BM_SETCHECK,expand ? BST_CHECKED : BST_UNCHECKED,0);
		if (!convert) EnableWindow(GetDlgItem(wnd,IDC_EXPAND),0);
		return 1;
	case WM_COMMAND:
		if (HIWORD(wp) == BN_CLICKED)
			switch(LOWORD(wp))
			{
			case IDOK:
				convert = SendDlgItemMessage(wnd,IDC_WAV,BM_GETCHECK,0,0);
				expand = SendDlgItemMessage(wnd,IDC_EXPAND,BM_GETCHECK,0,0);
				EndDialog(wnd,1);
				break;
			case IDCANCEL:
				EndDialog(wnd,0);
				break;
			case IDC_WAV:
				EnableWindow(GetDlgItem(wnd,IDC_EXPAND),SendDlgItemMessage(wnd,IDC_WAV,BM_GETCHECK,0,0));
				break;
			}
		return 1;
	default:
		return 0;
	}
}

void _stdcall voc_config(HWND wnd)
{
	DialogBox(hIns,(char*)IDD_VOC,wnd,VocDlgProc);
}

RIPPER VOC_ripper={test_voc,0,'aerC',0xFFFFFFFF,0,rip_voc,voc_init,voc_quit,voc_config,"VOC","Creative Voice File (waveform)\x0D\x0AUsed to store sound effects in many DOS games."};