#include "main.h"
//#include <mmreg.h>

static bool rip_wav = 1, rip_avi = 1, rip_unk = 1;
static bool _max=0,_min=0;
static UINT max_s=0,min_s=0;
static bool rmi2mid=0;


void xfer(HANDLE src,HANDLE dst,DWORD s)
{
	DWORD br;
	while(s>BUF_SIZE)
	{
		ReadFile(src,buf,BUF_SIZE,&br,0);
		WriteFile(dst,buf,BUF_SIZE,&br,0);
		s-=BUF_SIZE;
	}
	if (s)
	{
		ReadFile(src,buf,s,&br,0);
		WriteFile(dst,buf,s,&br,0);
	}
}


#define hd ((DWORD*)_hd)
bool _stdcall test_riff(const void* _hd,DWORD sz,char* info,char* ext)
{
	DWORD _s;
	if ((sz>12) && ((_s=hd[1])<=sz) && ValidText((char*)_hd+8,8))
	{
		if ((_max && _s>(max_s<<10)) || (_min && _s<(min_s<<10))) goto fail;
		if (hd[2]=='EVAW') {if (!rip_wav) goto fail;}
		else if (hd[2]==0x20495641) {if (!rip_avi) goto fail;}
		else if (!rip_unk) goto fail;
		union
		{
			char c[5];
			DWORD d;
		} code;
		code.c[4]=0;
		code.d=hd[2];
		wsprintf(info,"Format code: %s; file size: %u bytes",code.c,8+hd[1]);
		char *_i=0;
		char *_ext;
		switch(hd[2])
		{
		case _rv('ACON'):
			_ext = "ANI";
			_i = "Animated cursor";
			break;
		case _rv('WAVE'):
			_ext = "WAV";
			_i = "WAV file";
			break;
		case _rv('RMID'):
			_ext = "RMI";
			_i = "RIFF MIDI (RMI)";
			break;
		case _rv('sfbk'):
			_ext = "SF2";
			_i = "SoundFont";
			break;
		case _rv('DMSG'):
			_ext = "SGT";
			_i = "DirectMusic segment";
			break;
		case _rv('AASE'):
			_ext = "SEC";
			_i = "DirectMusic segment";
			break;
		case _rv('AASY'):
		case _rv('DMST'):
			_ext = "STY";
			_i = "DirectMusic style";
			break;
		case _rv('AASO'):
			_ext = "SJM";
			break;
		case _rv('PAL '):
			_ext = "PAL";
			_i = "Palette";
			break;
		case _rv('DLS '):
			_ext = "DLS";
			_i = "DirectMusic downloadable sounds (DLS) collection";
			break;
		case _rv('MLS '):
			_ext = "MLS";
			_i = "Compressed downloadable sounds (MLS) collection";
			break;
		case _rv('DMPR'):
			_ext = "PER";
			_i = "DirecMusic chordmap";
			break;
		case _rv('DMBT'):
		case _rv('DMBD'):
			_ext = "BND";
			_i = "DirectMusic band";
			break;
		case _rv('DMTL'):
			_ext = "TOL";
			_i = "DirectMusic tool";
			break;
		case _rv('DMTG'):
			_ext = "TLG";
			_i = "DirectMusic tool graph";
			break;
		case _rv('AABN'):
		case _rv('DMTK'):
			_ext = "TRK";
			_i = "DirectMusic track";
			break;
		default:
			if (code.c[3]==' ') code.c[3]=0;
			_ext = code.c;
		}
		strcpy(ext,_ext);
		if (_i)
		{
			strcat(info,"\n");
			strcat(info,_i);
		}
		return 1;
	}
fail:
	return 0;
}
#undef hd

DWORD _stdcall rip_riff(HANDLE in,HANDLE out)
{
	DWORD br,_riff,riff_size,type;
	ReadFile(in,&_riff,4,&br,0);
	ReadFile(in,&riff_size,4,&br,0);
	ReadFile(in,&type,4,&br,0);
	WriteFile(out,&_riff,4,&br,0);
	WriteFile(out,&riff_size,4,&br,0);
	WriteFile(out,&type,4,&br,0);
	if (riff_size&1) riff_size++;
	
	if (out!=INVALID_HANDLE_VALUE)
	{
		xfer(in,out,riff_size-4);
	}
	return riff_size+8;
/*fail:
	DBG("RIFF ripping failed.\n");
	return RIP_ERROR;*/
}

void EnableMin(HWND w,bool b)
{
	EnableWindow(GetDlgItem(w,IDC_MIN1),b);
	EnableWindow(GetDlgItem(w,IDC_MINKB),b);
}

void EnableMax(HWND w,bool b)
{
	EnableWindow(GetDlgItem(w,IDC_MAX1),b);
	EnableWindow(GetDlgItem(w,IDC_MAXKB),b);
}

BOOL CALLBACK RiffDlgProc(HWND wnd,UINT msg,WPARAM wp,LPARAM lp)
{
	switch(msg)
	{
	case WM_INITDIALOG:
		SendDlgItemMessage(wnd,IDC_WAV,BM_SETCHECK,rip_wav ? BST_CHECKED : BST_UNCHECKED,0);
		SendDlgItemMessage(wnd,IDC_AVI,BM_SETCHECK,rip_avi ? BST_CHECKED : BST_UNCHECKED,0);
		SendDlgItemMessage(wnd,IDC_UNK,BM_SETCHECK,rip_unk ? BST_CHECKED : BST_UNCHECKED,0);
		SendDlgItemMessage(wnd,IDC_MIN,BM_SETCHECK,_min ? BST_CHECKED : BST_UNCHECKED,0);
		SendDlgItemMessage(wnd,IDC_MAX,BM_SETCHECK,_max ? BST_CHECKED : BST_UNCHECKED,0);
		SetDlgItemInt(wnd,IDC_MIN1,min_s,0);
		SetDlgItemInt(wnd,IDC_MAX1,max_s,0);
		EnableMin(wnd,_min);
		EnableMax(wnd,_max);
		return 1;
	case WM_COMMAND:
		if (HIWORD(wp) == BN_CLICKED)
			switch(LOWORD(wp))
			{
			case IDOK:
				rip_wav = SendDlgItemMessage(wnd,IDC_WAV,BM_GETCHECK,0,0);
				rip_avi = SendDlgItemMessage(wnd,IDC_AVI,BM_GETCHECK,0,0);
				rip_unk = SendDlgItemMessage(wnd,IDC_UNK,BM_GETCHECK,0,0);
				_min = SendDlgItemMessage(wnd,IDC_MIN,BM_GETCHECK,0,0);
				_max = SendDlgItemMessage(wnd,IDC_MAX,BM_GETCHECK,0,0);
				min_s = GetDlgItemInt(wnd,IDC_MIN1,0,0);
				max_s = GetDlgItemInt(wnd,IDC_MAX1,0,0);				
				EndDialog(wnd,1);
				break;
			case IDCANCEL:
				EndDialog(wnd,0);
				break;
			case IDC_MIN:
				EnableMin(wnd,SendDlgItemMessage(wnd,IDC_MIN,BM_GETCHECK,0,0));
				break;
			case IDC_MAX:
				EnableMax(wnd,SendDlgItemMessage(wnd,IDC_MAX,BM_GETCHECK,0,0));
				break;
			}
		return 1;
	default:
		return 0;
	}
}

void _stdcall riff_config(HWND wnd)
{
	DialogBox(hIns,(char*)IDD_RIFF,wnd,RiffDlgProc);
}

void _stdcall riff_init(HKEY hk)
{
	DWORD s = sizeof(bool);
	RegQueryValueEx(hk,"riff_ripwav",0,0,(BYTE*)&rip_wav,&s);
	s = sizeof(bool);
	RegQueryValueEx(hk,"riff_ripavi",0,0,(BYTE*)&rip_avi,&s);
	s = sizeof(bool);
	RegQueryValueEx(hk,"riff_ripunk",0,0,(BYTE*)&rip_unk,&s);
	s = sizeof(bool);
	RegQueryValueEx(hk,"riff_min",0,0,(BYTE*)&_min,&s);
	s = sizeof(bool);
	RegQueryValueEx(hk,"riff_max",0,0,(BYTE*)&_max,&s);
	s = sizeof(int);
	RegQueryValueEx(hk,"riff_min_s",0,0,(BYTE*)&min_s,&s);
	s = sizeof(int);
	RegQueryValueEx(hk,"riff_max_s",0,0,(BYTE*)&max_s,&s);

}

void _stdcall riff_quit(HKEY hk)
{
	RegSetValueEx(hk,"riff_ripwav",0,REG_BINARY,(BYTE*)&rip_wav,sizeof(bool));
	RegSetValueEx(hk,"riff_ripavi",0,REG_BINARY,(BYTE*)&rip_avi,sizeof(bool));
	RegSetValueEx(hk,"riff_ripunk",0,REG_BINARY,(BYTE*)&rip_unk,sizeof(bool));
	RegSetValueEx(hk,"riff_min",0,REG_BINARY,(BYTE*)&_min,sizeof(bool));
	RegSetValueEx(hk,"riff_max",0,REG_BINARY,(BYTE*)&_max,sizeof(bool));
	RegSetValueEx(hk,"riff_min_s",0,REG_BINARY,(BYTE*)&min_s,sizeof(int));
	RegSetValueEx(hk,"riff_max_s",0,REG_BINARY,(BYTE*)&max_s,sizeof(int));
}

RIPPER RIFF_ripper={test_riff,0,'FFIR',0xFFFFFFFF,0,rip_riff,riff_init,riff_quit,riff_config,"RIFF",
"RIFF - Resource Interchange File Format\x0D\x0A"
"Probably the most common format in Win9x PC games.\x0D\x0A"
"Includes DirectMusic / IMA specific types."};

static bool wav2mp3=1;

#define hd ((DWORD*)_hd)
bool _stdcall wav_test(const void* _hd,DWORD sz,char* info,char* ext)
{
	DWORD _s;
	if ((sz>12) && ((_s=hd[1])<=sz) && ValidText((char*)_hd+8,8) && hd[2]=='EVAW')
	{
		WAVEFORMAT* wf=(WAVEFORMAT*)((BYTE*)_hd+0x14);
		wsprintf(info,"Size: %u bytes",_s);
		*(DWORD*)ext= (wf->wFormatTag==0x55 && wav2mp3) ? '3PM' : 'VAW';
		return 1;
	}
	return 0;
}

DWORD _stdcall frip_wav(HANDLE src,HANDLE dst)
{
	if (!wav2mp3) return rip_riff(src,dst);
	SetFilePointer(src,0x14,0,FILE_CURRENT);
	WORD fmt;
	DWORD br;
	ReadFile(src,&fmt,2,&br,0);
	SetFilePointer(src,-0x16,0,FILE_CURRENT);
	if (fmt!=0x55) return rip_riff(src,dst);
	SetFilePointer(src,4,0,FILE_CURRENT);
	DWORD rs;
	ReadFile(src,&rs,4,&br,0);
	SetFilePointer(src,4,0,FILE_CURRENT);
	DWORD dw;
	DWORD sz=0;
	do
	{
		if (sz&1) sz++;
		SetFilePointer(src,sz,0,FILE_CURRENT);
		br=0;
		ReadFile(src,&dw,4,&br,0);
		if (!br) return RIP_ERROR;
		br=0;
		ReadFile(src,&sz,4,&br,0);
		if (!br) return RIP_ERROR;
	} while(dw!=_rv('data'));
	xfer(src,dst,sz);
	return rs+8;
}

void _stdcall wav_init(HKEY hk)
{
	DWORD s = sizeof(bool);
	RegQueryValueEx(hk,"wav_mp3",0,0,(BYTE*)&wav2mp3,&s);
}

void _stdcall wav_quit(HKEY hk)
{
	RegSetValueEx(hk,"wav_mp3",0,REG_BINARY,(BYTE*)&wav2mp3,sizeof(bool));
}

void _stdcall wav_config(HWND wnd)
{
	cvt_cfg("WAV","convert MPEG-layer 3 WAVs to MP3",&wav2mp3,wnd);
}

RIPPER WAV_ripper={wav_test,0,'FFIR',0xFFFFFFFF,0,frip_wav,wav_init,wav_quit,wav_config,"WAV","WAV - windows wave files"};

bool _stdcall rmi_test(const void* _hd,DWORD sz,char* info,char* ext)
{
	DWORD _s;
	if ((sz>12) && ((_s=hd[1])<=sz) && ValidText((char*)_hd+8,8) && hd[2]==_rv('RMID'))
	{
		wsprintf(info,"Size: %u bytes",_s);
		*(DWORD*)ext=rmi2mid ? 'DIM' : 'IMR';
		return 1;
	}
	return 0;
}

void _stdcall rmi_init(HKEY hk)
{
	DWORD s = sizeof(bool);
	RegQueryValueEx(hk,"rmi_convert",0,0,(BYTE*)&rmi2mid,&s);
}

void _stdcall rmi_quit(HKEY hk)
{
	RegSetValueEx(hk,"rmi_convert",0,REG_BINARY,(BYTE*)&rmi2mid,sizeof(bool));
}

void _stdcall rmi_config(HWND wnd)
{
	cvt_cfg("RMI","convert to MID",&rmi2mid,wnd);
}

DWORD _stdcall rip_rmi(HANDLE src,HANDLE dst)
{
	if (!rmi2mid) return rip_riff(src,dst);
	SetFilePointer(src,4,0,FILE_CURRENT);
	DWORD br,ret;
	ReadFile(src,&ret,4,&br,0);
	ret+=8;
	SetFilePointer(src,8,0,FILE_CURRENT);
	DWORD ms;
	ReadFile(src,&ms,4,&br,0);
	xfer(src,dst,ms);
	return ret;
}

RIPPER RMI_ripper={rmi_test,0,'FFIR',0xFFFFFFFF,0,rip_rmi,rmi_init,rmi_quit,rmi_config,"RMI","RMI - RIFF MIDI"};

bool _stdcall avi_test(const void* _hd,DWORD sz,char* info,char* ext)
{
	DWORD _s;
	if ((sz>12) && ((_s=hd[1])<=sz) && ValidText((char*)_hd+8,8) && hd[2]==_rv('AVI '))
	{
		wsprintf(info,"Size: %u bytes",_s);
		*(DWORD*)ext='IVA';
		return 1;
	}
	return 0;
}

RIPPER AVI_ripper={avi_test,0,'FFIR',0xFFFFFFFF,0,rip_riff,0,0,0,"AVI","AVI - audio-video interleaved"};

#define hd ((DWORD*)_hd)
bool _stdcall riff_test1(const void* _hd,DWORD sz,char* info,char* ext)
{
	DWORD _s;
	if ((sz>12) && ((_s=hd[1])<=sz) && ValidText((char*)_hd+8,8))
	{
		return 1;
	}
	else return 0;
}

DWORD _stdcall riff_skip(HANDLE s)
{
	SetFilePointer(s,4,0,FILE_CURRENT);
	DWORD dw,br;
	ReadFile(s,&dw,4,&br,0);
	return dw+8;
}

SKIPPER RIFF_skipper={riff_test1,1,_rv('RIFF'),0xFFFFFFFF,0,riff_skip,0};

DWORD _fastcall rev32(DWORD);

#define hd ((DWORD*)_hd)
bool _stdcall test_per(const void* _hd,DWORD sz,char* info,char* ext)
{
	DWORD _s=rev32(hd[1]);
	if (sz>8 && _s+8<=sz && _s<BUF_SIZE)
	{
		*info=0;
		*(DWORD*)ext='REP';
		return 1;
	}
	return 0;
}
#undef hd

DWORD _stdcall rip_per(HANDLE in,HANDLE out)
{
	DWORD dw,br;
	ReadFile(in,&dw,4,&br,0);
	WriteFile(out,&dw,4,&br,0);
	ReadFile(in,&dw,4,&br,0);
	WriteFile(out,&dw,4,&br,0);
	dw=rev32(dw);
	ReadFile(in,buf,dw,&br,0);
	if (dw!=br) goto fail;
	WriteFile(out,buf,dw,&br,0);
	if (dw!=br) goto fail;
	return dw+8;
fail:
	return RIP_ERROR;
}

RIPPER PER_ripper={test_per,0,'sPER',0xFFFFFFFF,0,rip_per,0,0,0,"PER","PER - old DirectMusic chordmap format"};

static const BYTE wma_hd[]={0x8e,0x66,0xcf,0x11,0xa6,0xd9,0x00,0xaa,0x00,0x62,0xce,0x6c};

bool _stdcall test_wma(const void* _hd,DWORD max,char* info,char* ext)
{
	if (!memcmp((BYTE*)_hd+4,wma_hd,sizeof(wma_hd)))
	{
		DWORD sz=*(DWORD*)((BYTE*)_hd+0x46);
		if (sz > 0x50 && sz<=max)
		{
			*(DWORD*)ext='AMW';
			wsprintf(info,"File size: %u",sz);
			return 1;
		}
	}
	return 0;
}

DWORD _stdcall rip_wma(HANDLE src,HANDLE dst)
{
	SetFilePointer(src,0x46,0,FILE_CURRENT);
	DWORD sz,br,_r;
	ReadFile(src,&sz,4,&br,0);
	_r=sz;
	SetFilePointer(src,-0x4A,0,FILE_CURRENT);
	xfer(src,dst,sz);
	return _r;
}

RIPPER WMA_ripper={test_wma,0,_rv(0x3026b275),0xFFFFFFFF,0,rip_wma,0,0,0,"WMA","Windows Media Audio"};