#ifndef PP_CRT_H
#define PP_CRT_H

#ifndef PP_NO_INTR
#define INTR_HACK
#endif

#define PP_CRT_INSIDE

#define STRICT
#include <windows.h>
//shut up common useless warnings
#pragma warning(disable:4005)
#pragma warning(disable:4244)
#pragma warning(disable:4800)
#pragma warning(disable:4305)

#ifndef _CONSOLE
#define PP_NO_CONSOLE
#endif
/*
#ifndef PP_USE_CONSOLE
#define PP_NO_CONSOLE
#endif

#ifndef PP_USE_ARG
#define PP_NO_ARG
#endif

#ifndef PP_USE_MEM
#define PP_NO_MEM
#endif
*/

#if !defined(PP_NO_ARG) || !defined(PP_NO_MEM) || !defined(PP_NO_CONSOLE)
void crt_init();
#else
#define crt_init()
#endif

#ifndef PP_NO_ARG
#define PP_MAX_ARG 16
extern unsigned int argc;
extern char* argv[PP_MAX_ARG];
#endif	//PP_NO_ARG

#ifndef PP_NO_CONSOLE
void putchar(int c);
int getchar();
int kbhit();
void print(char* s);
void print_i(int i);
void print_ui(unsigned int i);
#define puteol() {putchar(13);putchar(10);}
extern HANDLE hStdOut;
extern HANDLE hStdIn;
#endif	//PP_NO_CONSOLE

#ifndef PP_NO_MEM
extern HANDLE hHeap;

#ifdef HUNT_LEAKS
void* _cdecl l_malloc(int x);
void* _cdecl l_z_malloc(int x);
void* _cdecl l_realloc(void* b,int x);
void* _cdecl l_z_realloc(void* b,int x);
void _cdecl l_free(void* x);
#define malloc l_malloc
#define z_malloc l_z_malloc
#define realloc l_realloc
#define z_realloc l_z_realloc
#define free l_free
void crt_quit();
#else
#define malloc(X) HeapAlloc(hHeap,0,X)
#define realloc(X,Y) HeapReAlloc(hHeap,0,X,Y)
#define z_realloc(X,Y) HeapReAlloc(hHeap,HEAP_ZERO_MEMORY,X,Y)
#define z_malloc(X) HeapAlloc(hHeap,HEAP_ZERO_MEMORY,X)
#define free(X) HeapFree(hHeap,0,X)
#define crt_quit()
#endif	//HUNT_LEAKS

#endif	//PP_NO_MEM

void _stdcall __memmove(void *a,void *b,UINT s);
void _fastcall _zeromem(UINT,void*);
char* _fastcall __strcpy(char*,const char*);
void _fastcall __memcpy(void*,void*,UINT);
void _cdecl r_memcpy(void* p1,void* p2,UINT s);	//cheap ass memmove replacement
UINT _fastcall __strlen(char*);
int _fastcall __strcmp(char*,char*);
BOOL _fastcall __memcmp(void*,void*,UINT);
#define memmove __memmove
#ifndef INTR_HACK
#define ZeroMemory(x,y) _zeromem(y,x);
#define strcpy(x,y) __strcpy(x,y);
#define memcpy(x,y,z) __memcpy(x,y,z)
#define strcat(s1,s2) strcpy(s1+strlen(s1),s2)
#define strlen __strlen
#define strcmp __strcmp
#define memcmp __memcmp
#endif

void __strncpy(char* dst,char* src,UINT cnt);
#define strncpy __strncpy
char* _fastcall __strrchr(char*,int);
#define strrchr __strrchr
int __strncmp(char*,char*,int);
#define strncmp __strncmp
int _fastcall __stricmp(char*,char*);
#define stricmp __stricmp
char* _fastcall __strchr(char*,int);
#define strchr __strchr
int _fastcall __tolower(int);
#define tolower __tolower
void _inline __strlwr(char* str) {while(*str) {*str=__tolower(*str);str++;}}
#define strlwr __strlwr
#define _stricmp __stricmp
void __srand(int);
#define srand __srand
int __rand();
#define rand __rand

double _stdcall __atof(const char* s);
#define atof __atof
void _stdcall __gcvt_(double val,char* out);
#define gcvt(A,B,C) __gcvt_(A,C)

int __atoi(char* s);
UINT atoui(char* s);
void __itoa(int i,char* s);
void uitoa(unsigned int i,char* s);
#define atoi __atoi
#define itoa __itoa
#define _itoa(X,Y,Z) __itoa(X,Y)

UINT read_line(HANDLE f,char* buf,UINT s);
char* scan_fn(char* s,char* buf);
char* scan_int(char* s,UINT *r);
char* skip_space(char* s);


double _stdcall __pow(double a,double b);
double _stdcall __atan2(double y,double x);
#define pow __pow
#define atan2 __atan2

#ifdef INTR_HACK
//#pragma optimize("i",on) MSVC5 doesn't get it
#ifdef __cplusplus
extern "C"	//hack; MSVC 'intrinsic' funcs
{
#endif
		long	__cdecl labs(long);
		double  __cdecl fabs(double);
		double  __cdecl sin(double);
		double  __cdecl cos(double);
        double  __cdecl tan(double);
        double  __cdecl sqrt(double);
		double  __cdecl log(double);
#define log10(X) (log(X)/log(10))
        int     __cdecl memcmp(const void *, const void *, size_t);
        void *  __cdecl memcpy(void *, const void *, size_t);
        void *  __cdecl memset(void *, int, size_t);
		char *  __cdecl strcpy(char *, const char *);
		char *  __cdecl strcat(char *, const char *);
		int     __cdecl strcmp(const char *, const char *);
		UINT    __cdecl strlen(const char *);
#ifdef __cplusplus
}
#endif
#endif

#define wcstombs(a,b,c) WideCharToMultiByte(CP_ACP,0,b,-1,a,c,0,0)
#define mbstowcs(a,b,c)	MultiByteToWideChar(CP_ACP,0,b,-1,a,c)

DWORDLONG _fastcall q_UInt32x32To64(DWORD u1,DWORD u2);
#define UInt32x32To64 q_UInt32x32To64
//int _fastcall q_MulDiv(int n1,int n2,int d);
//#define MulDiv q_MulDiv
int _stdcall div64(__int64 i,int i1);

#endif //PP_CRT_H