#include "pp_crt.h"

#define CMD_MAX 512

#ifndef PP_NO_ARG
static char cmdline[CMD_MAX];
unsigned int argc;
char* argv[PP_MAX_ARG];
#endif

#ifndef PP_NO_CONSOLE
HANDLE hStdOut;
HANDLE hStdIn;
#endif

#ifndef PP_NO_MEM
extern "C" {HANDLE hHeap;}
#endif

#if !defined(PP_NO_ARG) || !defined(PP_NO_MEM) || !defined(PP_NO_CONSOLE)
void crt_init()
{
#ifndef PP_NO_ARG
	{
		char* p=GetCommandLine();
		unsigned int n=0;
		while(p[n] && n<CMD_MAX) {cmdline[n]=p[n];n++;}
		cmdline[n]=0;
		argc=0;
		p=cmdline;
		while(*p && argc<PP_MAX_ARG)
		{
			while(*p && *p==' ') p++;
			if (!*p) break;
			if (*p=='\"')
			{
				p++;
				argv[argc++]=p;
				while(*p && *p!='\"') p++;
				if (*p) *(p++)=0;
			}
			else
			{
				argv[argc++]=p;
				while(*p && *p!=' ') p++;
				if (*p) *(p++)=0;
			}
		}
	}

#endif
#ifndef PP_NO_MEM
	hHeap=GetProcessHeap();
#endif
#ifndef PP_NO_CONSOLE
	hStdIn=GetStdHandle(STD_INPUT_HANDLE);
	hStdOut=GetStdHandle(STD_OUTPUT_HANDLE);
	{
		DWORD m=0;
		if (GetConsoleMode(hStdIn,&m))
		{
			m&=~(ENABLE_LINE_INPUT|ENABLE_ECHO_INPUT);
			SetConsoleMode(hStdIn,m);
		}
	}
#endif
}
#endif //!defined(PP_NO_ARG) || !defined(PP_NO_MEM) || !defined(PP_NO_CONSOLE)

#ifndef PP_NO_CONSOLE

void putchar(int c)
{
	DWORD bw;
	WriteFile(hStdOut,&c,1,&bw,0);	
}

int getchar()
{
	int r=0;
	DWORD br=0;
	ReadFile(hStdIn,&r,1,&br,0);
	return r;
}

int kbhit()
{
	DWORD ev=0;
	GetNumberOfConsoleInputEvents(hStdIn,&ev);
	if (!ev) return 0;
	while(ev)
	{
		DWORD rd=0;
		INPUT_RECORD rec;
		PeekConsoleInput(hStdIn,&rec,1,&rd);
		if (!rd) return 0;
		if (rec.EventType==KEY_EVENT && rec.Event.KeyEvent.bKeyDown) return 1;
		else ReadConsoleInput(hStdIn,&rec,1,&rd);
		ev--;
	}
	return 0;
}

void print(char* c)
{
//	while(*c) putchar(*(c++));
	DWORD bw;
	WriteFile(hStdOut,c,strlen(c),&bw,0);
}

void print_ui(unsigned int i)
{
	char buf[16];
	uitoa(i,buf);
	print(buf);
}

void print_i(int i)
{
	if (i<0) {putchar('-');i=-i;}
	print_ui((unsigned)i);
}

#endif

UINT atoui(char* s)
{
	int ret=0;
	while(*s>='0' && *s<='9') {ret=10*ret+(*s-'0');s++;}
	return ret;
}


int atoi(char* s)
{
	bool m=0;
	if (*s=='-') {m=1;s++;}
	int ret=atoui(s);
	if (m) ret=-ret;
	return ret;
}

void itoa(int i,char* s)
{
	if (i<0) *(s++)='-';
	uitoa((unsigned)i,s);
}

void uitoa(unsigned int i,char* s)
{
	if (!i) {s[0]='0';s[1]=0;return;}
	char buf[16];
	unsigned pos=0;
	while(i)
	{
		buf[pos++]=(i%10)+'0';
		i/=10;
	}
	unsigned n;
	for(n=0;n<pos;n++) s[n]=buf[pos-1-n];
	s[n]=0;
}


_declspec(naked) void _fastcall _zeromem(UINT x,void* mem)
{
	_asm
	{
		push edi
		xor eax,eax
		mov edi,edx
		repe stosb
		pop edi
		ret
	}
}

_declspec(naked) char* _fastcall __strcpy(char*,const char*)
{
	_asm
	{//edx->ecx
l:
		mov al,[edx]
		inc edx
		mov [ecx],al
		test al,al
		lea ecx,[ecx+1]
		jnz l
		lea eax,[ecx-1]
		ret
	}
}

void _cdecl r_memcpy(void* p1,void* p2,UINT sz)
{
	char* s=(char*)p2,*d=(char*)p1;
	int n;
	for(n=sz-1;n>=0;n--) d[n]=s[n];
}

_declspec(naked) void _fastcall __memcpy(void*,void*,UINT)
{
	_asm
	{
		push edi
		push esi
		mov edi,ecx
		mov esi,edx
		mov ecx,[esp+8+4]
		repe movsb
		pop esi
		pop edi		
		ret 4
	}
}

_declspec(naked) UINT _fastcall __strlen(char*)
{
	_asm
	{
		mov eax,0xFFFFFFFF
l0:		inc eax
		cmp [ecx+eax],0
		jne l0	
		ret
	}
}

_declspec(naked) BOOL _fastcall __memcmp(void*,void*,UINT)
{
	_asm
	{
		push edi
		push esi
		mov edi,ecx
		mov esi,edx
		mov ecx,[esp+8+4]
		repe cmpsb
		mov eax,ecx		
		pop esi
		pop edi
		ret 4
	}
}

int __strncmp(char* s1,char* s2,int m)
{
	int n;
	for(n=0;n<m;n++)
	{
		if (!s1[n] || !s2[n] || s1[n]!=s2[n]) return 1;
	}
	return 0;
}

_declspec(naked) int _fastcall __strcmp(char* s1,char* s2)
{
	_asm
	{
l0:
		mov al,[ecx]
		inc ecx
		cmp al,[edx]
		jnz r1
		test al,al
		lea edx,[edx+1]
		jnz l0
		xor eax,eax
		ret
r1:
		mov eax,1
		ret
	}
	
}


UINT read_line(HANDLE f,char* buf,UINT s)
{
	DWORD br=0;
	ReadFile(f,buf,s,&br,0);
	if (br==0) {buf[0]=0;return -1;}
	if (br<s) s=br;
	UINT n;
	UINT eol=-1;
	for(n=0;n<s-1;n++)
	{
		if (*(WORD*)(buf+n)==0x0a0d) {eol=n;break;}
	}
	if (eol==-1) eol=s;
	else SetFilePointer(f,eol+2-br,0,FILE_CURRENT);
	buf[eol]=0;
	return eol;
}

char* scan_fn(char* s,char* buf)
{
	UINT n=0;
	if (s[0]=='\"')
	{
		while(n<MAX_PATH && s[n+1] && s[n+1]!='\"') {buf[n]=s[n+1];n++;}
		buf[n]=0;
		n++;
		if (s[n]=='\"') n++;
	}
	else
	{
		while(n<MAX_PATH && s[n] && s[n]!=' ') {buf[n]=s[n];n++;}
		buf[n]=0;
	}	
	return skip_space(s+n);
}

char* scan_int(char* s,UINT *r)
{
	*r=atoi(s);
	while(*s>='0' && *s<='9') s++;
	return skip_space(s);
}

char* skip_space(char* s)
{
	while(*s && *s==' ') s++;
	return s;
}

char* _fastcall __strrchr(char* s,int c)
{
	char* p=0;
	while(*s)
	{
		if (*s==c) p=s;
		s++;
	}
	return p;
}

int _fastcall __stricmp(char* s1,char* s2)
{
s:
	if (tolower(*s1)!=tolower(*s2)) return 1;
	if (!*s1) return 0;
	s1++;
	s2++;
	goto s;
}

char* _fastcall __strchr(char* s,int c)
{
	while(*s)
	{
		if (*s==c) return s;
		s++;
	}
	return 0;
}

int _fastcall __tolower(int c)
{
	if (c>='A' && c<='Z') return c-'A'+'a';
	else return c;
}

static int rand_s;

void __srand(int t)
{
	rand_s=t;
}

int __rand()
{
	rand_s=rand_s^(rand_s>>16)^GetTickCount();
	return rand_s%RAND_MAX;
}

_declspec(naked) double _stdcall __atan2(double a,double b)
{
	_asm
	{
		fld qword ptr [esp+4]
		fld qword ptr [esp+4+8]
		fpatan
		ret 16
	}
}
_declspec(naked) double _stdcall __pow(double a,double b)
{
	_asm
	{
		fld qword ptr [esp+4+8]//b
		fld qword ptr [esp+4]//a
		fyl2x
		fld1
		fld st(1)
		fprem
		fstp st(1)
		f2xm1
		fld1
		fadd
		fscale
		fstp st(1)
		ret 16
	}
}

#ifndef PP_NO_MEM
void* _cdecl operator new(UINT n) {return z_malloc(n);}
void _cdecl operator delete(void* x) {free(x);}
#endif

#if defined(NDEBUG)
extern "C" {
	void _cdecl _fltused() {}
	_declspec(naked) long _cdecl _ftol()
	{
		_asm
		{
			sub esp,4
			fstcw word ptr [esp]
			or word ptr [esp],0x0C00
			fldcw word ptr [esp]
			fistp dword ptr [esp]
			pop eax
			ret
		}
	}
}
#endif

_declspec(naked) DWORDLONG _fastcall q_UInt32x32To64(DWORD u1,DWORD u2)
{
	_asm
	{
		mov eax,ecx
		mul edx
		ret
	}
}
/*
_declspec(naked) int _fastcall q_MulDiv(int n1,int n2,int d)
{
	_asm
	{
		mov eax,ecx
		mul edx
		div dword ptr [esp+4]
		ret 4
	}

}
*/
_declspec(naked) int _stdcall div64(__int64 i,int i1)
{
	_asm
	{
		mov eax,[esp+4]
		mov edx,[esp+8]
		idiv dword ptr [esp+12]		
		ret 12
	}
}

#ifdef HUNT_LEAKS

static UINT blk_count;

#define TAB_MAX 1024

static void * ptr_tab[TAB_MAX];

static UINT findptr(void* p)
{
	UINT n;
	for(n=0;n<TAB_MAX;n++)
	{
		if (ptr_tab[n]==p) return n;
	}
	return -1;
}
static UINT addptr(void* p)
{
	UINT n;
	for(n=0;n<TAB_MAX;n++)
	{
		if (!ptr_tab[n]) {ptr_tab[n]=p;return n;}
	}
	return -1;
}

void* _cdecl l_malloc(int x)
{
	void * r = HeapAlloc(hHeap,0,x);
	if (r)
	{
		blk_count++;
		addptr(r);
	}
	return r;
}

void* _cdecl l_z_malloc(int x)
{
	void * r = HeapAlloc(hHeap,HEAP_ZERO_MEMORY,x);
	if (r)
	{
		blk_count++;
		addptr(r);
	}
	return r;
}

void* _cdecl l_realloc(void* b,int x)
{
	UINT p=findptr(b);
	void* r=HeapReAlloc(hHeap,0,b,x);
	if (r && p!=-1) ptr_tab[p]=r;
	return r;
}

void* _cdecl l_z_realloc(void* b,int x)
{
	UINT p=findptr(b);
	void* r=HeapReAlloc(hHeap,HEAP_ZERO_MEMORY,b,x);
	if (r && p!=-1) ptr_tab[p]=r;
	return r;
}

void _cdecl l_free(void* x)
{
	if (!x)
	{
		MessageBox(0,"warning: attempting to free null block","PPcrt",0);
		return;
	}
	if (!HeapValidate(hHeap,0,x))
	{
		MessageBox(0,"warning: attempting to free invalid block","PPcrt",0);
		return;
	}
	UINT p=findptr(x);
	if (p==-1)
	{
		MessageBox(0,"warning: attempting to free invalid block","PPcrt",0);
		return;
	}
	ptr_tab[p]=0;
	blk_count--;
	HeapFree(hHeap,0,x);
}

void crt_quit()
{
	if (blk_count)
	{
		char msg[256];
		wsprintf(msg,"memory leaks detected; %u blocks",blk_count);
		MessageBox(0,msg,"PPcrt",0);
		UINT n;
		for(n=0;n<TAB_MAX;n++) if (ptr_tab[n]) free(ptr_tab[n]);
	}
//	else MessageBox(0,"no mem leaks","PPcrt",0);
}

#endif

double _stdcall __atof(const char* s)
{
	double r=0;
	bool neg=0;
	if (*s=='-') {neg=1;s++;}
	while(*s>='0' && *s<='9')
	{
		r=10*r+(double)(*s-'0');
		s++;
	}
	if (*s=='.' || *s==',')
	{
		s++;
		double d1=0.1;
		while(*s>='0' && *s<='9')
		{
			r+=(double)(*s-'0') * d1;
			d1*=0.1;
			s++;
		}
	}
	if (neg) r=-r;
	return r;
}

void _stdcall __gcvt_(double val,char* out)
{
	char* _o=out;
	int dig=0;
	if (val<0)
	{
		*(out++)='-';
		val=-val;
	}
	if (val==0)
	{
		*(out++)='0';
	}
	else
	{
		if (val>=1)
		{
			UINT d=(UINT)val;
			uitoa(d,out);
			while(*out) {out++;dig++;}
			val-=(double)d;
		}
		else
		{
			*(out++)='0';
		}
		if (val)
		{
			int dig=0;
			*(out++)='.';
			while(val && dig<13)
			{
				dig++;
				val*=10;
				UINT d=(UINT)val;
				*(out++)=d+'0';
				val-=d;
			}
			if (val>0.5)
			{
				char* o=out-1;
				bool got_p=0;
				while(o>=_o)
				{
					if (*o=='.') {o--;got_p=1;}
					(*o)++;
					if (*o!='9'+1) break;
					*o=got_p ? '0' : 0;
					o--;
				}
			}
			while(out[-1]=='0')
			{
				*(--out)=0;
			}
		}
	}
	*out=0;
}

void _stdcall __memmove(void *_a,void *_b,UINT s)
{
	BYTE* a=(BYTE*)_a;
	BYTE* b=(BYTE*)_b;
	
	if (b>a || b+s<=a) memcpy(_a,_b,s);
	else r_memcpy(_a,_b,s);
}

void __strncpy(char* dst,char* src,UINT cnt)
{
	UINT n=0;
	cnt--;
	while(src[n] && n<cnt) {dst[n]=src[n];n++;}
	dst[n]=0;
}