#include "main.h"

static bool cvt=1;

bool _stdcall mus_test(const void* buf,DWORD max,char* info,char* ext)
{
//	if (*(DWORD*)buf == '\x1ASUM')
	{
		DWORD ofs = ((WORD*)buf)[3];
		DWORD len = ((WORD*)buf)[2];
		WORD n_ins = ((WORD*)buf)[6];

		if (ofs+len<=max && ofs>=16+(n_ins<<1) && ofs<16+(n_ins<<2) )
		{
			*(DWORD*)ext = cvt ? 'DIM' : 'SUM';
			wsprintf(info,"Size: %u bytes",ofs+len);
			return 1;
		}
	}
	return 0;
}
static char track0[] = {'M','T','r','k',0x00,0x00,0x00,11,0x00,0xFF,0x51,0x03,0x09,0xA3,0x1A,0x00,0xFF,0x2F,0x00};

static BYTE controllers[15] = {0,0,1,7,10,11,91,93,64,67,120,123,126,127,121};

#define abort _abort_

static bool abort = 0;

static DWORD ct;

typedef struct
{
	WORD pos;
	DWORD lt;
	BYTE le;
	BYTE data[64*1024];
} TRACK;

static TRACK* trax;

void _inline InitTrax(void *b)
{
	trax = (TRACK*)b;
	abort = 0;
	ct = 0;
	int n;
	for(n=0;n<16;n++) {trax[n].pos=0;trax[n].lt=0;trax[n].le=0;}
}

void AddEvent(int nt,DWORD ev,int l)
{
	DWORD dt = ct - trax[nt].lt;
	int tl=3;
	if (dt)
	{
		while(dt>>(7*tl) == 0) tl--;
		do
		{
			trax[nt].data[trax[nt].pos++]=((dt>>(7*(tl--)))&0x7F)|0x80;
		} while(tl>=0);
		trax[nt].data[trax[nt].pos-1]&=0x7F;
	}
	else trax[nt].data[trax[nt].pos++]=0;
	trax[nt].lt = ct;
	BYTE ec=ev&0xF0;
	if (ec==trax[nt].le)
	{
		*(DWORD*)(trax[nt].data+trax[nt].pos)=ev>>8;
		trax[nt].pos+=l-1;
	}
	else
	{
		*(DWORD*)(trax[nt].data+trax[nt].pos)=ev;
		trax[nt].pos+=l;
		trax[nt].le=ec;
	}
}

void _inline DumpTrax(HANDLE f)
{
	struct
	{
		DWORD hd,s;
	} mhd = {'dhTM',0x06000000};
	DWORD br;
	WriteFile(f,&mhd,8,&br,0);
	WORD nt=1;
	int n;
	for(n=0;n<16;n++) if (trax[n].pos)
	{
		AddEvent(n,0x2FFF,3);
		nt++;
	}
	struct
	{
		WORD f,t,d;
	} hd1 = {0x100,rev16(nt),0x5900};
	WriteFile(f,&hd1,6,&br,0);
	WriteFile(f,track0,sizeof(track0),&br,0);
	mhd.hd='krTM';
	for(n=0;n<16;n++) if (trax[n].pos)
	{
		mhd.s=rev32(trax[n].pos);
		WriteFile(f,&mhd,8,&br,0);
		WriteFile(f,trax[n].data,trax[n].pos,&br,0);
	}
}

DWORD _stdcall mus_rip(HANDLE src,HANDLE dst)
{
#pragma pack(push)
#pragma pack(1)
	struct
	{
		char id[4];
		WORD len;
		WORD ofs;
		WORD ch1,ch2;
		WORD n_ins;
		WORD dummy;
	} hdr;
#pragma pack(pop)
	ULONG br;
	ReadFile(src,&hdr,sizeof(hdr),&br,0);
	if (br!=sizeof(hdr)) goto fail;
	if (cvt)
	{
		BYTE* score = buf;
		long x;
		SetFilePointer(src,2*hdr.n_ins,0,FILE_CURRENT);
		ReadFile(src,score,hdr.len,&br,0);
		if (br!=hdr.len) goto fail;
		InitTrax(score+hdr.len);
		x=0;
		bool t;
		BYTE ch;
		BYTE vols[16];
		ZeroMemory(vols,sizeof(vols));
		union
		{
			BYTE b[4];
			DWORD dw;
		} ev;
		while(x<hdr.len && score[x]!=0x60)
		{
			ev.dw = 0;
			t=score[x]&0x80;
			ch = score[x]&0xF;
			if (ch == 0xF) ch = 9;//hdr.ch1+1;
			else if (ch>=9) ch++;
			switch(score[x]&0x70)
			{
			case 0:	//release note
				ev.b[0]=0x90|ch;
				ev.b[1]=score[x+1];
				ev.b[2]=0;//vols[ch];
				AddEvent(ch,ev.dw,3);
				x+=2;
				break;
			case 0x10:	//play note
				ev.b[0]=0x90|ch;
				ev.b[1]=score[x+1]&0x7F;
				if (score[x+1]&0x80)
				{
					vols[ch]=score[x+2];
					x+=3;
				}
				else
				{
					x+=2;
				}
				ev.b[2]=vols[ch];
				AddEvent(ch,ev.dw,3);
				break;
			case 0x20:	//pitch wheel
				ev.b[0]=0xE0|ch;
				ev.b[1]=0;
				ev.b[2]=score[x+1]>>1;				
				AddEvent(ch,ev.dw,3);
				x+=2;
				break;
			case 0x30:	//system event
				if (score[x+1]>=10 && score[x+1]<=14)
				{
					ev.b[0]=0xB0|ch;
					ev.b[1]=controllers[score[x+1]];
					ev.b[2]=1;
					AddEvent(ch,ev.dw,3);
					x+=2;
					break;
				}
				else goto fail;
			case 0x40:	//change controller
				if (score[x+1])
				{
					if (score[x+1]<10)
					{
						ev.b[0]=0xB0|ch;
						ev.b[1]=controllers[score[x+1]];
						ev.b[2]=score[x+2];
						AddEvent(ch,ev.dw,3);
						x+=3;
					}
					else goto fail;
				}
				else
				{
					ev.b[0]=0xC0|ch;
					ev.b[1]=score[x+2];
					AddEvent(ch,ev.dw,2);
					x+=3;
				};				
				break;
			case 0x50:
			case 0x70:
			case 0x60:
				goto fail;
			}
			if (abort) goto fail;
			if (t)
			{
				DWORD dt=0;
				do
				{
					dt = (dt<<7) + (score[x]&0x7F);
				} while(score[x++]&0x80);
				ct+=dt;
			}
		}
		DumpTrax(dst);
		return hdr.len+hdr.ofs;
	}
	else
	{
		WriteFile(dst,&hdr,sizeof(hdr),&br,0);
		DWORD l = hdr.len+hdr.ofs-sizeof(hdr);
		ReadFile(src,buf,l,&br,0);
		if (l!=br) goto fail;
		WriteFile(dst,buf,l,&br,0);
		return l+sizeof(hdr);
	}
fail:
	return RIP_ERROR;
}

void _stdcall mus_init(HKEY hk)
{
	DWORD s = sizeof(bool);
	RegQueryValueEx(hk,"mus_convert",0,0,(BYTE*)&cvt,&s);
}

void _stdcall mus_quit(HKEY hk)
{
	RegSetValueEx(hk,"mus_convert",0,REG_BINARY,(BYTE*)&cvt,sizeof(bool));
}

void _stdcall mus_config(HWND wnd)
{
	cvt_cfg("MUS","convert to MID",&cvt,wnd);
}

RIPPER MUS_ripper = {mus_test,0,'\x1ASUM',0xFFFFFFFF,0,mus_rip,mus_init,mus_quit,mus_config,"MUS","MUS (MIDI clone)\x0D\x0AUsed in DOOM engine games."};