#include "main.h"

extern RIPPER MOD_ripper;

//static bool turbo=1;

DWORD _fastcall rev32(DWORD);
WORD _fastcall rev16(WORD);

#pragma pack(push)
#pragma pack(1)

typedef struct
{
	char name[22];
	WORD len;
	BYTE ft;
	BYTE vol;
	WORD rep_pos;
	WORD rep_len;
} SAMPLE;

typedef struct
{
	char title[20];
	SAMPLE samples[31];
	BYTE npats;
	BYTE endjump;
	BYTE order[128];
	DWORD tag;
} MODfile;

#pragma pack(pop)

bool _inline TestSample(SAMPLE* s)
{
	WORD _l = rev16(s->len);
//	if (!_ValidText(s->name,22)) _asm int 3
	return _ValidText(s->name,22) && s->vol<=64; //&& rev16(s->rep_pos)<=_l && rev16(s->rep_len)<=_l;
}

bool _stdcall mod_test(const void* _buf,DWORD max,char* info,char* ext)
{
	MODfile* mod = (MODfile*)_buf;
	if (max<=sizeof(MODfile)) goto fail;
	if (mod->tag == '.K.M' || mod->tag == 'NHC4' || mod->tag == '!K!M' || mod->tag == '4TLF')
	{
		int n;
		for(n=0;n<31;n++) if (!TestSample(&mod->samples[n])) goto fail;
		*(DWORD*)ext = 'DOM';
		char t[21];
		memcpy(t,mod->title,20);
		t[20]=0;
		wsprintf(info,"Title: %s",t);
		return 1;
	}
fail:
	return 0;
}
/*
bool IsPattern()
{
	int n,nn=0;
	for(n=0;n<1024;n++) if (!buf[n]) nn++;
	return nn>256;
}
*/
DWORD _stdcall mod_rip(HANDLE src,HANDLE dst)
{
	MODfile mod;
	DWORD br,ret;
	DWORD maxpat=0;
	int n;
	ReadFile(src,&mod,sizeof(mod),&br,0);
	if (br!=sizeof(mod)) goto fail;
	WriteFile(dst,&mod,sizeof(mod),&br,0);
	for(n=0;n<mod.npats;n++) if (maxpat<mod.order[n]) maxpat = mod.order[n];
	if (maxpat>=128) goto fail;
	maxpat = (maxpat+1)<<10;;
	ReadFile(src,buf,maxpat,&br,0);
	if (br!=maxpat) goto fail;
	WriteFile(dst,buf,maxpat,&br,0);

	ret = 0;//sizeof(MODfile);
	for(n=0;n<31;n++)
	{
		ret+=(DWORD)rev16(mod.samples[n].len)*2;
	}
	if (ret>BUF_SIZE) goto fail;
	ReadFile(src,buf,ret,&br,0);
	if (br!=ret) goto fail;
	WriteFile(dst,buf,ret,&br,0);
	ret+=sizeof(mod)+maxpat;
	return ret>8192 ? ret - 8192 : 1;
fail:
	return RIP_ERROR;
}
/*
static void SetTurbo()
{
	if (turbo)
	{
		MOD_ripper.magic = '.K.M';
		MOD_ripper.mask = 0xFFFFFFFF;
		MOD_ripper.delta = sizeof(MODfile)-4;
	}
	else
	{
		MOD_ripper.magic = MOD_ripper.mask = MOD_ripper.delta = 0;
	}
}

void _stdcall mod_init(HKEY hk)
{
	DWORD s = sizeof(bool);
	RegQueryValueEx(hk,"mod_turbo",0,0,(BYTE*)&turbo,&s);
	SetTurbo();
}

void _stdcall mod_quit(HKEY hk)
{
	RegSetValueEx(hk,"mod_turbo",0,REG_BINARY,(BYTE*)&turbo,sizeof(bool));
}

BOOL CALLBACK ModProc(HWND wnd,UINT msg,WPARAM wp,LPARAM lp)
{
	if (msg == WM_INITDIALOG)
	{
		SendDlgItemMessage(wnd,IDC_TURBO,BM_SETCHECK,turbo?BST_CHECKED:BST_UNCHECKED,0);
		return 1;
	}
	else if (msg == WM_COMMAND)
	{
		if (wp == IDOK || wp == IDCANCEL)
		{
			if (wp == IDOK) turbo = SendDlgItemMessage(wnd,IDC_TURBO,BM_GETCHECK,0,0);
			SetTurbo();
			EndDialog(wnd,wp);
		}
		return 1;
	}
	else return 0;	
}

void _stdcall mod_config(HWND wnd)
{
	DialogBox(hIns,(char*)IDD_MOD,wnd,ModProc);
}
*/
RIPPER MOD_ripper = {mod_test,0,_rv('M.K.'),0xFFFFFFFF,sizeof(MODfile)-4,mod_rip,/*mod_init,mod_quit,mod_config*/0,0,0,"MOD","ProTracker modules"};