#include "main.h"

static int ntrax=0,ntrax1=0;
typedef struct
{
	DWORD sz,tm,pos;
	BYTE le;
	BYTE data[];
} TRACK;

typedef struct
{
	DWORD pos,tm;
	BYTE le;
	BYTE data[0x18000];
} TRACK1;

typedef struct
{
	DWORD time,tempo;
} TEMPO;

#define TMAP_MAX (1024)

static TRACK* in_trax[256];
//static TRACK1 out_trax[16];
#define out_trax ((TRACK1*)buf)
static TRACK1 tmptrk;
static TEMPO tmap[TMAP_MAX];
static int ntm;

#pragma pack(push)
#pragma pack(1)
typedef struct
{
	WORD t,n,d;
} MHD;
typedef struct
{
	DWORD c,s;
} CHD;
#pragma pack(pop)

static DWORD ct = 0;
static int tf=0;

static bool started;

static void AdvanceTime(TRACK* t)
{
	if (t->tm!=-1)
	{
		DWORD dt=0;
		do
		{
			dt = (dt<<7) + (t->data[t->pos]&0x7F);
		} while(t->data[t->pos++]&0x80);
		t->tm+=dt;
	}
}

void AddEvent(BYTE ev,BYTE* data)
{
	BYTE nt = ev&0xF;
	BYTE cd = ev&0xF0;
	TRACK1 *t=&out_trax[nt];
	if (cd==0x90 && !started)
	{
		UINT n;
		for(n=0;n<16;n++)
			if (out_trax[n].tm != -1) out_trax[n].tm=ct;
		started=1;
	}
	if (t->pos==0) ntrax1++;
	DWORD dt = started ? ct - t->tm :0;
	int tl=3;
	if (dt)
	{
		while(dt>>(7*tl) == 0) tl--;
		do
		{
			t->data[t->pos++]=((dt>>(7*(tl--)))&0x7F)|0x80;
		} while(tl>=0);
		t->data[t->pos-1]&=0x7F;
	}
	else t->data[t->pos++]=0;
	t->tm = ct;
	if (ev!=t->le) {t->data[t->pos++]=ev;t->le=ev;}
	t->data[t->pos++]=data[0];
	if (cd!=0xC0 && cd!=0xD0) t->data[t->pos++]=data[1];
}

void WriteTrack(HANDLE f,TRACK1* t)
{
	DWORD br;
	CHD chd;
	chd.c='krTM';
	chd.s=rev32(t->pos);
	WriteFile(f,&chd,8,&br,0);
	WriteFile(f,&t->data,t->pos,&br,0);
}

DWORD DoCleanUp(HANDLE in,HANDLE out)
{
	ZeroMemory(out_trax,sizeof(TRACK1)*16);
	started=0;
	tmptrk.tm=tmptrk.pos=0;
	ntm=0;
	ct=0;
	tf=0;
	ntrax=ntrax1=0;
	int n;
	CHD chd;
	MHD mhd;
	DWORD br;
	DWORD ret=0;
	ReadFile(in,&chd,8,&br,0);
	if (br!=8 || chd.c!='dhTM' || chd.s!=0x06000000) goto fail;
	ReadFile(in,&mhd,6,&br,0);
	mhd.t = rev16(mhd.t);
	mhd.n = rev16(mhd.n);
	if (br!=6 || mhd.t>1 || mhd.n>256) goto fail;
	ntrax = mhd.n;
	ret=14;
	for(n=0;n<ntrax;n++)
	{
		ReadFile(in,&chd,8,&br,0);
		if (br!=8 || chd.c!='krTM') goto fail;
		chd.s = rev32(chd.s);
		in_trax[n]=(TRACK*)malloc(16+chd.s);
		in_trax[n]->sz=chd.s;
		in_trax[n]->tm=0;
		in_trax[n]->le=0;
		in_trax[n]->pos=0;
		ReadFile(in,in_trax[n]->data,chd.s,&br,0);
		if (br!=chd.s) goto fail;
		ret+=8+chd.s;
		AdvanceTime(in_trax[n]);
	}
	while(tf!=ntrax)
	{
		BYTE fakerel[2]={0,0};
		for(n=0;n<ntrax;n++)
		{
			BYTE ce=0;
			TRACK* t = in_trax[n];
			while(t->tm==ct)
			{
				if (t->pos>=t->sz) goto fail;
				BYTE c0=t->data[t->pos];
				if (c0==0xFF) //Meta-events
				{
					BYTE c1 = t->data[t->pos+1];
					if (c1 == 0x2F)
					{
						t->pos+=3;
						t->tm=-1;
						tf++;
					} else if (c1<=7)
					{
						//t->pos+=t->data[t->pos+2]+3;
						DWORD n1=t->pos+2,_l=0;
						do
						{
							_l=(_l<<7)|(t->data[n1++]&0x7F);
						}
						while(t->data[n1-1]&0x80);
						t->pos=n1+_l;						
					}
					else if (c1==0x51)	//tempo
					{
						DWORD _t=((DWORD)t->data[t->pos+3]<<16)+((DWORD)t->data[t->pos+4]<<8)+((DWORD)t->data[t->pos+5]);
						if (ntm==0 || tmap[ntm-1].tempo!=_t)
						{
							if (ntm>=TMAP_MAX) goto fail;
							tmap[ntm].time=ct;
							tmap[ntm++].tempo=((DWORD)t->data[t->pos+3]<<16)+((DWORD)t->data[t->pos+4]<<8)+((DWORD)t->data[t->pos+5]);
						}
						t->pos+=6;
					}
					else if (c1==0x58) t->pos+=7;
					else if (c1==0x59) t->pos+=5;
					else if (c1==0x7F) t->pos+=3+t->data[t->pos+2];
					else if (c1==0x21) t->pos+=4;
					else if (c1==0x54) t->pos+=3+t->data[t->pos+2];
					else if (c1==0x20) t->pos+=4;
					else if (c1==0xFF) t->pos+=3;
					else if (c1==0x7F) while(t->data[t->pos]) t->pos++;
					else goto fail;
				} else if ((c0&0xF0) == 0xF0) //Sysex
				{
					t->pos+=t->data[t->pos+1]+2;
				}
				else
				{
					if (c0&0x80)
					{
						ce = c0;
						t->pos++;						
					}
					else ce = t->le;
					if ((ce&0xF0)==0x80)
					{
						fakerel[0]=t->data[t->pos];
						AddEvent(ce+0x10,fakerel);
					}
					else
					{
						AddEvent(ce,&t->data[t->pos]);
					}
					if ((ce&0xF0) == 0xC0 || (ce&0xF0)==0xD0) t->pos++;
					else t->pos+=2;
					t->le = ce;
				}
				AdvanceTime(t);
			}
		}
		ct++;
	}
	if (ntm)
	{
		for(n=0;n<ntm;n++)
		{
			DWORD dt = tmap[n].time - tmptrk.tm;
			int tl=3;
			if (dt)
			{
				while(dt>>(7*tl) == 0) tl--;
				do
				{
					tmptrk.data[tmptrk.pos++]=((dt>>(7*(tl--)))&0x7F)|0x80;
				} while(tl>=0);
				tmptrk.data[tmptrk.pos-1]&=0x7F;
			}
			else tmptrk.data[tmptrk.pos++]=0;
			tmptrk.tm = tmap[n].time;
			tmptrk.data[tmptrk.pos++]=0xFF;
			tmptrk.data[tmptrk.pos++]=0x51;
			tmptrk.data[tmptrk.pos++]=0x03;
			*(DWORD*)(tmptrk.data+tmptrk.pos)=rev32(tmap[n].tempo)>>8;
			tmptrk.pos+=3;
		}
		tmptrk.data[tmptrk.pos++]=0;
		tmptrk.data[tmptrk.pos++]=0xFF;
		tmptrk.data[tmptrk.pos++]=0x2F;
		tmptrk.data[tmptrk.pos++]=0;
		ntrax1++;
	}

	mhd.t = 0x0100;
	mhd.n = rev16(ntrax1);
	chd.c = 'dhTM';
	chd.s = 0x06000000;
	WriteFile(out,&chd,8,&br,0);
	WriteFile(out,&mhd,6,&br,0);
	if (ntm) WriteTrack(out,&tmptrk);
	for(n=0;n<16;n++) if (out_trax[n].pos)
	{
		TRACK1 *t=out_trax+n;
		t->data[t->pos++]=0;
		t->data[t->pos++]=0xFF;
		t->data[t->pos++]=0x2F;
		t->data[t->pos++]=0;
		WriteTrack(out,t);
	}
	goto _r;
fail:
	ret=RIP_ERROR;
_r: 
	for(n=0;n<ntrax;n++) if (in_trax[n]) {free(in_trax[n]);in_trax[n]=0;}
	return ret;
}