#include "main.h"

#pragma pack(push)
#pragma pack(1)
typedef struct
{
	WORD fmt,trax,dtx;
} MIDIHEADER;

typedef struct
{
	DWORD mthd,hdsize;
	MIDIHEADER mhd;
} FILEHEADER;

typedef struct
{
	DWORD mtrk,size;
} TRACKHEADER;

#pragma pack(pop)

_declspec(naked) WORD _fastcall rev16(WORD)
{
	_asm
	{
		mov al,ch
		mov ah,cl
		ret
	}
}

_declspec(naked) DWORD _fastcall rev32(DWORD)
{
	_asm
	{
		mov eax,ecx
		bswap eax
		ret
	}
}

#define FixHeader(H) {(H).fmt=rev16((H).fmt);(H).trax=rev16((H).trax);(H).dtx=rev16((H).dtx);}
#define MThd 'dhTM'
#define MTrk 'krTM'

#define hd ((FILEHEADER*)_hd)
bool _stdcall test_midi(const void* _hd,DWORD sz,char* info,char* ext)
{
	if (hd->mthd==MThd && hd->hdsize==0x06000000 && sz>20)
	{
		MIDIHEADER mhd=hd->mhd;
		FixHeader(mhd);
		if (mhd.fmt>2 || mhd.trax>256 || *(DWORD*)((char*)_hd+14)!='krTM') return 0;
		else
		{
			wsprintf(info,"%u tracks",mhd.trax);
			strcpy(ext,"MID");
			return 1;
		}
	}
	else return 0;
}
#undef hd

DWORD _stdcall rip_midi(HANDLE in,HANDLE out)
{
	DWORD ret=0;
	DWORD br;
	TRACKHEADER thd;
	FILEHEADER fhd;
	WORD trax;
	int n;
	ReadFile(in,&fhd,sizeof(fhd),&br,0);
	ret+=sizeof(fhd);
	WriteFile(out,&fhd,sizeof(fhd),&br,0);
	trax=rev16(fhd.mhd.trax);
	for(n=0;n<trax;n++)
	{
		if (!ReadFile(in,&thd,8,&br,0) || br!=8 || thd.mtrk!=MTrk) goto fail;
		ret+=8;
		WriteFile(out,&thd,8,&br,0);
		thd.size=rev32(thd.size);
		if (thd.size>BUF_SIZE) goto fail;
		if (!ReadFile(in,buf,thd.size,&br,0) || br!=thd.size) goto fail;
		ret+=thd.size;
		WriteFile(out,buf,thd.size,&br,0);
	}
	return ret;
fail:
	return RIP_ERROR;
}

RIPPER MIDI_ripper={test_midi,0,'dhTM',0xFFFFFFFF,0,rip_midi,0,0,0,"MIDI","Standard MIDI\x0D\x0AUsed in several games with MIDI music."};