#include "main.h"
#include "resource.h"
#include <shlobj.h>

#define VER "v0.74"

#define WM_STATS WM_USER
#define WM_FILETEXT (WM_USER+1)
#define WM_TEST (WM_USER+2)

#define NUM_RIPPERS 26
#define NUM_SKIPPERS 4

extern RIPPER RIFF_ripper,VOC_ripper,MIDI_ripper,AUD_ripper,AUD1_ripper,HMP_ripper,AIFF_ripper,AU_ripper,MUS_ripper,S3M_ripper,MOD_ripper,IT_ripper,XM_ripper,PER_ripper,XMI_ripper,HMI_ripper,CMF_ripper,VQA_ripper,WMA_ripper,_8SVX_ripper,WAV_ripper,RMI_ripper,AVI_ripper,IFF_ripper, BMP_ripper, SWF_ripper; //LBM_ripper,
extern SKIPPER RIFF_skipper,IFF_skipper,AUD_skipper,AUD1_skipper;

RIPPER *rippers[NUM_RIPPERS]={&MIDI_ripper,&RMI_ripper,&HMP_ripper,&HMI_ripper,&MUS_ripper,&CMF_ripper,&XMI_ripper,&WAV_ripper,&AUD_ripper,&AUD1_ripper,&VOC_ripper,&AIFF_ripper,&AU_ripper,&WMA_ripper,&_8SVX_ripper,&MOD_ripper,&S3M_ripper,&IT_ripper,&XM_ripper,&PER_ripper,&VQA_ripper,&AVI_ripper,&RIFF_ripper,&IFF_ripper,&BMP_ripper, &SWF_ripper };
SKIPPER *skippers[NUM_SKIPPERS]={&RIFF_skipper,&IFF_skipper,&AUD_skipper,&AUD1_skipper};
RIPPER_INFO r_inf[NUM_RIPPERS];
BYTE buf[BUF_SIZE];

bool canskip=1;
bool do_subdirs=1;
bool llama=0;

typedef bool ripmask[NUM_RIPPERS];

#define N_RMASKZ 6

static int sel_masks[N_RMASKZ];

static ripmask ripmasks[N_RMASKZ]=
{
	{1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},	//MIDI
	{0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0},	//WAV
	{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0},	//MOD
	{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1},	//misc
	{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0},	//misc
	{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},	//all
};

void ApplyMask(UINT nm,bool b)
{
	UINT n;
	for(n=0;n<NUM_RIPPERS;n++)
	{
		if (ripmasks[nm][n]) r_inf[n].enabled=b;
	}
}

int MaskState(UINT nm)
{
	bool i1=0,i2=0;
	UINT n;
	for(n=0;n<NUM_RIPPERS;n++)
		if (ripmasks[nm][n])
		{
			if (r_inf[n].enabled) i1=1;
			else i2=1;
		}

	int ret;
	if (i1 && i2) ret=BST_INDETERMINATE;
	else if (i1) ret=BST_CHECKED;
	else ret=BST_UNCHECKED;

	return ret;
}

bool ask = 0,inside = 0;

HWND prg=0,hMainWnd=0;
int song_n=0;
bool ripping=0;
bool stop=0;
HANDLE ripthread=0;

HINSTANCE hIns=0;

#define SB_RESERVE 0x0800
#define SB_SIZE 0x40000

typedef struct
{
	char ext[32];
	int num;
} ext_info;

ext_info *exts=0;
int num_exts = 0;

static void do_winamp(char* fn,char* rfn,UINT start,UINT end)
{
	char tmp[MAX_PATH];
	wsprintf(tmp,"partial://%08X-%08X:%s\\%s",start,end,fn,rfn);
	char t[4]=" :\\";
	t[0]=fn[0]; 
	if (GetDriveType(t)==DRIVE_CDROM)
	{
		tmp[10+8+1+8+1]='#';
	}
	
	HWND wnd=FindWindow("Winamp v1.x",0);
	if (wnd)
	{
		COPYDATASTRUCT cds;
		cds.dwData=100;
		cds.cbData=strlen(tmp)+1;
		cds.lpData=tmp;
		SendMessage(wnd,WM_COPYDATA,0,(long)&cds);
	}
	else MessageBox(0,"no winamp window",0,0);
}

int _stdcall browzaproc(HWND wnd,UINT msg,LPARAM lp,LPARAM dat)
{
	if (msg==BFFM_INITIALIZED) SendMessage(wnd,BFFM_SETSELECTION,1,dat);
	return 0;
}

void _inline browza(HWND w)
{
	HWND e=GetDlgItem(w,IDC_DIR);
	IMalloc* pMalloc=0;
	char dir[MAX_PATH];
	SHGetMalloc(&pMalloc);
	if (!pMalloc) return;
	GetWindowText(e,dir,MAX_PATH);
	UINT _l=strlen(dir);
	if (_l && dir[_l-1]=='\\' && !(_l>1 && dir[_l-2]==':'))
	{
		dir[--_l]=0;
	}
	BROWSEINFO bi=
	{
		w,
		0,
		0,
		"Select output directory for ripped files.",
		BIF_RETURNONLYFSDIRS,
		browzaproc,
		(long)dir,
		0
	};
	ITEMIDLIST* li=SHBrowseForFolder(&bi);
	if (li)
	{
		SHGetPathFromIDList(li,dir);
		SetWindowText(e,dir);
		pMalloc->Free(li);
	}
	pMalloc->Release();
}

void UpdateStats()
{
	char buf[2048];
	char* p;
	int n,s=0;
	buf[0]=0;
	for(n=0;n<NUM_RIPPERS;n++) s+=r_inf[n].ripped;
	if (s)
	{
		strcpy(buf,"  Ripped:\x0D\x0A");
		for(n=0;n<NUM_RIPPERS;n++)
			if (r_inf[n].ripped)
			{
				wsprintf(buf+strlen(buf),r_inf[n].ripped == 1 ? "%s : %u file\x0D\x0A" : "%s : %u files\x0D\x0A",rippers[n]->name,r_inf[n].ripped);
			}
		strcat(buf,"  Saved:\x0D\x0A");
		for(n=0;n<num_exts;n++)
		{
			wsprintf(buf+strlen(buf),exts[n].num == 1 ? "%s : %u file\x0D\x0A" : "%s : %u files\x0D\x0A",exts[n].ext,exts[n].num);
		}
		wsprintf(buf+strlen(buf),s==1 ? " Total : %u file" : " Total : %u files",s);
		p = buf;
	}
	else p = "(nothing ripped)";
	SetDlgItemText(hMainWnd,IDC_STATS,p);
}

void stats_add_ext(char* ext)
{
	if (num_exts)
	{
		int n;
		for(n=0;n<num_exts;n++)
		{
			if (strcmp(exts[n].ext,ext)==0)
			{
				exts[n].num++;
				return;
			}
		}
		num_exts++;
		exts = (ext_info*)realloc(exts,num_exts*sizeof(ext_info));
		exts[num_exts-1].num = 1;
		strcpy(exts[num_exts-1].ext,ext);
	}
	else
	{
		num_exts = 1;
		exts = (ext_info*)malloc(sizeof(ext_info));
		exts[0].num = 1;
		strcpy(exts[0].ext,ext);
	}
}

void stats_reset_ext()
{
	if (num_exts)
	{
		num_exts = 0;
		free(exts);
		exts = 0;
	}
}

HANDLE hSync=0;
volatile WORD action;
char rip_msg[1024];
char rip_name[MAX_PATH];

bool GetSaveName()
{
	char filter[256];
	char ext[32];
	strcpy(ext,strrchr(rip_name,'.')+1);
	wsprintf(filter,"%s files|*.%s|All files|*.*|",ext,ext);
	int n,m=strlen(filter);
	for(n=0;n<m;n++) if (filter[n] == '|') filter[n] = 0;
	OPENFILENAME ofn;
	ZeroMemory(&ofn,sizeof(ofn));
	ofn.hwndOwner = hMainWnd;
	ofn.lStructSize = sizeof(ofn);
	ofn.lpstrFilter=filter;
	ofn.lpstrFile = rip_name;
	ofn.nMaxFile = MAX_PATH;
	ofn.Flags = OFN_PATHMUSTEXIST|OFN_OVERWRITEPROMPT|OFN_HIDEREADONLY;
	ofn.lpstrDefExt = ext;
	if (GetSaveFileName(&ofn))
	{
		return 1;
	}
	else return 0;
}

static char wintex[MAX_PATH];

void SetFile(char* f)
{
	if (f)
	{
		wsprintf(wintex,"WinRipper "VER" - %s",f);
	}
	else
	{
		strcpy(wintex,"WinRipper "VER);
	}
	PostMessage(hMainWnd,WM_FILETEXT,0,0);
}

typedef BYTE* (_fastcall *scanfunc)(BYTE* ptr,DWORD sz,UINT n_r,DWORD* masks,DWORD* magics,UINT* rp);

_declspec(naked) BYTE* _fastcall scan_nomask(BYTE* ptr,DWORD sz,UINT n_r,DWORD* masks,DWORD* magics,UINT* rp)
{//												ecx		edx		[esp+4]		[esp+8]		[esp+12]	[esp+16]
	_asm
	{
		push esi
		push ebp
		mov esi,[esp+8+12]	//magics
_ml:
		mov ebp,[esp+8+4]
		mov eax,[ecx]
_ml1:
		cmp eax,[esi+4*ebp]
		je _t
		dec ebp
		jge _ml1
		dec edx
		lea ecx,[ecx+1]
		jnz _ml
		xor eax,eax
		jmp _r
_t:		
		mov edx,[esp+8+16]
		mov eax,ecx
		mov [edx],ebp
_r:
		pop ebp
		pop esi		
		ret 16
	}
}

_declspec(naked) BYTE* _fastcall scan_norm(BYTE* ptr,DWORD sz,UINT n_r,DWORD* masks,DWORD* magics,UINT* rp)
{//											ecx		edx		[esp+4]		[esp+8]		[esp+12]	[esp+16]
	_asm
	{
		push edi
		push esi
		push ebx
		push ebp
		mov edi,[esp+16+8]	//masks
		mov esi,[esp+16+12]	//magics
_ml:
		mov ebp,[esp+16+4]
		mov eax,[ecx]
		shl ebp,2
_ml1:
		mov ebx,[edi+ebp]
		and ebx,eax
		cmp ebx,[esi+ebp]
		je _t
		sub ebp,4
		jge _ml1
		inc ecx
		dec edx
		jnz _ml
		xor eax,eax
		jmp _r
_t:		
		mov edx,[esp+16+16]
		shr ebp,2
		mov eax,ecx
		mov [edx],ebp
_r:
		pop ebp
		pop ebx
		pop esi
		pop edi		
		ret 16
	}
}

typedef struct
{
	UINT nr;
	RIPPER** rs;
} RIPSTRUCT;

#define NUMRIP (NUM_RIPPERS+NUM_SKIPPERS)

class CRipper
{
public:
	DWORD magics[NUMRIP],masks[NUMRIP];
	RIPSTRUCT rps[NUMRIP];
	BYTE _seek_buf[SB_SIZE+2*SB_RESERVE];
	char fn[MAX_PATH];
	scanfunc scan;
	UINT n_r;
	char* src_path;
	void do_file(HANDLE);
	void do_path(char*);
	void run();
};

void CRipper::do_file(HANDLE hMix)
{
	UINT n;
	DWORD file_size,pos,dpos,br;
	BYTE* seek_buf = _seek_buf + SB_RESERVE;
	char rfn[MAX_PATH];
	char info[512];
	char ext[64];
	pos = 0;
	file_size=GetFileSize(hMix,0);
	DWORD buf_ofs=-1;
	while(pos<file_size-4 && !stop)
	{
		long _d=pos-SB_RESERVE;
		DWORD inbuf=0;
		if (buf_ofs!=-1 && buf_ofs+SB_SIZE+SB_RESERVE>_d)
		{
			DWORD dt=pos-buf_ofs;
			inbuf=2*SB_RESERVE+SB_SIZE-dt;
			memmove(_seek_buf,_seek_buf+dt,inbuf);
		}
		long ds=SB_RESERVE;
		if (_d<0)
		{
			ds+=_d;
			_d=0;
		}
		ds-=inbuf;
		if (ds>0)
		{
			SetFilePointer(hMix,_d,0,FILE_BEGIN);
			ReadFile(hMix,_seek_buf+SB_RESERVE-ds,ds,&br,0);
		}
		if (inbuf) inbuf-=SB_RESERVE;
		
		SetFilePointer(hMix,pos+inbuf,0,FILE_BEGIN);
		ReadFile(hMix,seek_buf+inbuf,SB_SIZE+SB_RESERVE-inbuf,&br,0);
		PostMessage(prg,PBM_SETPOS,(WPARAM)MulDiv(100,pos,file_size),0);
		buf_ofs=pos;
		
		DWORD _s=SB_SIZE;
		DWORD _s1=file_size-pos-4;
		if (_s>_s1) _s=_s1;
		BYTE* _p=scan(seek_buf,_s,n_r-1,masks,magics,&n);
		if (!_p)
		{
			pos+=_s;
			continue;
		}
		else 
		{
			pos+=_p-seek_buf;
			UINT nr;
			for(nr=0;nr<rps[n].nr;nr++)
			{
				RIPPER* rpr=rps[n].rs[nr];
				long _pos=pos-rpr->delta;
				if (_pos>=0 && rpr->hd_test(_p-rpr->delta,file_size-_pos,info,ext))
				{
					bool do_wa=llama;
					if (rpr->skipper)
					{
						SKIPPER* sk=(SKIPPER*)rpr;
						SetFilePointer(hMix,_pos,0,FILE_BEGIN);
						pos+=sk->skip(hMix);
						goto _skip;
					}
					wsprintf(rfn,"%u.%s",song_n+1,ext);
					int retval;
					if (ask && !do_wa)
					{
						wsprintf(rip_msg,"Found %s file at %Xh in \"%s\".",rpr->name,_pos,fn);
						if (info[0])
						{
							strcat(rip_msg,"\n");
							strcat(rip_msg,info);
						}
						strcpy(rip_name,rfn);
						action = 0;
						PostMessage(hMainWnd,WM_TEST,0,0);
						WaitForSingleObject(hSync,INFINITE);
						if (stop) break;
						retval=action;
						strcpy(rfn,rip_name);
						if (retval == IDC_SKIP) continue;
					}
					else retval = IDC_SAVE;
					if (retval == IDC_SAVE)
					{
						HANDLE out;
						if (do_wa) out=IHV; else out=CreateFile(rfn,GENERIC_WRITE,0,0,CREATE_ALWAYS,0,0);
						if (!do_wa && out == IHV)
						{
							wsprintf(rip_msg,"Cannot create file: \"%s\"",rfn);
							MessageBox(hMainWnd,rip_msg,0,MB_ICONERROR);
						}
						else
						{
							SetFilePointer(hMix,_pos,0,FILE_BEGIN);
							dpos=rpr->rip(hMix,out);
							if (!do_wa) CloseHandle(out);

							if (dpos && dpos!=RIP_ERROR)
							{
								if (do_wa) do_winamp(src_path,rfn,_pos,_pos+dpos);
								UINT n1=0;
								while(rippers[n1]!=rpr) n1++;
								r_inf[n1].ripped++;
								stats_add_ext(ext);
								PostMessage(hMainWnd,WM_STATS,0,0);
								song_n++;
								if (inside)
								{
									dpos=1;
								}
								else
								{
									if (dpos+pos>=file_size) goto eof;
								}
								nr = rps[n].nr;
								pos+=dpos-1;
							}
							else
							{
								DeleteFile(rfn);
								if (ask)
								{
									wsprintf(rip_msg,"Incorrect or damaged %s file.",rpr->name);
									MessageBox(hMainWnd,rip_msg,0,MB_ICONERROR);
								}
							}
							break;
						}
					}
				}
			}
		}
		pos++;
_skip:;
	}
eof:
	PostMessage(prg,PBM_SETPOS,100,0);
}

void CRipper::do_path(char* path)
{
	char fn[MAX_PATH];
	strcpy(fn,path);
	char* pt=strrchr(fn,'\\');
	if (pt) pt++; else pt=fn;
	WIN32_FIND_DATA fd;
	ZeroMemory(&fd,sizeof(fd));
	

	HANDLE hMix = IHV;
	HANDLE hFind = FindFirstFile(fn,&fd);
	if (hFind != IHV)
	{
		do {
			strcpy(pt,fd.cFileName);
			if (fd.cFileName[0]=='.') continue;
			if (do_subdirs && (fd.dwFileAttributes&FILE_ATTRIBUTE_DIRECTORY))
			{
				strcat(pt,"\\*");
				do_path(fn);
				continue;
			}			
			hMix = CreateFile(fn,GENERIC_READ,FILE_SHARE_READ,0,OPEN_EXISTING,0,0);
			if (hMix==IHV) continue;
			src_path=fn;
			if (GetFileSize(hMix,0)<0x10) {CloseHandle(hMix);continue;}
			SetFile(fn);
			lstrcpy(this->fn, fn);
			do_file(hMix);
			CloseHandle(hMix);
		} while (!stop && FindNextFile(hFind,&fd));
		FindClose(hFind);
	}
}

DWORD WINAPI RipFunc(void*)
{
	CRipper *r=new CRipper;
	if (r)
	{
		r->run();
		delete r;
	}
	return 0;
}

void CRipper::run()
{
	ZeroMemory(rps,sizeof(rps));
	GetDlgItemText(hMainWnd,IDC_FILE,fn,MAX_PATH);
	UINT n;
	n_r=0;
	ResetEvent(hSync);
	scan=scan_nomask;
	for(n=0;n<NUM_RIPPERS;n++)
	{
		if (r_inf[n].enabled)
		{
			if (rippers[n]->mask!=0xFFFFFFFF) scan=scan_norm;
			UINT n1;
			bool done=0;
			for(n1=0;n1<n_r;n1++)
			{
				if (masks[n1]==rippers[n]->mask && magics[n1]==rippers[n]->magic)
				{
					rps[n1].rs=(RIPPER**)realloc(rps[n1].rs,(++rps[n1].nr)*4);
					rps[n1].rs[rps[n1].nr-1]=rippers[n];
					done=1;
					break;
				}
			}
			if (!done)
			{
				masks[n_r]=rippers[n]->mask;
				magics[n_r]=rippers[n]->magic;
				rps[n_r].nr=1;
				rps[n_r].rs=(RIPPER**)malloc(4);
				rps[n_r++].rs[0]=rippers[n];
			}
		}
	}
	if (canskip)
	{
		for(n=0;n<NUM_SKIPPERS;n++)
		{
			UINT n1;
			bool done=0;
			for(n1=0;n1<n_r;n1++)
			{
				if (masks[n1]==skippers[n]->mask && magics[n1]==skippers[n]->magic)
				{
					rps[n1].rs=(RIPPER**)realloc(rps[n1].rs,(++rps[n1].nr)*4);
					rps[n1].rs[rps[n1].nr-1]=(RIPPER*)skippers[n];
					done=1;
					break;
				}
			}
			if (!done && !skippers[n]->no_add)
			{
				masks[n_r]=skippers[n]->mask;
				magics[n_r]=skippers[n]->magic;
				rps[n_r].nr=1;
				rps[n_r].rs=(RIPPER**)malloc(4);
				rps[n_r++].rs[0]=(RIPPER*)skippers[n];
			}
		}
	}

	n=strlen(fn);
	if (n && fn[n-1]=='\\') fn[n-1]=0;

	do_path(fn);

	SetFile(0);
	if (!stop) PostMessage(hMainWnd,WM_COMMAND,IDM_ENDRIP,0);
	for(n=0;n<n_r;n++) if (rps[n].rs) free(rps[n].rs);
	return;
}

bool GetFileName(HWND eb)
{
	char fn[MAX_PATH];
	GetWindowText(eb,fn,MAX_PATH);
	OPENFILENAME ofn;
	ofn.lStructSize=sizeof(ofn);
	ofn.hwndOwner=hMainWnd;
	ofn.hInstance=hIns;
	ofn.lpstrFilter="All files (*.*)\0*.*\0\0";
	ofn.lpstrCustomFilter=0;
	ofn.nMaxCustFilter=0;
	ofn.nFilterIndex=0;
	ofn.lpstrFile=fn;
	ofn.nMaxFile=256;
	ofn.lpstrFileTitle=0;
	ofn.nMaxFileTitle=0;
	ofn.lpstrInitialDir=0;
	ofn.lpstrTitle=0;
	ofn.Flags=OFN_HIDEREADONLY|OFN_PATHMUSTEXIST|OFN_FILEMUSTEXIST;
	ofn.nFileOffset=0;
	ofn.nFileExtension=0;
	ofn.lpstrDefExt=0;
	ofn.lCustData=0;
	ofn.lpfnHook=0;
	ofn.lpTemplateName=0;
	if (GetOpenFileName(&ofn))
	{
		SetWindowText(eb,fn);
		return 1;
	}
	return 0;
}

void UpdateBtns(HWND wnd);

void EnableWindows(bool b)
{
	EnableWindow(GetDlgItem(hMainWnd,IDC_FILE),b);
	EnableWindow(GetDlgItem(hMainWnd,IDC_FILE_B),b);
	EnableWindow(GetDlgItem(hMainWnd,IDC_DIR),b);
	EnableWindow(GetDlgItem(hMainWnd,IDC_BROWZA),b);
	EnableWindow(GetDlgItem(hMainWnd,IDC_SETTINGS),b);
	EnableWindow(GetDlgItem(hMainWnd,IDC_DISABLE),b);
	EnableWindow(GetDlgItem(hMainWnd,IDC_LIST1),b);
	EnableWindow(GetDlgItem(hMainWnd,IDC_FMT),b);
	EnableWindow(GetDlgItem(hMainWnd,IDC_FMT1),b);
	EnableWindow(GetDlgItem(hMainWnd,IDC_CANSKIP),b);
	EnableWindow(GetDlgItem(hMainWnd,IDC_SUBDIR),b);
	UINT n;
	for(n=0;n<N_RMASKZ;n++) EnableWindow(GetDlgItem(hMainWnd,IDC_CHECK1+n),b);
	if (b) UpdateBtns(hMainWnd);
}

void EnableRipCtrl(bool b)
{
	EnableWindow(GetDlgItem(hMainWnd,IDC_RIPCTRL),b);
	EnableWindow(GetDlgItem(hMainWnd,IDC_SAVEAS),b);
	EnableWindow(GetDlgItem(hMainWnd,IDC_SAVE),b);
	EnableWindow(GetDlgItem(hMainWnd,IDC_SKIP),b);
	if (!b)
	{
		SetDlgItemText(hMainWnd,IDC_RIP_INFO,"");
		SetDlgItemText(hMainWnd,IDC_SAVE,"Save");
	}
	else
	{
		SetDlgItemText(hMainWnd,IDC_RIP_INFO,rip_msg);
		char tmp[72];
		wsprintf(tmp,"Save %s",rip_name);
		SetDlgItemText(hMainWnd,IDC_SAVE,tmp);
	};
}

void StartRip()
{
	if (ripping) return;
	int n;
	for(n=0;n<NUM_RIPPERS;n++) if (r_inf[n].enabled) goto _ok;
	MessageBox(hMainWnd,"No formats selected.",0,MB_ICONERROR);
	return;
_ok:
	PostMessage(prg,PBM_SETPOS,0,0);
	stop=0;
	char tmp[MAX_PATH];
	GetDlgItemText(hMainWnd,IDC_DIR,tmp,MAX_PATH);
	if (!tmp[0] || !SetCurrentDirectory(tmp))
	{
		if (CreateDirectory(tmp,0)) SetCurrentDirectory(tmp);
		else {MessageBox(hMainWnd,"Bad directory.",0,MB_ICONERROR);return;}
	}
	DWORD id;
	ripthread=CreateThread(0,0,RipFunc,0,0,&id);
	ripping=1;
	SetDlgItemText(hMainWnd,IDOK,"Stop");
	EnableWindows(0);
}

void StopRip()
{
	if (!ripping) return;
	SetEvent(hSync);
	stop=1;
	if (WaitForSingleObject(ripthread,30000)==WAIT_TIMEOUT)
	{
		MessageBox(hMainWnd,"Error while terminating ripper thread.",0,0);
		TerminateThread(ripthread,0);
	}
	CloseHandle(ripthread);
	ripping=0;
	SetDlgItemText(hMainWnd,IDOK,"Rip");
	EnableWindows(1);
	EnableRipCtrl(0);
	PostMessage(hMainWnd,WM_COMMAND,MAKELONG(IDC_LIST1,LBN_SELCHANGE),0);
}

char *GetRipperText(int n)
{
	static char buf[256];
	if (r_inf[n].enabled) return rippers[n]->name;
	strcpy(buf,rippers[n]->name);
	strcat(buf," (disabled)");
	return buf;
}

char* _inline GetButtonText(int n)
{
	if (n == -1) return 0;
	else return r_inf[n].enabled ? "disable" : "enable";
}

void UpdateBtns(HWND wnd)
{
	int n = SendDlgItemMessage(wnd,IDC_LIST1,LB_GETCURSEL,0,0);
	HWND w = GetDlgItem(wnd,IDC_DISABLE);
	SetWindowText(w,GetButtonText(n));
	EnableWindow(w,n!=-1);
	if (n!=-1)
	{
		EnableWindow(GetDlgItem(wnd,IDC_SETTINGS),rippers[n]->config?1:0);
		SetDlgItemText(wnd,IDC_FMT,rippers[n]->info ? rippers[n]->info : "");
	}
	else EnableWindow(GetDlgItem(wnd,IDC_SETTINGS),0);
	for(n=0;n<N_RMASKZ;n++)
	{
		sel_masks[n]=MaskState(n);
		SendDlgItemMessage(wnd,IDC_CHECK1+n,BM_SETCHECK,sel_masks[n],0);

	}
}

static void UpdateList(HWND w,UINT n)
{
	SendMessage(w,LB_DELETESTRING,n,0);
	SendMessage(w,LB_INSERTSTRING,n,(long)GetRipperText(n));
}

static void UpdateAllRippers(HWND wnd)
{
	HWND w=GetDlgItem(wnd,IDC_LIST1);
	UINT n;
	for(n=0;n<NUM_RIPPERS;n++) UpdateList(w,n);
	UpdateBtns(wnd);
}

void InitRippers();
void DeInitRippers();

BOOL WINAPI DlgProc(HWND wnd,UINT msg,WPARAM wp,LPARAM lp)
{
	int rv=1;
	switch(msg)
	{
	case WM_INITDIALOG:
		hMainWnd=wnd;
		prg=GetDlgItem(wnd,IDC_PROG);
//		SetDlgItemText(wnd,IDC_DIR,"c:\\");
		InitRippers();
		SendMessage(prg,PBM_SETRANGE,0,MAKELPARAM(0,100));
		if (lp) SetDlgItemText(wnd,IDC_FILE,(char*)lp);
		UpdateAllRippers(wnd);
		SetDlgItemText(wnd,IDC_STATS,"(nothing ripped)");
		SendDlgItemMessage(wnd,IDC_ASK,BM_SETCHECK,ask,0);
		SendDlgItemMessage(wnd,IDC_SCAN,BM_SETCHECK,inside,0);
		SendDlgItemMessage(wnd,IDC_CANSKIP,BM_SETCHECK,canskip,0);
		SendDlgItemMessage(wnd,IDC_SUBDIR,BM_SETCHECK,do_subdirs,0);
		SendDlgItemMessage(wnd,IDC_LLAMA,BM_SETCHECK,llama,0);
		SetWindowText(wnd,"WinRipper "VER);
		break;
	case WM_VKEYTOITEM:
		rv=-1;
		if (LOWORD(wp)==' ') goto dsb;
		break;
	case WM_COMMAND:
		if (HIWORD(wp)==BN_CLICKED)
		{
			if ((LOWORD(wp)>=IDC_CHECK1) && (LOWORD(wp)<IDC_CHECK1+N_RMASKZ))
			{
				UINT n=wp-IDC_CHECK1;
				int ms=!sel_masks[n];
				sel_masks[n]=ms;
				ApplyMask(n,ms);
				SendMessage((HWND)lp,BM_SETCHECK,ms,0);
				UpdateAllRippers(wnd);
				
			}
			else
			switch(LOWORD(wp))
			{
			case IDC_EXIT:
				StopRip();
				DeInitRippers();
				EndDialog(wnd,0);
				break;
			case IDOK:
				if (ripping)
					StopRip();
				else
					StartRip();
				break;
			case IDC_FILE_B:
				GetFileName(GetDlgItem(wnd,IDC_FILE));
				break;
			case IDM_ENDRIP:
				StopRip();
				break;
			case IDC_DISABLE:
				{
dsb:				HWND w = GetDlgItem(wnd,IDC_LIST1);
					int n = SendMessage(w,LB_GETCURSEL,0,0);
					if (n != -1)
					{
						r_inf[n].enabled = ! r_inf[n].enabled;
						UpdateList(w,n);
						SendMessage(w,LB_SETCURSEL,n,0);
						UpdateBtns(wnd);
					}
				}
				break;
			case IDC_SETTINGS:
				{
					int n = SendDlgItemMessage(wnd,IDC_LIST1,LB_GETCURSEL,0,0);
					if (n != -1 && rippers[n]->config) rippers[n] -> config(wnd);
				}
				break;
			case IDC_RESET:
				{
					int n;
					for(n=0;n<NUM_RIPPERS;n++) r_inf[n].ripped = 0;
					stats_reset_ext();
					SetDlgItemText(wnd,IDC_STATS,"(nothing ripped)");
				}
				break;
			case IDC_ASK:
				ask = SendMessage((HWND)lp,BM_GETCHECK,0,0);
				break;
			case IDC_SCAN:
				inside = SendMessage((HWND)lp,BM_GETCHECK,0,0);
				break;
			case IDC_CANSKIP:
				canskip = SendMessage((HWND)lp,BM_GETCHECK,0,0);
				break;
			case IDC_SUBDIR:
				do_subdirs = SendMessage((HWND)lp,BM_GETCHECK,0,0);
				break;
			case IDC_SAVEAS:
				if (ripping && !action)
				{
					if (GetSaveName())
					{
						action = IDC_SAVE;
						EnableRipCtrl(0);
						SetEvent(hSync);
					}
				}
				break;
			case IDC_SAVE:
			case IDC_SKIP:
				if (ripping && !action)
				{
					action = wp;
					EnableRipCtrl(0);
					SetEvent(hSync);
				}
				break;
			case IDC_BROWZA:
				browza(wnd);
				break;
			case IDC_LLAMA:
				llama=SendMessage((HWND)lp,BM_GETCHECK,0,0);
				break;
			}
		}
		else if (wp == MAKELONG(IDC_LIST1,LBN_SELCHANGE))
		{
			UpdateBtns(wnd);
		}
		else if (wp == MAKELONG(IDC_LIST1,LBN_DBLCLK)) PostMessage(wnd,WM_COMMAND,IDC_DISABLE,0);
		break;
	case WM_DROPFILES:
		if (!ripping)
		{
			char tmp[MAX_PATH];
			DragQueryFile((HDROP)wp,0,tmp,MAX_PATH);
			SetDlgItemText(wnd,IDC_FILE,tmp);
		}
		DragFinish((HDROP)wp);
		break;
	case WM_CLOSE:
		StopRip();
		DeInitRippers();
		EndDialog(wnd,0);
		break;
	case WM_STATS:
		UpdateStats();
		break;
	case WM_FILETEXT:
		SetWindowText(wnd,wintex);
		break;
	case WM_TEST:
		if (ripping && !action)
		{
			EnableRipCtrl(1);
		}
		break;
	default:
		rv=0;
	}
	return rv;
}

void InitRippers()
{
	HKEY hk;
	char tmp[256];
	int n;
	DWORD sz;
	RegCreateKey(HKEY_CURRENT_USER,"SOFTWARE\\PP\\WinRipper",&hk);
	for(n=0;n<NUM_RIPPERS;n++) 
	{
		if (rippers[n]->init) rippers[n]->init(hk);
		sz = sizeof(bool);
		strcpy(tmp,rippers[n]->name);
		strcat(tmp,"_enabled");
		r_inf[n].enabled = rippers[n]->mask ? 1 : 0;
		RegQueryValueEx(hk,tmp,0,0,(BYTE*)&r_inf[n].enabled,&sz);
		r_inf[n].ripped = 0;
	}
	sz = sizeof(bool);
	RegQueryValueEx(hk,"ask",0,0,(BYTE*)&ask,&sz);
	sz = sizeof(bool);
	RegQueryValueEx(hk,"inside",0,0,(BYTE*)&inside,&sz);
	sz = sizeof(bool);
	RegQueryValueEx(hk,"canskip",0,0,(BYTE*)&canskip,&sz);
	sz = sizeof(bool);
	RegQueryValueEx(hk,"subdir",0,0,(BYTE*)&do_subdirs,&sz);
	sz = sizeof(bool);
	RegQueryValueEx(hk,"llama",0,0,(BYTE*)&llama,&sz);

	sz = 256;
	*tmp = '\0';
	RegQueryValueEx(hk,"input",0,0,(BYTE*)tmp, &sz);
	SetDlgItemText(hMainWnd,IDC_FILE,tmp);
	sz = 256;
	GetModuleFileName(NULL, tmp, 4);
	RegQueryValueEx(hk,"output",0,0,(BYTE*)tmp,&sz);
	SetDlgItemText(hMainWnd,IDC_DIR,tmp);
	
	RegCloseKey(hk);
}

void DeInitRippers()
{
	HKEY hk;
	char tmp[256];
	UINT n;
	RegDeleteKey(HKEY_CURRENT_USER,"SOFTWARE\\PP\\WinRipper");
	RegCreateKey(HKEY_CURRENT_USER,"SOFTWARE\\PP\\WinRipper",&hk);
	for(n=0;n<NUM_RIPPERS;n++)
	{
		strcpy(tmp,rippers[n]->name);
		strcat(tmp,"_enabled");
		RegSetValueEx(hk,tmp,0,REG_BINARY,(BYTE*)&r_inf[n].enabled,sizeof(bool));
		if (rippers[n]->quit) rippers[n]->quit(hk);
	}
	RegSetValueEx(hk,"ask",0,REG_BINARY,(BYTE*)&ask,sizeof(bool));
	RegSetValueEx(hk,"inside",0,REG_BINARY,(BYTE*)&inside,sizeof(bool));
	RegSetValueEx(hk,"canskip",0,REG_BINARY,(BYTE*)&canskip,sizeof(bool));
	RegSetValueEx(hk,"subdir",0,REG_BINARY,(BYTE*)&do_subdirs,sizeof(bool));
	RegSetValueEx(hk,"llama",0,REG_BINARY,(BYTE*)&llama,sizeof(bool));

	GetDlgItemText(hMainWnd,IDC_FILE,tmp,MAX_PATH);
	RegSetValueEx(hk,"input",0,REG_SZ,(BYTE*)tmp,lstrlen(tmp));
	GetDlgItemText(hMainWnd,IDC_DIR,tmp,MAX_PATH);
	RegSetValueEx(hk,"output",0,REG_SZ,(BYTE*)tmp,lstrlen(tmp));

	RegCloseKey(hk);
}

void main()
//int WINAPI WinMain(HINSTANCE _hIns,HINSTANCE,char* prm,int shw)
{
	crt_init();
	hIns=GetModuleHandle(0);
	hSync=CreateEvent(0,0,0,0);
	DialogBoxParam(hIns,(char*)IDD_DIALOG1,0,DlgProc,argc>1 ? (long)argv[1] : 0);
	stats_reset_ext();
	CloseHandle(hSync);
	ExitProcess(0);
}
