#include "main.h"

DWORD __fastcall rev32(DWORD);

void InitWAV(HANDLE f,UINT freq,UINT nch,UINT bps);
void CloseWAV(HANDLE f);

DWORD _stdcall iff_rip(HANDLE src,HANDLE dst)
{
	struct
	{
		char form[4];
		DWORD s;
	} hdr;
	DWORD ret;
	ULONG br;
	DWORD sz;
	ReadFile(src,&hdr,8,&br,0);
	if (br!=8) goto fail;
	sz=rev32(hdr.s);
	ret=8+sz;

	if (dst!=INVALID_HANDLE_VALUE)
	{
		xfer(src,dst,sz);
	}
	return ret;
fail:
	return RIP_ERROR;
}

bool iff_test(const void* b,DWORD max,char* info,DWORD id)
{
	if (max<20 || *(DWORD*)b!=_rv('FORM') || ((DWORD*)b)[2]!=id) return 0;
	else
	{
		DWORD sz;
		if ((sz=rev32(*((DWORD*)b+1))+8)>max) return 0;
		wsprintf(info,"Size: %u bytes",sz);
		return 1;
	}
}

DWORD _stdcall iff_skip(HANDLE s)
{
	SetFilePointer(s,4,0,FILE_CURRENT);
	DWORD dw,br;
	ReadFile(s,&dw,4,&br,0);
	return rev32(dw)+8;
}

bool _stdcall iff_test1(const void* b,DWORD max,char*,char*)
{
	if (max<20) return 0;
	DWORD sz;
	if ((sz=rev32(*((DWORD*)b+1))+8)>max) return 0;
	if (!ValidText((char*)b+8,8)) return 0;
	return 1;
}

SKIPPER IFF_skipper={iff_test1,1,_rv('FORM'),0xFFFFFFFF,0,iff_skip,0};

static bool aif2wav=1;

bool _stdcall aiff_test(const void* b,DWORD max,char* info,char* ext)
{
	if (iff_test(b,max,info,_rv('AIFF')))
	{
		*(DWORD*)ext = aif2wav ? 'VAW' : 'FIA';
		return 1;
	}
	else return 0;
}

#pragma pack(push)
#pragma pack(1)
typedef struct
{
	WORD nc;
	DWORD smp;
	WORD ss;
	BYTE sr[10];
} AIFF_COMM;

#pragma pack(pop)

DWORD _stdcall aiff_rip(HANDLE src,HANDLE dst)
{
	if (!aif2wav) return iff_rip(src,dst);
	DWORD br,sz,s1;
	DWORD sr;
	BYTE blah[10];
	UINT n;
	AIFF_COMM ac;
	UINT nb;
	SetFilePointer(src,4,0,FILE_CURRENT);
	ReadFile(src,&sz,4,&br,0);
	sz=rev32(sz);
	if (sz&1) sz++;
	SetFilePointer(src,8,0,FILE_CURRENT);
	ReadFile(src,&s1,4,&br,0);
	s1=rev32(s1);
	if (s1&1) s1++;
	ReadFile(src,&ac,sizeof(ac),&br,0);
	if (s1!=sizeof(ac)) SetFilePointer(src,s1-sizeof(ac),0,FILE_CURRENT);
	for(n=0;n<10;n++)
	{
		blah[n]=ac.sr[9-n];
	}
	_asm
	{
		fld tbyte ptr [blah]
		fistp sr
	}
	nb=rev16(ac.ss)>>3;
	InitWAV(dst,sr,rev16(ac.nc),nb);
	while(1)
	{
		DWORD cd;
		br=0;
		ReadFile(src,&cd,4,&br,0);
		if (!br) return RIP_ERROR;
		ReadFile(src,&s1,4,&br,0);
		s1=rev32(s1);
		if (cd==_rv('SSND')) break;
		if (s1&1) s1++;
		SetFilePointer(src,s1,0,FILE_CURRENT);
	}
	
	if (nb==1)
	{
		while(s1>BUF_SIZE)
		{
			ReadFile(src,buf,BUF_SIZE,&br,0);
			for(n=0;n<BUF_SIZE;n++)
			{
				buf[n]^=0x80;
			}
		}
		if (s1)
		{
			ReadFile(src,buf,s1,&br,0);
			for(n=0;n<s1;n++)
			{
				buf[n]^=0x80;
			}
			WriteFile(dst,buf,s1,&br,0);
		}
	}
	else if (nb==2)
	{
		while(s1>BUF_SIZE)
		{
			ReadFile(src,buf,BUF_SIZE,&br,0);
			for(n=0;n<BUF_SIZE;n+=2)
			{
				BYTE t=buf[n];
				buf[n]=buf[n+1];
				buf[n+1]=t;
			}
			WriteFile(dst,buf,BUF_SIZE,&br,0);
			s1-=BUF_SIZE;
		}
		if (s1)
		{
			ReadFile(src,buf,s1,&br,0);
			for(n=0;n<s1;n+=2)
			{
				BYTE t=buf[n];
				buf[n]=buf[n+1];
				buf[n+1]=buf[n];
			}
			WriteFile(dst,buf,s1,&br,0);
		}
	}
	else return RIP_ERROR;
	CloseWAV(dst);
	return sz+8;
}

static void _stdcall aiff_init(HKEY hk)
{
	DWORD s = sizeof(bool);
	RegQueryValueEx(hk,"aiff_convert",0,0,(BYTE*)&aif2wav,&s);
}

static void _stdcall aiff_quit(HKEY hk)
{
	RegSetValueEx(hk,"aiff_convert",0,REG_BINARY,(BYTE*)&aif2wav,sizeof(bool));
}

static void _stdcall aiff_config(HWND wnd)
{
	cvt_cfg("AIFF","convert to WAV",&aif2wav,wnd);
}

RIPPER AIFF_ripper={aiff_test,0,_rv('FORM'),0xFFFFFFFF,0,aiff_rip,aiff_init,aiff_quit,aiff_config,"AIFF",
"Apple AIFF (waveform)"};

bool _stdcall _8svx_test(const void* b,DWORD max,char* info,char* ext)
{
	if (iff_test(b,max,info,_rv('8SFX')))
	{
		*(DWORD*)ext = 'FFI';
		return 1;
	}
	else return 0;
}

RIPPER _8SVX_ripper={_8svx_test,0,_rv('FORM'),0xFFFFFFFF,0,iff_rip,0,0,0,"8SVX",
"Amiga 8SVX (waveform)"};
/*
bool _stdcall lbm_test(const void* b,DWORD max,char* info,char* ext)
{
	if (iff_test(b,max,info,_rv('ILBM')))
	{
		*(DWORD*)ext = 'MBL';
		return 1;
	}
	else return 0;
}

RIPPER LBM_ripper={lbm_test,0,_rv('FORM'),0xFFFFFFFF,0,iff_rip,0,0,0,"LBM","LBM"};
*/
bool _stdcall _iff_test(const void* b,DWORD max,char* info,char* ext)
{
	if (max<20) return 0;
	else
	{
		DWORD sz;
		if (!ValidText((char*)b+8,8) || (sz=rev32(*((DWORD*)b+4))+16)>max) return 0;
		struct
		{
			union
			{
				DWORD d;
				char c[4];
			};
			DWORD e;
		} st={*((DWORD*)b+2),0};
		if (st.c[3]=' ') st.c[3]=0;
		switch(st.d)
		{
		case 'FFIA':
			*(DWORD*)ext='FIA';
			break;
		case 'MBLI':
			*(DWORD*)ext='MBL';
			break;
		default:
			memcpy(ext,&st,5);
		};
		wsprintf(info,"Format code: %s; size: %u bytes",&st,sz);
		return 1;
	}
}

RIPPER IFF_ripper={_iff_test,0,_rv('FORM'),0xFFFFFFFF,0,iff_rip,0,0,0,"IFF","IFF - Interchange File Format"};

bool _stdcall au_test(const void* b,DWORD max,char* info,char* ext)
{
	if (*(DWORD*)b!='dns.') return 0;
	DWORD ofs=rev32(((DWORD*)b)[1]),sz=rev32(((DWORD*)b)[2]);
	if (ofs<24 || ofs&0xFFFFFF00) return 0;
	if (ofs+sz>max) return 0;
	DWORD sr = rev32(((DWORD*)b)[4]),ch=rev32(((DWORD*)b)[5]);
	if (sr<5000 || sr>100000 || ch==0 || ch>4) return 0;
	*(DWORD*)ext='UA';
	wsprintf(info,"Size: %u bytes, sample rate: %u Hz, channels: %u",ofs+sz,sr,ch);
	return 1;
}

DWORD _stdcall au_rip(HANDLE src,HANDLE dst)
{
	struct
	{
		DWORD m,ofs,sz;
	} hdr;
	ULONG br;
	ReadFile(src,&hdr,12,&br,0);
	WriteFile(dst,&hdr,12,&br,0);
	hdr.ofs = rev32(hdr.ofs);
	DWORD _sz = hdr.sz = rev32(hdr.sz);
	ReadFile(src,buf,hdr.ofs-12,&br,0);
	WriteFile(dst,buf,hdr.ofs-12,&br,0);
	while(_sz)
	{
		if (_sz>BUF_SIZE)
		{
			ReadFile(src,buf,BUF_SIZE,&br,0);
			if (br!=BUF_SIZE) goto fail;
			WriteFile(dst,buf,BUF_SIZE,&br,0);
			_sz-=BUF_SIZE;
		}
		else
		{
			ReadFile(src,buf,_sz,&br,0);
			if (br!=_sz) goto fail;
			WriteFile(dst,buf,_sz,&br,0);
			break;
		}
	}
	return hdr.ofs+hdr.sz;
fail:
	return RIP_ERROR;
}

RIPPER AU_ripper={au_test,0,'dns.',0xFFFFFFFF,0,au_rip,0,0,0,"AU/SND","Next/Sun sound format (waveform)\x0D\x0ANot PC-native; doesn't occur too often."};
