#include "main.h"

static bool convert = 1;


#define _MThd 'dhTM'
#define _MTrk 'krTM'

#define tempo 0x187FFF

#pragma pack(push)
#pragma pack(1)
typedef struct
{
	WORD fmt,trax,dtx;
} MIDIHEADER;

#pragma pack(pop)

//from midi.cpp
DWORD _fastcall rev32(DWORD);
WORD _fastcall rev16(WORD);

BYTE _inline GetChannel(BYTE* track,UINT m)
{
	BYTE ret=0;
	BYTE* max=track+m;
	BYTE c;
	while(track<max)
	{
		while(!((*track)&0x80)) track++;
		track++;
		c=(*track)&0xF0;
		if (c==0xF0) return ret;
		ret=(*track)&0xF;		
		if (c==0x90) return ret;
		else if (c==0xC0 || c==0xD0)
		{
			track++;
		}
		else track+=2;
		
	}
	return ret;
}

static DWORD ProcessTrack(BYTE* track,BYTE* _out,int size)
{
	BYTE *out=_out;
	BYTE *pt = track;
	BYTE lc1 = 0,lastcom = 0;
	bool run = 0;
	int n1,n2;
	while(track < pt + size)
	{
		if (track[0]&0x80)
		{
			*(out++)=track[0]&0x7F;
		}
		else
		{
			n1 = 1;
			while((track[n1]&0x80)==0)
			{
				n1++;
				if (n1==4) return 0;
			}
			for(n2=0;n2<=n1;n2++)
			{
				*out = track[n1-n2]&0x7F;
				if (n2!=n1) (*out)|=0x80;
				out++;
			}
			track+=n1;
		}
		track++;
		if (*track == 0xFF)
		{
			if (track[1]==0x2F && track[2]==0x00)
			{
				*(out++)=0xFF;
				*(out++)=0x2F;
				*(out++)=0;
				break;
			}	//end of track
			return 0;
		}
		else 
		{
			lc1=track[0];
			if (lc1 == 0) return 0;
			switch(lc1&0xF0)
			{
			case 0x80:
				if (lastcom==lc1+0x10)
				{
					*(out++)=track[1];
					*(out++)=0;
					track+=3;
					lc1=lastcom;
					break;
				}
			case 0x90:
			case 0xA0:
			case 0xB0:
			case 0xE0:
				if (lc1!=lastcom)
				{
					*(out++)=lc1;
				}
				*(out++)=track[1];
				*(out++)=track[2];
				track+=3;
				break;
			case 0xC0:
			case 0xD0:
				if (lc1!=lastcom)
				{
					*(out++)=lc1;
				}
				*(out++)=track[1];
				track+=2;
				break;
			default:
				return 0;
			}
			lastcom=lc1;
		}
	}
	return out-_out;	
}


#define FixHeader(H) {(H).fmt=rev16((H).fmt);(H).trax=rev16((H).trax);(H).dtx=rev16((H).dtx);}

BYTE hmp_track0[]={'M','T','r','k',0,0,0,11,0,0xFF,0x51,0x03,0x18,0x7F,0xFF,0,0xFF,0x2F,0};

bool _stdcall hmp_test(const void* buf,DWORD max,char* info,char* ext)
{
	DWORD trax;
	if (*(DWORD*)buf=='MIMH' && *((DWORD*)buf+1)=='PIDI' && (trax = ((DWORD*)buf)[0xC]) < 50 && trax>1 && max > 0x40)
	{
		wsprintf(info,"%u tracks",trax);
		strcpy(ext,convert?"MID":"HMP");
		return 1;
	}
	return 0;
}


DWORD hmp_rip2(BYTE* _max,HANDLE dst)
{
	BYTE* ptr = buf;
	DWORD trax = ((DWORD*)buf)[0x0c] - 1;
	DWORD br;
	while(*(WORD*)ptr != 0x2FFF && ptr < _max - 4-7) ptr++;
	ptr += 7;
	while(trax)
	{
		ptr += *(volatile DWORD*)ptr;
		if (ptr > _max-4) goto fail;
		trax--;
	}
	trax = ptr - buf + 4;
	WriteFile(dst,buf,trax,&br,0);
	return trax;
fail:
	return RIP_ERROR;
}

DWORD _stdcall hmp_rip(HANDLE src,HANDLE dst)
{
	MIDIHEADER mhd = {1,0,0xC0};
	ULONG br;
	DWORD dw;
	if (!buf) return RIP_ERROR;
	ReadFile(src,buf,BUF_SIZE>>1,&br,0);
	BYTE* out = buf+(BUF_SIZE>>1);
	DWORD out_s;
	BYTE* _max = buf+br;
	if (!convert || dst==INVALID_HANDLE_VALUE) return hmp_rip2(_max,dst);
	BYTE* ptr = buf;
	DWORD n1;
	dw = _MThd;
	WriteFile(dst,&dw,4,&br,0);
	dw = 0x06000000;
	WriteFile(dst,&dw,4,&br,0);
	SetFilePointer(dst,sizeof(mhd),0,FILE_CURRENT);
	ptr = buf+0x30;
	mhd.trax = *ptr;
	WriteFile(dst,hmp_track0,sizeof(hmp_track0),&br,0);
	while(*(WORD*)ptr != 0x2FFF && ptr < _max - 4-7) ptr++;
	ptr+=7;
	if (ptr == _max-4) goto fail;
	UINT n;
	for(n=1;n<mhd.trax;n++)
	{
		dw = _MTrk;
		WriteFile(dst,&dw,4,&br,0);
		n1 = *(DWORD*)ptr - 12;
		if (ptr + 12 + n1 > _max) goto fail;
		ptr += 8;

		if (!(out_s=ProcessTrack(ptr,out,n1))) goto fail;

		dw = rev32(out_s);
		WriteFile(dst,&dw,4,&br,0);
		WriteFile(dst,out,out_s,&br,0);
		ptr += n1 + 4;
	}
	FixHeader(mhd);
	SetFilePointer(dst,8,0,FILE_BEGIN);
	WriteFile(dst,&mhd,sizeof(mhd),&br,0);
	return ptr - buf;
fail:
	return RIP_ERROR;
}

void _stdcall hmp_init(HKEY hk)
{
	DWORD s = sizeof(bool);
	RegQueryValueEx(hk,"hmp_convert",0,0,(BYTE*)&convert,&s);
}

void _stdcall hmp_quit(HKEY hk)
{
	RegSetValueEx(hk,"hmp_convert",0,REG_BINARY,(BYTE*)&convert,sizeof(bool));
}

void _stdcall hmp_config(HWND wnd)
{
	cvt_cfg("HMP","convert to MID",&convert,wnd);
}

RIPPER HMP_ripper = {hmp_test,0,'MIMH',0xFFFFFFFF,0,hmp_rip,hmp_init,hmp_quit,hmp_config,"HMP","HMP (MIDI clone)\x0D\x0AUsed in many DOS games.\x0D\x0AOccurs usually when game directory contains files like hmi386.drv."};