#include "main.h"

#pragma pack(push)
#pragma pack(1)
typedef struct
{
	WORD fmt,trax,dtx;
} MIDIHEADER;
#pragma pack(pop)

static bool convert=0;

WORD _fastcall rev16(WORD);
DWORD _fastcall rev32(DWORD);

static DWORD bw;

#define Q_MAX 128

struct
{
	DWORD tm;
	BYTE ch,n;
} q_rel[Q_MAX];

void inline q_add(BYTE ch,BYTE nt,DWORD t)
{
	UINT n=0;
	while(q_rel[n].tm!=-1) n++;
	q_rel[n].tm=t;
	q_rel[n].ch=ch;
	q_rel[n].n=nt;
}

static DWORD WriteDelta(BYTE* t,DWORD dt)
{
	int tl=3;
	DWORD pos=0;
	if (dt)
	{
		while(dt>>(7*tl) == 0) tl--;
		do
		{
			t[pos++]=((dt>>(7*(tl--)))&0x7F)|0x80;
		} while(tl>=0);
		t[pos-1]&=0x7F;
	}
	else t[pos++]=0;
	return pos;
}

static DWORD ReadDelta(BYTE* t,DWORD *p)
{
	DWORD d=0;
	BYTE b;
	do
	{
		b=t[(*p)++];
		d=(d<<7)|(b&0x7F);		
	} while(b&0x80);
	return d;
}

static void DoQueue(DWORD ct,DWORD& tw,BYTE& _run)
{
	UINT n,mt,_n;
_t:	
	mt=-1;
	for(n=0;n<Q_MAX;n++)
	{
		if (q_rel[n].tm<mt) {_n=n;mt=q_rel[n].tm;}
	}
	if (mt>ct) return;
	bw+=WriteDelta(buf+bw,mt-tw);
	tw=mt;
	BYTE _e=q_rel[_n].ch|0x90;
	if (_e!=_run) _run=buf[bw++]=_e;
	buf[bw++]=q_rel[_n].n;
	buf[bw++]=0;
	q_rel[_n].tm=-1;
	goto _t;
}

#define FixHeader(H) {(H).fmt=rev16((H).fmt);(H).trax=rev16((H).trax);(H).dtx=rev16((H).dtx);}

UINT inline DoTrack(BYTE* t)
{
	{
		UINT n;
		for(n=0;n<Q_MAX;n++) q_rel[n].tm=-1;
	}
	DWORD pt=0;
	DWORD ct=0,tw=0;
	BYTE run=0;
	BYTE _run=0;
	bw=0;
	while(1)
	{
		ct+=ReadDelta(t,&pt);
		DoQueue(ct,tw,_run);
		BYTE c=t[pt];
		if (c==0xFF)
		{
			DoQueue(-2,tw,_run);
			if (t[pt+1]==0x2f)
			{
				pt+=3;
				buf[bw++]=0;
				buf[bw++]=0xFF;
				buf[bw++]=0x2F;
				buf[bw++]=0;
				break;
			}
			return -1;
			
		}
		else if (c==0xF0)
		{
			bw+=WriteDelta(buf+bw,ct-tw);
			tw=ct;
			while(t[pt]!=0xF7) buf[bw++]=t[pt++];
			buf[bw++]=t[pt++];			
		}
		else if (c==0xFE)
		{
			c=t[pt+1];
			if (c==0x10)
			{
				pt+=t[pt+4]+9;
			}
			else if (c==0x14) pt+=4;
			else if (c==0x15) pt+=8;
			else return -1;
		}
		else
		{
			bw+=WriteDelta(buf+bw,ct-tw);
			tw=ct;
			if (c&0x80) {pt++;run=c;}
			else c=run;
			if (c!=_run) _run=buf[bw++]=c;
			buf[bw++]=t[pt++];
			BYTE c1=c&0xF0;
			if (c1!=0xC0 && c1!=0xD0) buf[bw++]=t[pt++];
			if (c1==0x90)
			{
				BYTE b=t[pt-2];
				DWORD _t=ct+ReadDelta(t,&pt);
				q_add(c&0xF,b,_t);
			}
		}
	}
	return pt;
}

extern BYTE hmp_track0[19];

DWORD _stdcall hmi_rip(HANDLE src,HANDLE f)
{
	if (!convert)
	{
		DWORD _s;
		ReadFile(src,buf,512*1024,&_s,0);
		UINT ntrax=*(DWORD*)(buf+0xE4);
		UINT n;
		DWORD _p=0;
		while(_p<_s)
		{
			_p++;
			if (*(DWORD*)(buf+_p)==_rv('TRAC')) goto _o;
		}
		return RIP_ERROR;
_o:
		_p-=8;
		for(n=0;n<ntrax;n++)
		{
			if (*(DWORD*)(buf+_p)!=_rv('HMI-')) return RIP_ERROR;
			while(_p<_s)
			{
				if ((*(DWORD*)(buf+_p)&0xFFFFFF)==0x002FFF) {_p+=3;goto _o1;}
				_p++;
			}
			return RIP_ERROR;
_o1:;	}

		WriteFile(f,buf,_p,&_s,0);
		return _p;
	}
	BYTE* _buf=buf+(BUF_SIZE>>1);
	DWORD sz=BUF_SIZE>>1;
	ReadFile(src,_buf,sz,&sz,0);
	BYTE *ptr=_buf;
	SetFilePointer(f,14,0,FILE_BEGIN);
	while(*(DWORD*)ptr!=_rv('TRAC'))
	{
		ptr++;
		if (ptr>_buf+sz) return RIP_ERROR;
	}
	ptr-=8;
	UINT nft=*(DWORD*)(_buf+0xE4);
	UINT ntrax=1;
	DWORD b;
	DWORD dw;
	WriteFile(f,hmp_track0,sizeof(hmp_track0),&b,0);
	UINT n;
	for(n=0;n<nft;n++)
	{
		if (memcmp(ptr,"HMI-MIDITRACK",13)) return RIP_ERROR;
		ntrax++;
		ptr+=ptr[0x57];
		{
			DWORD _d=DoTrack(ptr);
			if (_d==-1) return RIP_ERROR;
			ptr+=_d;
		}
		dw='krTM';
		WriteFile(f,&dw,4,&b,0);
		dw=rev32(bw);
		WriteFile(f,&dw,4,&b,0);
		WriteFile(f,buf,bw,&b,0);
	}

	SetFilePointer(f,0,0,FILE_BEGIN);
	dw='dhTM';
	WriteFile(f,&dw,4,&b,0);
	dw=0x06000000;
	WriteFile(f,&dw,4,&b,0);
	MIDIHEADER mhd={0x0100,rev16(ntrax),0xC000};
	WriteFile(f,&mhd,6,&b,0);
	return ptr-_buf;
}

bool _stdcall hmi_test(const void* buf,DWORD max,char* info,char* ext)
{
	if (max > 0x40 && *(DWORD*)buf==_rv('HMI-') && *((DWORD*)buf+1)==_rv('MIDI') && *((DWORD*)buf+2)==_rv('SONG') && ((DWORD*)buf)[0x39]<256)
	{
		*info=0;
		strcpy(ext,convert?"MID":"HMI");
		wsprintf(info,"%u tracks",((DWORD*)buf)[0x39]);
		return 1;
	}
	return 0;
}

void _stdcall hmi_init(HKEY hk)
{
	DWORD s = sizeof(bool);
	RegQueryValueEx(hk,"hmi_convert",0,0,(BYTE*)&convert,&s);
}

void _stdcall hmi_quit(HKEY hk)
{
	RegSetValueEx(hk,"hmi_convert",0,REG_BINARY,(BYTE*)&convert,sizeof(bool));
}

void _stdcall hmi_config(HWND wnd)
{
	cvt_cfg("HMI","convert to MID",&convert,wnd);
}

RIPPER HMI_ripper = {hmi_test,0,_rv('HMI-'),0xFFFFFFFF,0,hmi_rip,hmi_init,hmi_quit,hmi_config,"HMI","HMI (MIDI clone)\x0D\x0ANewer version of HMP."};