#include "main.h"
#include <mmreg.h>

void InitWAV(HANDLE f,UINT freq,UINT nch,UINT bps);
void CloseWAV(HANDLE f);

#pragma pack(push)
#pragma pack(1)
typedef struct
{
	short sample0;
	BYTE index;
	BYTE reserved;
	BYTE data[508];
} WAV_chunk;

#define SamplesPerSec SPS

typedef struct
{
	WORD SPS;
	DWORD Size;
	DWORD OutSize;
	WORD fmt;
} AUD_header;

typedef struct
{
	WORD SPS;
	DWORD Size;
	WORD fmt;
} AUD_header1;

#define FMT_IMA 0x6302
#define FMT_WS 0x0100

typedef struct
{
	WORD Size;
	WORD OutSize;
	DWORD ID;
} Chunk_header;

typedef struct
{
	AUD_header ahd;
	Chunk_header chd;	
} test_header;

typedef struct
{
	AUD_header1 ahd;
	Chunk_header chd;	
} test_header1;

#pragma pack(pop)


int WSTable2bit[]={-2,-1,0,1};

int WSTable4bit[]={-9, -8, -6, -5, -4, -3, -2, -1,  0,  1,  2,  3,  4,  5,  6,  8};

int IndexTab[ 16 ] = { -1, -1, -1, -1, 2, 4, 6, 8,

-1, -1, -1, -1, 2, 4, 6, 8 };


int StepTab[ 89 ] = {

7, 8, 9, 10, 11, 12, 13, 14,

16, 17, 19, 21, 23, 25, 28, 31,

34, 37, 41, 45, 50, 55, 60, 66,

73, 80, 88, 97, 107, 118, 130, 143,

157, 173, 190, 209, 230, 253, 279, 307,

337, 371, 408, 449, 494, 544, 598, 658,

724, 796, 876, 963, 1060, 1166, 1282, 1411,

1552, 1707, 1878, 2066, 2272, 2499, 2749, 3024,

3327, 3660, 4026, 4428, 4871, 5358, 5894, 6484,

7132, 7845, 8630, 9493, 10442, 11487, 12635, 13899,

15289, 16818, 18500, 20350, 22385, 24623, 27086, 29794,

32767 };

IMAADPCMWAVEFORMAT wfx_ima=
{
	{
		WAVE_FORMAT_IMA_ADPCM,
		1,
		22050,
		11100,
		512,
		4,
		2
	},
	1017
};

static bool convert = 1, rip_music = 1, rip_sfx = 0;

void AUD2WAV(BYTE* data,UINT nsam,HANDLE f)
{
	DWORD dw=0x46464952;
	ULONG br;
	WriteFile(f,&dw,4,&br,0);
	dw=((nsam+1016)/1017)*512+32+sizeof(wfx_ima);
	WriteFile(f,&dw,4,&br,0); //0x04:RIFF chunk size
	dw=0x45564157;
	WriteFile(f,&dw,4,&br,0);
	dw=0x20746D66;
	WriteFile(f,&dw,4,&br,0);
	dw=sizeof(wfx_ima);
	WriteFile(f,&dw,4,&br,0);
	WriteFile(f,&wfx_ima,sizeof(wfx_ima),&br,0);
	dw=0x74636166;
	WriteFile(f,&dw,4,&br,0);
	dw=4;
	WriteFile(f,&dw,4,&br,0);
	WriteFile(f,&nsam,4,&br,0);
	dw=0x61746164;
	WriteFile(f,&dw,4,&br,0);
	dw=((nsam+1016)/1017)*512;
	WriteFile(f,&dw,4,&br,0); //sizeof(wfx_ima)+40:data size
	int n=0;
	WAV_chunk wc;
	wc.reserved=0;
	int sample=0;
	char index=0;
	int x;				
	int delta;
	unsigned char Code;
	while(n<nsam)
	{
		wc.sample0=sample;
		wc.index=index;
		if (n&1)
		{
			int n1=n>>1;
			for(x=0;x<508;x++) wc.data[x]=((data[n1+x]>>4)&0x0F)| ((data[n1+x+1]<<4) & 0xF0);
		}
		else memcpy(wc.data,data+(n>>1),508);
		WriteFile(f,&wc,512,&br,0);
		for(x=0;x<1017;x++)
		{
			if (n&1) Code=(data[n>>1]>>4)&0x0F;
			else Code=data[n>>1]&0x0F;
			delta=StepTab[index]>>3;
			if (Code & 4) delta+=StepTab[index];
			if (Code & 2) delta+=StepTab[index]>>1;
			if (Code & 1) delta+=StepTab[index]>>2;
			if (Code & 8) sample-=delta; else sample+=delta;
			if (sample>32767) sample=32767;
			else if (sample<-32768) sample=-32768;
			index+=IndexTab[Code];
			if (index<0) index=0;
			else if (index>88) index=88;
			n++;
		}
	}
}

#define ahd_ok(X) (((X).fmt==FMT_IMA || (X).fmt==FMT_WS) && ((X).SPS==22050 || (X).SPS==22222))

#define hdr ((test_header*)hd)
bool _stdcall test_aud(const void* hd,DWORD sz,char* info,char* ext)
{
	if (ahd_ok(hdr->ahd) && hdr->chd.ID==0x0000DEAF && sz>=hdr->ahd.Size+sizeof(AUD_header))
	{
		bool ret = (hdr->ahd.Size > 300 * 1024) ? rip_music : rip_sfx;
		if (ret)
		{
			UINT smp = hdr->ahd.OutSize;
			if (hdr->ahd.fmt==FMT_IMA) smp>>=1;
			UINT sec = smp / hdr->ahd.SamplesPerSec;
			wsprintf(info,"Duration: %u:%02u   samples: %u",sec/60,sec%60,smp);
			strcpy(ext,convert?"WAV":"AUD");
		}
		return ret;
	}
	else return 0;
}
#undef hdr

#define hdr ((test_header1*)hd)
bool _stdcall test_aud1(const void* hd,DWORD sz,char* info,char* ext)
{
	if (ahd_ok(hdr->ahd) && hdr->chd.ID==0x0000DEAF && sz>=hdr->ahd.Size+sizeof(AUD_header1))
	{
		bool ret = (hdr->ahd.Size > 300 * 1024) ? rip_music : rip_sfx;
		if (ret)
		{
			*info=0;
			strcpy(ext,convert?"WAV":"AUD");
		}
		return ret;
	}
	else return 0;
}
#undef hdr

void WS_decode(BYTE* src,BYTE* out,DWORD os,DWORD s)
{
	if (s==os)
	{
		memcpy(out,src,os);
		return;
	}
	UINT ip=0,op=0;
	BYTE code;
	int sample=0x80;
	while(op<os)
	{
		code=src[ip++];
		BYTE fmt=code>>6;
		BYTE cnt=(code&0x3F);
		switch(fmt)
		{
		case 0:
			cnt++;
			while(cnt)
			{
				code=src[ip++];
				sample+=WSTable2bit[code&3];
				if (sample<0) sample=0;
				else if (sample>255) sample=255;
				out[op++]=(BYTE)sample;
				sample+=WSTable2bit[(code>>2)&3];
				if (sample<0) sample=0;
				else if (sample>255) sample=255;
				out[op++]=(BYTE)sample;
				sample+=WSTable2bit[(code>>4)&3];
				if (sample<0) sample=0;
				else if (sample>255) sample=255;
				out[op++]=(BYTE)sample;
				sample+=WSTable2bit[(code>>6)&3];
				if (sample<0) sample=0;
				else if (sample>255) sample=255;
				out[op++]=(BYTE)sample;
				cnt--;
			}
			break;
		case 1:
			cnt++;
			while(cnt)
			{
				code=src[ip++];
				sample+=WSTable4bit[code&0xF];
				if (sample<0) sample=0;
				else if (sample>255) sample=255;
				out[op++]=(BYTE)sample;
				sample+=WSTable4bit[(code>>4)&0xF];
				if (sample<0) sample=0;
				else if (sample>255) sample=255;
				out[op++]=(BYTE)sample;
				cnt--;
			}
			break;
		case 2:
			if (cnt & 0x20)
			{
				sample+=((char)(cnt<<3))>>3;
				if (sample<0) sample=0;
				else if (sample>255) sample=255;
				out[op++]=sample;
			}
			else
			{
				cnt++;
				while(cnt)
				{
					out[op++]=src[ip++];
					cnt--;
				}
				sample=out[op-1];
			}
			break;
		case 3:
			cnt++;
			while(cnt)
			{
				out[op++]=(BYTE)sample;
				cnt--;
			}
			break;

		}										
	}
}

bool rip_aud_internal(HANDLE hMix,HANDLE dst,AUD_header& hd)
{
	Chunk_header chd;
	ULONG br;
	UINT p=0;	
	BYTE* data=0;
	if (hd.fmt==FMT_WS)
	{
		InitWAV(dst,hd.SamplesPerSec,1,1);
		DWORD rd=0;
		while(rd<hd.Size)
		{
			ReadFile(hMix,&chd,sizeof(chd),&br,0);
			rd+=sizeof(chd);
			if (chd.ID!=0x0000DEAF || chd.Size+chd.OutSize>BUF_SIZE) break;
			ReadFile(hMix,buf,chd.Size,&br,0);
			rd+=chd.Size;
			BYTE* out=buf+chd.Size;
			WS_decode(buf,out,chd.OutSize,chd.Size);
			WriteFile(dst,out,chd.OutSize,&br,0);
		}
		CloseWAV(dst);
		return 1;
	}
	else
	{
		DWORD ret=0;
		ReadFile(hMix,&chd,sizeof(chd),&br,0);
		ret+=sizeof(chd);
		{
			DWORD t = (hd.OutSize>>2)+512;
			if (t<=BUF_SIZE) data=(BYTE*)buf;
			else data=(BYTE*)LocalAlloc(LMEM_FIXED,t);
		}
		if (data==0) goto fail;
		while(1)
		{
			if (!ReadFile(hMix,data+p,chd.Size,&br,0)) goto fail;
			ret+=chd.Size;
			p+=chd.Size;
			if (ret>=hd.Size) break;
			if (!ReadFile(hMix,&chd,sizeof(chd),&br,0)) goto fail;
			if (chd.ID!=0x0000DEAF) break;
			ret+=sizeof(chd);
		}
eof:
		if (p) AUD2WAV(data,2*p,dst);
		if (data!=buf) LocalFree(data);
		return 1;
fail:
		if (data && data!=buf) LocalFree(data);
		return 0;
	}
}

DWORD _stdcall rip_aud(HANDLE hMix,HANDLE dst)
{
	AUD_header hd;
	DWORD br;
	ReadFile(hMix,&hd,sizeof(hd),&br,0);
	if (convert)
	{
		if (!rip_aud_internal(hMix,dst,hd)) return RIP_ERROR;
	}
	else
	{
		WriteFile(dst,&hd,sizeof(hd),&br,0);
		xfer(hMix,dst,hd.Size);
	}
	return hd.Size+sizeof(hd);
}

DWORD _stdcall rip_aud1(HANDLE hMix,HANDLE dst)
{
	AUD_header1 hd1;
	DWORD br;
	ReadFile(hMix,&hd1,sizeof(hd1),&br,0);
	if (convert)
	{
		AUD_header hd;
		hd.SamplesPerSec=22050;
		hd.Size=hd1.Size;
		hd.OutSize=hd1.Size*4;
		hd.fmt=hd1.fmt;
		if (!rip_aud_internal(hMix,dst,hd)) return RIP_ERROR;
	}
	else
	{
		WriteFile(dst,&hd1,sizeof(hd1),&br,0);
		xfer(hMix,dst,hd1.Size);
	}
	return hd1.Size+sizeof(hd1);
}

BOOL CALLBACK AudDlgProc(HWND wnd,UINT msg,WPARAM wp,LPARAM lp)
{
	switch(msg)
	{
	case WM_INITDIALOG:
		SendDlgItemMessage(wnd,IDC_CONVERT,BM_SETCHECK,convert ? BST_CHECKED : BST_UNCHECKED,0);
		SendDlgItemMessage(wnd,IDC_RIP1,BM_SETCHECK,rip_music ? BST_CHECKED : BST_UNCHECKED,0);
		SendDlgItemMessage(wnd,IDC_RIP2,BM_SETCHECK,rip_sfx ? BST_CHECKED : BST_UNCHECKED,0);
		return 1;
	case WM_COMMAND:
		if (HIWORD(wp) == BN_CLICKED)
			switch(LOWORD(wp))
			{
			case IDOK:
				convert = SendDlgItemMessage(wnd,IDC_CONVERT,BM_GETCHECK,0,0);
				rip_music = SendDlgItemMessage(wnd,IDC_RIP1,BM_GETCHECK,0,0);
				rip_sfx = SendDlgItemMessage(wnd,IDC_RIP2,BM_GETCHECK,0,0);
				EndDialog(wnd,1);
				break;
			case IDCANCEL:
				EndDialog(wnd,0);
				break;
			}
		return 1;
	default:
		return 0;
	}
}

void _stdcall aud_config(HWND wnd)
{
	DialogBox(hIns,(char*)IDD_AUD,wnd,AudDlgProc);
}

void _stdcall aud_init(HKEY hk)
{
	DWORD s = sizeof(bool);
	RegQueryValueEx(hk,"aud_convert",0,0,(BYTE*)&convert,&s);
	s = sizeof(bool);
	RegQueryValueEx(hk,"aud_ripmusic",0,0,(BYTE*)&rip_music,&s);
	s = sizeof(bool);
	RegQueryValueEx(hk,"aud_ripsfx",0,0,(BYTE*)&rip_sfx,&s);
}

void _stdcall aud_quit(HKEY hk)
{
	RegSetValueEx(hk,"aud_convert",0,REG_BINARY,(BYTE*)&convert,sizeof(bool));
	RegSetValueEx(hk,"aud_ripmusic",0,REG_BINARY,(BYTE*)&rip_music,sizeof(bool));
	RegSetValueEx(hk,"aud_ripsfx",0,REG_BINARY,(BYTE*)&rip_sfx,sizeof(bool));
}

RIPPER AUD_ripper={test_aud,0,0xDEAF,0xFFFFFFFF,16,rip_aud,aud_init,aud_quit,aud_config,"AUD","C&C AUD format (waveform, ADPCM compressed)\x0D\x0AUsed to store sound in C&C games."};

RIPPER AUD1_ripper={test_aud1,0,0xDEAF,0xFFFFFFFF,12,rip_aud1,0,0,aud_config,"AUD","Old AUD format (waveform, ADPCM compressed)\x0D\x0AUsed to store sound in old Westwood games."};

#define hdr ((test_header*)hd)
bool _stdcall aud_test(const void* hd,DWORD sz,char* info,char* ext)
{
	return (ahd_ok(hdr->ahd) && hdr->chd.ID==0x0000DEAF && sz>hdr->ahd.Size+sizeof(AUD_header));
}
#undef hdr

DWORD _stdcall skip_aud(HANDLE src)
{
	AUD_header ahd;
	DWORD br;
	ReadFile(src,&ahd,sizeof(ahd),&br,0);
	return sizeof(ahd)+ahd.Size;
}

#define hdr ((test_header1*)hd)
bool _stdcall aud_test1(const void* hd,DWORD sz,char* info,char* ext)
{
	return (ahd_ok(hdr->ahd) && hdr->chd.ID==0x0000DEAF && sz>hdr->ahd.Size+sizeof(AUD_header));
}
#undef hdr

DWORD _stdcall skip_aud1(HANDLE src)
{
	AUD_header1 ahd;
	DWORD br;
	ReadFile(src,&ahd,sizeof(ahd),&br,0);
	return sizeof(ahd)+ahd.Size;
}

SKIPPER AUD_skipper={aud_test,1,0xDEAF,0xFFFFFFFF,16,skip_aud,1};
SKIPPER AUD1_skipper={aud_test1,1,0xDEAF,0xFFFFFFFF,12,skip_aud1,1};
