//-------------------------------------------------------------------------
/*
Copyright (C) 1996, 2003 - 3D Realms Entertainment
Copyright (C) 2000, 2003 - Matt Saettler (EDuke Enhancements)
Copyright (C) 2004, 2007 - EDuke32 developers

This file is part of EDuke32

EDuke32 is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License version 2
as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/
//-------------------------------------------------------------------------

// Maybe this should be called "hacks.c" instead of "namesdyn.c"...

#include "build.h"
#include "duke3d.h"
#include "compat.h"

struct dynitem
{
    char *s;
    int *v;
    short vstat;
    short val;
};
struct HASH_table dynnamesH = {512, NULL};

struct dynitem list[]=
{
    {"SECTOREFFECTOR",&SECTOREFFECTOR,SECTOREFFECTOR__STATIC,1},
    {"ACTIVATOR",&ACTIVATOR,ACTIVATOR__STATIC,2},
    {"TOUCHPLATE",&TOUCHPLATE,TOUCHPLATE__STATIC,3},
    {"ACTIVATORLOCKED",&ACTIVATORLOCKED,ACTIVATORLOCKED__STATIC,4},
    {"MUSICANDSFX",&MUSICANDSFX,MUSICANDSFX__STATIC,5},
    {"LOCATORS",&LOCATORS,LOCATORS__STATIC,6},
    {"CYCLER",&CYCLER,CYCLER__STATIC,7},
    {"MASTERSWITCH",&MASTERSWITCH,MASTERSWITCH__STATIC,8},
    {"RESPAWN",&RESPAWN,RESPAWN__STATIC,9},
    {"GPSPEED",&GPSPEED,GPSPEED__STATIC,10},
    {"FOF",&FOF,FOF__STATIC,13},
    {"ARROW",&ARROW,ARROW__STATIC,20},
    {"FIRSTGUNSPRITE",&FIRSTGUNSPRITE,FIRSTGUNSPRITE__STATIC,21},
    {"CHAINGUNSPRITE",&CHAINGUNSPRITE,CHAINGUNSPRITE__STATIC,22},
    {"RPGSPRITE",&RPGSPRITE,RPGSPRITE__STATIC,23},
    {"FREEZESPRITE",&FREEZESPRITE,FREEZESPRITE__STATIC,24},
    {"SHRINKERSPRITE",&SHRINKERSPRITE,SHRINKERSPRITE__STATIC,25},
    {"HEAVYHBOMB",&HEAVYHBOMB,HEAVYHBOMB__STATIC,26},
    {"TRIPBOMBSPRITE",&TRIPBOMBSPRITE,TRIPBOMBSPRITE__STATIC,27},
    {"SHOTGUNSPRITE",&SHOTGUNSPRITE,SHOTGUNSPRITE__STATIC,28},
    {"DEVISTATORSPRITE",&DEVISTATORSPRITE,DEVISTATORSPRITE__STATIC,29},
    {"HEALTHBOX",&HEALTHBOX,HEALTHBOX__STATIC,30},
    {"AMMOBOX",&AMMOBOX,AMMOBOX__STATIC,31},
    {"GROWSPRITEICON",&GROWSPRITEICON,GROWSPRITEICON__STATIC,32},
    {"INVENTORYBOX",&INVENTORYBOX,INVENTORYBOX__STATIC,33},
    {"FREEZEAMMO",&FREEZEAMMO,FREEZEAMMO__STATIC,37},
    {"AMMO",&AMMO,AMMO__STATIC,40},
    {"BATTERYAMMO",&BATTERYAMMO,BATTERYAMMO__STATIC,41},
    {"DEVISTATORAMMO",&DEVISTATORAMMO,DEVISTATORAMMO__STATIC,42},
    {"RPGAMMO",&RPGAMMO,RPGAMMO__STATIC,44},
    {"GROWAMMO",&GROWAMMO,GROWAMMO__STATIC,45},
    {"CRYSTALAMMO",&CRYSTALAMMO,CRYSTALAMMO__STATIC,46},
    {"HBOMBAMMO",&HBOMBAMMO,HBOMBAMMO__STATIC,47},
    {"AMMOLOTS",&AMMOLOTS,AMMOLOTS__STATIC,48},
    {"SHOTGUNAMMO",&SHOTGUNAMMO,SHOTGUNAMMO__STATIC,49},
    {"COLA",&COLA,COLA__STATIC,51},
    {"SIXPAK",&SIXPAK,SIXPAK__STATIC,52},
    {"FIRSTAID",&FIRSTAID,FIRSTAID__STATIC,53},
    {"SHIELD",&SHIELD,SHIELD__STATIC,54},
    {"STEROIDS",&STEROIDS,STEROIDS__STATIC,55},
    {"AIRTANK",&AIRTANK,AIRTANK__STATIC,56},
    {"JETPACK",&JETPACK,JETPACK__STATIC,57},
    {"HEATSENSOR",&HEATSENSOR,HEATSENSOR__STATIC,59},
    {"ACCESSCARD",&ACCESSCARD,ACCESSCARD__STATIC,60},
    {"BOOTS",&BOOTS,BOOTS__STATIC,61},
    {"MIRRORBROKE",&MIRRORBROKE,MIRRORBROKE__STATIC,70},
    {"CLOUDYOCEAN",&CLOUDYOCEAN,CLOUDYOCEAN__STATIC,78},
    {"CLOUDYSKIES",&CLOUDYSKIES,CLOUDYSKIES__STATIC,79},
    {"MOONSKY1",&MOONSKY1,MOONSKY1__STATIC,80},
    {"MOONSKY2",&MOONSKY2,MOONSKY2__STATIC,81},
    {"MOONSKY3",&MOONSKY3,MOONSKY3__STATIC,82},
    {"MOONSKY4",&MOONSKY4,MOONSKY4__STATIC,83},
    {"BIGORBIT1",&BIGORBIT1,BIGORBIT1__STATIC,84},
    {"BIGORBIT2",&BIGORBIT2,BIGORBIT2__STATIC,85},
    {"BIGORBIT3",&BIGORBIT3,BIGORBIT3__STATIC,86},
    {"BIGORBIT4",&BIGORBIT4,BIGORBIT4__STATIC,87},
    {"BIGORBIT5",&BIGORBIT5,BIGORBIT5__STATIC,88},
    {"LA",&LA,LA__STATIC,89},
    {"REDSKY1",&REDSKY1,REDSKY1__STATIC,98},
    {"REDSKY2",&REDSKY2,REDSKY2__STATIC,99},
    {"ATOMICHEALTH",&ATOMICHEALTH,ATOMICHEALTH__STATIC,100},
    {"TECHLIGHT2",&TECHLIGHT2,TECHLIGHT2__STATIC,120},
    {"TECHLIGHTBUST2",&TECHLIGHTBUST2,TECHLIGHTBUST2__STATIC,121},
    {"TECHLIGHT4",&TECHLIGHT4,TECHLIGHT4__STATIC,122},
    {"TECHLIGHTBUST4",&TECHLIGHTBUST4,TECHLIGHTBUST4__STATIC,123},
    {"WALLLIGHT4",&WALLLIGHT4,WALLLIGHT4__STATIC,124},
    {"WALLLIGHTBUST4",&WALLLIGHTBUST4,WALLLIGHTBUST4__STATIC,125},
    {"ACCESSSWITCH",&ACCESSSWITCH,ACCESSSWITCH__STATIC,130},
    {"SLOTDOOR",&SLOTDOOR,SLOTDOOR__STATIC,132},
    {"LIGHTSWITCH",&LIGHTSWITCH,LIGHTSWITCH__STATIC,134},
    {"SPACEDOORSWITCH",&SPACEDOORSWITCH,SPACEDOORSWITCH__STATIC,136},
    {"SPACELIGHTSWITCH",&SPACELIGHTSWITCH,SPACELIGHTSWITCH__STATIC,138},
    {"FRANKENSTINESWITCH",&FRANKENSTINESWITCH,FRANKENSTINESWITCH__STATIC,140},
    {"NUKEBUTTON",&NUKEBUTTON,NUKEBUTTON__STATIC,142},
    {"MULTISWITCH",&MULTISWITCH,MULTISWITCH__STATIC,146},
    {"DOORTILE5",&DOORTILE5,DOORTILE5__STATIC,150},
    {"DOORTILE6",&DOORTILE6,DOORTILE6__STATIC,151},
    {"DOORTILE1",&DOORTILE1,DOORTILE1__STATIC,152},
    {"DOORTILE2",&DOORTILE2,DOORTILE2__STATIC,153},
    {"DOORTILE3",&DOORTILE3,DOORTILE3__STATIC,154},
    {"DOORTILE4",&DOORTILE4,DOORTILE4__STATIC,155},
    {"DOORTILE7",&DOORTILE7,DOORTILE7__STATIC,156},
    {"DOORTILE8",&DOORTILE8,DOORTILE8__STATIC,157},
    {"DOORTILE9",&DOORTILE9,DOORTILE9__STATIC,158},
    {"DOORTILE10",&DOORTILE10,DOORTILE10__STATIC,159},
    {"DOORSHOCK",&DOORSHOCK,DOORSHOCK__STATIC,160},
    {"DIPSWITCH",&DIPSWITCH,DIPSWITCH__STATIC,162},
    {"DIPSWITCH2",&DIPSWITCH2,DIPSWITCH2__STATIC,164},
    {"TECHSWITCH",&TECHSWITCH,TECHSWITCH__STATIC,166},
    {"DIPSWITCH3",&DIPSWITCH3,DIPSWITCH3__STATIC,168},
    {"ACCESSSWITCH2",&ACCESSSWITCH2,ACCESSSWITCH2__STATIC,170},
    {"REFLECTWATERTILE",&REFLECTWATERTILE,REFLECTWATERTILE__STATIC,180},
    {"FLOORSLIME",&FLOORSLIME,FLOORSLIME__STATIC,200},
    {"BIGFORCE",&BIGFORCE,BIGFORCE__STATIC,230},
    {"EPISODE",&EPISODE,EPISODE__STATIC,247},
    {"MASKWALL9",&MASKWALL9,MASKWALL9__STATIC,255},
    {"W_LIGHT",&W_LIGHT,W_LIGHT__STATIC,260},
    {"SCREENBREAK1",&SCREENBREAK1,SCREENBREAK1__STATIC,263},
    {"SCREENBREAK2",&SCREENBREAK2,SCREENBREAK2__STATIC,264},
    {"SCREENBREAK3",&SCREENBREAK3,SCREENBREAK3__STATIC,265},
    {"SCREENBREAK4",&SCREENBREAK4,SCREENBREAK4__STATIC,266},
    {"SCREENBREAK5",&SCREENBREAK5,SCREENBREAK5__STATIC,267},
    {"SCREENBREAK6",&SCREENBREAK6,SCREENBREAK6__STATIC,268},
    {"SCREENBREAK7",&SCREENBREAK7,SCREENBREAK7__STATIC,269},
    {"SCREENBREAK8",&SCREENBREAK8,SCREENBREAK8__STATIC,270},
    {"SCREENBREAK9",&SCREENBREAK9,SCREENBREAK9__STATIC,271},
    {"SCREENBREAK10",&SCREENBREAK10,SCREENBREAK10__STATIC,272},
    {"SCREENBREAK11",&SCREENBREAK11,SCREENBREAK11__STATIC,273},
    {"SCREENBREAK12",&SCREENBREAK12,SCREENBREAK12__STATIC,274},
    {"SCREENBREAK13",&SCREENBREAK13,SCREENBREAK13__STATIC,275},
    {"MASKWALL1",&MASKWALL1,MASKWALL1__STATIC,285},
    {"W_TECHWALL1",&W_TECHWALL1,W_TECHWALL1__STATIC,293},
    {"W_TECHWALL2",&W_TECHWALL2,W_TECHWALL2__STATIC,297},
    {"W_TECHWALL15",&W_TECHWALL15,W_TECHWALL15__STATIC,299},
    {"W_TECHWALL3",&W_TECHWALL3,W_TECHWALL3__STATIC,301},
    {"W_TECHWALL4",&W_TECHWALL4,W_TECHWALL4__STATIC,305},
    {"W_TECHWALL10",&W_TECHWALL10,W_TECHWALL10__STATIC,306},
    {"W_TECHWALL16",&W_TECHWALL16,W_TECHWALL16__STATIC,307},
    {"WATERTILE2",&WATERTILE2,WATERTILE2__STATIC,336},
    {"BPANNEL1",&BPANNEL1,BPANNEL1__STATIC,341},
    {"PANNEL1",&PANNEL1,PANNEL1__STATIC,342},
    {"PANNEL2",&PANNEL2,PANNEL2__STATIC,343},
    {"WATERTILE",&WATERTILE,WATERTILE__STATIC,344},
    {"STATIC",&STATIC,STATIC__STATIC,351},
    {"W_SCREENBREAK",&W_SCREENBREAK,W_SCREENBREAK__STATIC,357},
    {"W_HITTECHWALL3",&W_HITTECHWALL3,W_HITTECHWALL3__STATIC,360},
    {"W_HITTECHWALL4",&W_HITTECHWALL4,W_HITTECHWALL4__STATIC,361},
    {"W_HITTECHWALL2",&W_HITTECHWALL2,W_HITTECHWALL2__STATIC,362},
    {"W_HITTECHWALL1",&W_HITTECHWALL1,W_HITTECHWALL1__STATIC,363},
    {"MASKWALL10",&MASKWALL10,MASKWALL10__STATIC,387},
    {"MASKWALL11",&MASKWALL11,MASKWALL11__STATIC,391},
    {"DOORTILE22",&DOORTILE22,DOORTILE22__STATIC,395},
    {"FANSPRITE",&FANSPRITE,FANSPRITE__STATIC,407},
    {"FANSPRITEBROKE",&FANSPRITEBROKE,FANSPRITEBROKE__STATIC,411},
    {"FANSHADOW",&FANSHADOW,FANSHADOW__STATIC,412},
    {"FANSHADOWBROKE",&FANSHADOWBROKE,FANSHADOWBROKE__STATIC,416},
    {"DOORTILE18",&DOORTILE18,DOORTILE18__STATIC,447},
    {"DOORTILE19",&DOORTILE19,DOORTILE19__STATIC,448},
    {"DOORTILE20",&DOORTILE20,DOORTILE20__STATIC,449},
    {"SATELLITE",&SATELLITE,SATELLITE__STATIC,489},
    {"VIEWSCREEN2",&VIEWSCREEN2,VIEWSCREEN2__STATIC,499},
    {"VIEWSCREENBROKE",&VIEWSCREENBROKE,VIEWSCREENBROKE__STATIC,501},
    {"VIEWSCREEN",&VIEWSCREEN,VIEWSCREEN__STATIC,502},
    {"GLASS",&GLASS,GLASS__STATIC,503},
    {"GLASS2",&GLASS2,GLASS2__STATIC,504},
    {"STAINGLASS1",&STAINGLASS1,STAINGLASS1__STATIC,510},
    {"MASKWALL5",&MASKWALL5,MASKWALL5__STATIC,514},
    {"SATELITE",&SATELITE,SATELITE__STATIC,516},
    {"FUELPOD",&FUELPOD,FUELPOD__STATIC,517},
    {"SLIMEPIPE",&SLIMEPIPE,SLIMEPIPE__STATIC,538},
    {"CRACK1",&CRACK1,CRACK1__STATIC,546},
    {"CRACK2",&CRACK2,CRACK2__STATIC,547},
    {"CRACK3",&CRACK3,CRACK3__STATIC,548},
    {"CRACK4",&CRACK4,CRACK4__STATIC,549},
    {"FOOTPRINTS",&FOOTPRINTS,FOOTPRINTS__STATIC,550},
    {"DOMELITE",&DOMELITE,DOMELITE__STATIC,551},
    {"CAMERAPOLE",&CAMERAPOLE,CAMERAPOLE__STATIC,554},
    {"CHAIR1",&CHAIR1,CHAIR1__STATIC,556},
    {"CHAIR2",&CHAIR2,CHAIR2__STATIC,557},
    {"BROKENCHAIR",&BROKENCHAIR,BROKENCHAIR__STATIC,559},
    {"MIRROR",&MIRROR,MIRROR__STATIC,560},
    {"WATERFOUNTAIN",&WATERFOUNTAIN,WATERFOUNTAIN__STATIC,563},
    {"WATERFOUNTAINBROKE",&WATERFOUNTAINBROKE,WATERFOUNTAINBROKE__STATIC,567},
    {"FEMMAG1",&FEMMAG1,FEMMAG1__STATIC,568},
    {"TOILET",&TOILET,TOILET__STATIC,569},
    {"STALL",&STALL,STALL__STATIC,571},
    {"STALLBROKE",&STALLBROKE,STALLBROKE__STATIC,573},
    {"FEMMAG2",&FEMMAG2,FEMMAG2__STATIC,577},
    {"REACTOR2",&REACTOR2,REACTOR2__STATIC,578},
    {"REACTOR2BURNT",&REACTOR2BURNT,REACTOR2BURNT__STATIC,579},
    {"REACTOR2SPARK",&REACTOR2SPARK,REACTOR2SPARK__STATIC,580},
    {"GRATE1",&GRATE1,GRATE1__STATIC,595},
    {"BGRATE1",&BGRATE1,BGRATE1__STATIC,596},
    {"SOLARPANNEL",&SOLARPANNEL,SOLARPANNEL__STATIC,602},
    {"NAKED1",&NAKED1,NAKED1__STATIC,603},
    {"ANTENNA",&ANTENNA,ANTENNA__STATIC,607},
    {"MASKWALL12",&MASKWALL12,MASKWALL12__STATIC,609},
    {"TOILETBROKE",&TOILETBROKE,TOILETBROKE__STATIC,615},
    {"PIPE2",&PIPE2,PIPE2__STATIC,616},
    {"PIPE1B",&PIPE1B,PIPE1B__STATIC,617},
    {"PIPE3",&PIPE3,PIPE3__STATIC,618},
    {"PIPE1",&PIPE1,PIPE1__STATIC,619},
    {"CAMERA1",&CAMERA1,CAMERA1__STATIC,621},
    {"BRICK",&BRICK,BRICK__STATIC,626},
    {"SPLINTERWOOD",&SPLINTERWOOD,SPLINTERWOOD__STATIC,630},
    {"PIPE2B",&PIPE2B,PIPE2B__STATIC,633},
    {"BOLT1",&BOLT1,BOLT1__STATIC,634},
    {"W_NUMBERS",&W_NUMBERS,W_NUMBERS__STATIC,640},
    {"WATERDRIP",&WATERDRIP,WATERDRIP__STATIC,660},
    {"WATERBUBBLE",&WATERBUBBLE,WATERBUBBLE__STATIC,661},
    {"WATERBUBBLEMAKER",&WATERBUBBLEMAKER,WATERBUBBLEMAKER__STATIC,662},
    {"W_FORCEFIELD",&W_FORCEFIELD,W_FORCEFIELD__STATIC,663},
    {"VACUUM",&VACUUM,VACUUM__STATIC,669},
    {"FOOTPRINTS2",&FOOTPRINTS2,FOOTPRINTS2__STATIC,672},
    {"FOOTPRINTS3",&FOOTPRINTS3,FOOTPRINTS3__STATIC,673},
    {"FOOTPRINTS4",&FOOTPRINTS4,FOOTPRINTS4__STATIC,674},
    {"EGG",&EGG,EGG__STATIC,675},
    {"SCALE",&SCALE,SCALE__STATIC,678},
    {"CHAIR3",&CHAIR3,CHAIR3__STATIC,680},
    {"CAMERALIGHT",&CAMERALIGHT,CAMERALIGHT__STATIC,685},
    {"MOVIECAMERA",&MOVIECAMERA,MOVIECAMERA__STATIC,686},
    {"IVUNIT",&IVUNIT,IVUNIT__STATIC,689},
    {"POT1",&POT1,POT1__STATIC,694},
    {"POT2",&POT2,POT2__STATIC,695},
    {"POT3",&POT3,POT3__STATIC,697},
    {"PIPE3B",&PIPE3B,PIPE3B__STATIC,700},
    {"WALLLIGHT3",&WALLLIGHT3,WALLLIGHT3__STATIC,701},
    {"WALLLIGHTBUST3",&WALLLIGHTBUST3,WALLLIGHTBUST3__STATIC,702},
    {"WALLLIGHT1",&WALLLIGHT1,WALLLIGHT1__STATIC,703},
    {"WALLLIGHTBUST1",&WALLLIGHTBUST1,WALLLIGHTBUST1__STATIC,704},
    {"WALLLIGHT2",&WALLLIGHT2,WALLLIGHT2__STATIC,705},
    {"WALLLIGHTBUST2",&WALLLIGHTBUST2,WALLLIGHTBUST2__STATIC,706},
    {"LIGHTSWITCH2",&LIGHTSWITCH2,LIGHTSWITCH2__STATIC,712},
    {"WAITTOBESEATED",&WAITTOBESEATED,WAITTOBESEATED__STATIC,716},
    {"DOORTILE14",&DOORTILE14,DOORTILE14__STATIC,717},
    {"STATUE",&STATUE,STATUE__STATIC,753},
    {"MIKE",&MIKE,MIKE__STATIC,762},
    {"VASE",&VASE,VASE__STATIC,765},
    {"SUSHIPLATE1",&SUSHIPLATE1,SUSHIPLATE1__STATIC,768},
    {"SUSHIPLATE2",&SUSHIPLATE2,SUSHIPLATE2__STATIC,769},
    {"SUSHIPLATE3",&SUSHIPLATE3,SUSHIPLATE3__STATIC,774},
    {"SUSHIPLATE4",&SUSHIPLATE4,SUSHIPLATE4__STATIC,779},
    {"DOORTILE16",&DOORTILE16,DOORTILE16__STATIC,781},
    {"SUSHIPLATE5",&SUSHIPLATE5,SUSHIPLATE5__STATIC,792},
    {"OJ",&OJ,OJ__STATIC,806},
    {"MASKWALL13",&MASKWALL13,MASKWALL13__STATIC,830},
    {"HURTRAIL",&HURTRAIL,HURTRAIL__STATIC,859},
    {"POWERSWITCH1",&POWERSWITCH1,POWERSWITCH1__STATIC,860},
    {"LOCKSWITCH1",&LOCKSWITCH1,LOCKSWITCH1__STATIC,862},
    {"POWERSWITCH2",&POWERSWITCH2,POWERSWITCH2__STATIC,864},
    {"ATM",&ATM,ATM__STATIC,867},
    {"STATUEFLASH",&STATUEFLASH,STATUEFLASH__STATIC,869},
    {"ATMBROKE",&ATMBROKE,ATMBROKE__STATIC,888},
    {"BIGHOLE2",&BIGHOLE2,BIGHOLE2__STATIC,893},
    {"STRIPEBALL",&STRIPEBALL,STRIPEBALL__STATIC,901},
    {"QUEBALL",&QUEBALL,QUEBALL__STATIC,902},
    {"POCKET",&POCKET,POCKET__STATIC,903},
    {"WOODENHORSE",&WOODENHORSE,WOODENHORSE__STATIC,904},
    {"TREE1",&TREE1,TREE1__STATIC,908},
    {"TREE2",&TREE2,TREE2__STATIC,910},
    {"CACTUS",&CACTUS,CACTUS__STATIC,911},
    {"MASKWALL2",&MASKWALL2,MASKWALL2__STATIC,913},
    {"MASKWALL3",&MASKWALL3,MASKWALL3__STATIC,914},
    {"MASKWALL4",&MASKWALL4,MASKWALL4__STATIC,915},
    {"FIREEXT",&FIREEXT,FIREEXT__STATIC,916},
    {"TOILETWATER",&TOILETWATER,TOILETWATER__STATIC,921},
    {"NEON1",&NEON1,NEON1__STATIC,925},
    {"NEON2",&NEON2,NEON2__STATIC,926},
    {"CACTUSBROKE",&CACTUSBROKE,CACTUSBROKE__STATIC,939},
    {"BOUNCEMINE",&BOUNCEMINE,BOUNCEMINE__STATIC,940},
    {"BROKEFIREHYDRENT",&BROKEFIREHYDRENT,BROKEFIREHYDRENT__STATIC,950},
    {"BOX",&BOX,BOX__STATIC,951},
    {"BULLETHOLE",&BULLETHOLE,BULLETHOLE__STATIC,952},
    {"BOTTLE1",&BOTTLE1,BOTTLE1__STATIC,954},
    {"BOTTLE2",&BOTTLE2,BOTTLE2__STATIC,955},
    {"BOTTLE3",&BOTTLE3,BOTTLE3__STATIC,956},
    {"BOTTLE4",&BOTTLE4,BOTTLE4__STATIC,957},
    {"FEMPIC5",&FEMPIC5,FEMPIC5__STATIC,963},
    {"FEMPIC6",&FEMPIC6,FEMPIC6__STATIC,964},
    {"FEMPIC7",&FEMPIC7,FEMPIC7__STATIC,965},
    {"HYDROPLANT",&HYDROPLANT,HYDROPLANT__STATIC,969},
    {"OCEANSPRITE1",&OCEANSPRITE1,OCEANSPRITE1__STATIC,971},
    {"OCEANSPRITE2",&OCEANSPRITE2,OCEANSPRITE2__STATIC,972},
    {"OCEANSPRITE3",&OCEANSPRITE3,OCEANSPRITE3__STATIC,973},
    {"OCEANSPRITE4",&OCEANSPRITE4,OCEANSPRITE4__STATIC,974},
    {"OCEANSPRITE5",&OCEANSPRITE5,OCEANSPRITE5__STATIC,975},
    {"GENERICPOLE",&GENERICPOLE,GENERICPOLE__STATIC,977},
    {"CONE",&CONE,CONE__STATIC,978},
    {"HANGLIGHT",&HANGLIGHT,HANGLIGHT__STATIC,979},
    {"HYDRENT",&HYDRENT,HYDRENT__STATIC,981},
    {"MASKWALL14",&MASKWALL14,MASKWALL14__STATIC,988},
    {"TIRE",&TIRE,TIRE__STATIC,990},
    {"PIPE5",&PIPE5,PIPE5__STATIC,994},
    {"PIPE6",&PIPE6,PIPE6__STATIC,995},
    {"PIPE4",&PIPE4,PIPE4__STATIC,996},
    {"PIPE4B",&PIPE4B,PIPE4B__STATIC,997},
    {"BROKEHYDROPLANT",&BROKEHYDROPLANT,BROKEHYDROPLANT__STATIC,1003},
    {"PIPE5B",&PIPE5B,PIPE5B__STATIC,1005},
    {"NEON3",&NEON3,NEON3__STATIC,1007},
    {"NEON4",&NEON4,NEON4__STATIC,1008},
    {"NEON5",&NEON5,NEON5__STATIC,1009},
    {"BOTTLE5",&BOTTLE5,BOTTLE5__STATIC,1012},
    {"BOTTLE6",&BOTTLE6,BOTTLE6__STATIC,1013},
    {"BOTTLE8",&BOTTLE8,BOTTLE8__STATIC,1014},
    {"SPOTLITE",&SPOTLITE,SPOTLITE__STATIC,1020},
    {"HANGOOZ",&HANGOOZ,HANGOOZ__STATIC,1022},
    {"MASKWALL15",&MASKWALL15,MASKWALL15__STATIC,1024},
    {"BOTTLE7",&BOTTLE7,BOTTLE7__STATIC,1025},
    {"HORSEONSIDE",&HORSEONSIDE,HORSEONSIDE__STATIC,1026},
    {"GLASSPIECES",&GLASSPIECES,GLASSPIECES__STATIC,1031},
    {"HORSELITE",&HORSELITE,HORSELITE__STATIC,1034},
    {"DONUTS",&DONUTS,DONUTS__STATIC,1045},
    {"NEON6",&NEON6,NEON6__STATIC,1046},
    {"MASKWALL6",&MASKWALL6,MASKWALL6__STATIC,1059},
    {"CLOCK",&CLOCK,CLOCK__STATIC,1060},
    {"RUBBERCAN",&RUBBERCAN,RUBBERCAN__STATIC,1062},
    {"BROKENCLOCK",&BROKENCLOCK,BROKENCLOCK__STATIC,1067},
    {"PLUG",&PLUG,PLUG__STATIC,1069},
    {"OOZFILTER",&OOZFILTER,OOZFILTER__STATIC,1079},
    {"FLOORPLASMA",&FLOORPLASMA,FLOORPLASMA__STATIC,1082},
    {"REACTOR",&REACTOR,REACTOR__STATIC,1088},
    {"REACTORSPARK",&REACTORSPARK,REACTORSPARK__STATIC,1092},
    {"REACTORBURNT",&REACTORBURNT,REACTORBURNT__STATIC,1096},
    {"DOORTILE15",&DOORTILE15,DOORTILE15__STATIC,1102},
    {"HANDSWITCH",&HANDSWITCH,HANDSWITCH__STATIC,1111},
    {"CIRCLEPANNEL",&CIRCLEPANNEL,CIRCLEPANNEL__STATIC,1113},
    {"CIRCLEPANNELBROKE",&CIRCLEPANNELBROKE,CIRCLEPANNELBROKE__STATIC,1114},
    {"PULLSWITCH",&PULLSWITCH,PULLSWITCH__STATIC,1122},
    {"MASKWALL8",&MASKWALL8,MASKWALL8__STATIC,1124},
    {"BIGHOLE",&BIGHOLE,BIGHOLE__STATIC,1141},
    {"ALIENSWITCH",&ALIENSWITCH,ALIENSWITCH__STATIC,1142},
    {"DOORTILE21",&DOORTILE21,DOORTILE21__STATIC,1144},
    {"HANDPRINTSWITCH",&HANDPRINTSWITCH,HANDPRINTSWITCH__STATIC,1155},
    {"BOTTLE10",&BOTTLE10,BOTTLE10__STATIC,1157},
    {"BOTTLE11",&BOTTLE11,BOTTLE11__STATIC,1158},
    {"BOTTLE12",&BOTTLE12,BOTTLE12__STATIC,1159},
    {"BOTTLE13",&BOTTLE13,BOTTLE13__STATIC,1160},
    {"BOTTLE14",&BOTTLE14,BOTTLE14__STATIC,1161},
    {"BOTTLE15",&BOTTLE15,BOTTLE15__STATIC,1162},
    {"BOTTLE16",&BOTTLE16,BOTTLE16__STATIC,1163},
    {"BOTTLE17",&BOTTLE17,BOTTLE17__STATIC,1164},
    {"BOTTLE18",&BOTTLE18,BOTTLE18__STATIC,1165},
    {"BOTTLE19",&BOTTLE19,BOTTLE19__STATIC,1166},
    {"DOORTILE17",&DOORTILE17,DOORTILE17__STATIC,1169},
    {"MASKWALL7",&MASKWALL7,MASKWALL7__STATIC,1174},
    {"JAILBARBREAK",&JAILBARBREAK,JAILBARBREAK__STATIC,1175},
    {"DOORTILE11",&DOORTILE11,DOORTILE11__STATIC,1178},
    {"DOORTILE12",&DOORTILE12,DOORTILE12__STATIC,1179},
    {"VENDMACHINE",&VENDMACHINE,VENDMACHINE__STATIC,1212},
    {"VENDMACHINEBROKE",&VENDMACHINEBROKE,VENDMACHINEBROKE__STATIC,1214},
    {"COLAMACHINE",&COLAMACHINE,COLAMACHINE__STATIC,1215},
    {"COLAMACHINEBROKE",&COLAMACHINEBROKE,COLAMACHINEBROKE__STATIC,1217},
    {"CRANEPOLE",&CRANEPOLE,CRANEPOLE__STATIC,1221},
    {"CRANE",&CRANE,CRANE__STATIC,1222},
    {"BARBROKE",&BARBROKE,BARBROKE__STATIC,1225},
    {"BLOODPOOL",&BLOODPOOL,BLOODPOOL__STATIC,1226},
    {"NUKEBARREL",&NUKEBARREL,NUKEBARREL__STATIC,1227},
    {"NUKEBARRELDENTED",&NUKEBARRELDENTED,NUKEBARRELDENTED__STATIC,1228},
    {"NUKEBARRELLEAKED",&NUKEBARRELLEAKED,NUKEBARRELLEAKED__STATIC,1229},
    {"CANWITHSOMETHING",&CANWITHSOMETHING,CANWITHSOMETHING__STATIC,1232},
    {"MONEY",&MONEY,MONEY__STATIC,1233},
    {"BANNER",&BANNER,BANNER__STATIC,1236},
    {"EXPLODINGBARREL",&EXPLODINGBARREL,EXPLODINGBARREL__STATIC,1238},
    {"EXPLODINGBARREL2",&EXPLODINGBARREL2,EXPLODINGBARREL2__STATIC,1239},
    {"FIREBARREL",&FIREBARREL,FIREBARREL__STATIC,1240},
    {"SEENINE",&SEENINE,SEENINE__STATIC,1247},
    {"SEENINEDEAD",&SEENINEDEAD,SEENINEDEAD__STATIC,1248},
    {"STEAM",&STEAM,STEAM__STATIC,1250},
    {"CEILINGSTEAM",&CEILINGSTEAM,CEILINGSTEAM__STATIC,1255},
    {"PIPE6B",&PIPE6B,PIPE6B__STATIC,1260},
    {"TRANSPORTERBEAM",&TRANSPORTERBEAM,TRANSPORTERBEAM__STATIC,1261},
    {"RAT",&RAT,RAT__STATIC,1267},
    {"TRASH",&TRASH,TRASH__STATIC,1272},
    {"FEMPIC1",&FEMPIC1,FEMPIC1__STATIC,1280},
    {"FEMPIC2",&FEMPIC2,FEMPIC2__STATIC,1289},
    {"BLANKSCREEN",&BLANKSCREEN,BLANKSCREEN__STATIC,1293},
    {"PODFEM1",&PODFEM1,PODFEM1__STATIC,1294},
    {"FEMPIC3",&FEMPIC3,FEMPIC3__STATIC,1298},
    {"FEMPIC4",&FEMPIC4,FEMPIC4__STATIC,1306},
    {"FEM1",&FEM1,FEM1__STATIC,1312},
    {"FEM2",&FEM2,FEM2__STATIC,1317},
    {"FEM3",&FEM3,FEM3__STATIC,1321},
    {"FEM5",&FEM5,FEM5__STATIC,1323},
    {"BLOODYPOLE",&BLOODYPOLE,BLOODYPOLE__STATIC,1324},
    {"FEM4",&FEM4,FEM4__STATIC,1325},
    {"FEM6",&FEM6,FEM6__STATIC,1334},
    {"FEM6PAD",&FEM6PAD,FEM6PAD__STATIC,1335},
    {"FEM8",&FEM8,FEM8__STATIC,1336},
    {"HELECOPT",&HELECOPT,HELECOPT__STATIC,1346},
    {"FETUSJIB",&FETUSJIB,FETUSJIB__STATIC,1347},
    {"HOLODUKE",&HOLODUKE,HOLODUKE__STATIC,1348},
    {"SPACEMARINE",&SPACEMARINE,SPACEMARINE__STATIC,1353},
    {"INDY",&INDY,INDY__STATIC,1355},
    {"FETUS",&FETUS,FETUS__STATIC,1358},
    {"FETUSBROKE",&FETUSBROKE,FETUSBROKE__STATIC,1359},
    {"MONK",&MONK,MONK__STATIC,1352},
    {"LUKE",&LUKE,LUKE__STATIC,1354},
    {"COOLEXPLOSION1",&COOLEXPLOSION1,COOLEXPLOSION1__STATIC,1360},
    {"WATERSPLASH2",&WATERSPLASH2,WATERSPLASH2__STATIC,1380},
    {"FIREVASE",&FIREVASE,FIREVASE__STATIC,1390},
    {"SCRATCH",&SCRATCH,SCRATCH__STATIC,1393},
    {"FEM7",&FEM7,FEM7__STATIC,1395},
    {"APLAYERTOP",&APLAYERTOP,APLAYERTOP__STATIC,1400},
    {"APLAYER",&APLAYER,APLAYER__STATIC,1405},
    {"PLAYERONWATER",&PLAYERONWATER,PLAYERONWATER__STATIC,1420},
    {"DUKELYINGDEAD",&DUKELYINGDEAD,DUKELYINGDEAD__STATIC,1518},
    {"DUKETORSO",&DUKETORSO,DUKETORSO__STATIC,1520},
    {"DUKEGUN",&DUKEGUN,DUKEGUN__STATIC,1528},
    {"DUKELEG",&DUKELEG,DUKELEG__STATIC,1536},
    {"SHARK",&SHARK,SHARK__STATIC,1550},
    {"BLOOD",&BLOOD,BLOOD__STATIC,1620},
    {"FIRELASER",&FIRELASER,FIRELASER__STATIC,1625},
    {"TRANSPORTERSTAR",&TRANSPORTERSTAR,TRANSPORTERSTAR__STATIC,1630},
    {"SPIT",&SPIT,SPIT__STATIC,1636},
    {"LOOGIE",&LOOGIE,LOOGIE__STATIC,1637},
    {"FIST",&FIST,FIST__STATIC,1640},
    {"FREEZEBLAST",&FREEZEBLAST,FREEZEBLAST__STATIC,1641},
    {"DEVISTATORBLAST",&DEVISTATORBLAST,DEVISTATORBLAST__STATIC,1642},
    {"SHRINKSPARK",&SHRINKSPARK,SHRINKSPARK__STATIC,1646},
    {"TONGUE",&TONGUE,TONGUE__STATIC,1647},
    {"MORTER",&MORTER,MORTER__STATIC,1650},
    {"SHRINKEREXPLOSION",&SHRINKEREXPLOSION,SHRINKEREXPLOSION__STATIC,1656},
    {"RADIUSEXPLOSION",&RADIUSEXPLOSION,RADIUSEXPLOSION__STATIC,1670},
    {"FORCERIPPLE",&FORCERIPPLE,FORCERIPPLE__STATIC,1671},
    {"LIZTROOP",&LIZTROOP,LIZTROOP__STATIC,1680},
    {"LIZTROOPRUNNING",&LIZTROOPRUNNING,LIZTROOPRUNNING__STATIC,1681},
    {"LIZTROOPSTAYPUT",&LIZTROOPSTAYPUT,LIZTROOPSTAYPUT__STATIC,1682},
    {"LIZTOP",&LIZTOP,LIZTOP__STATIC,1705},
    {"LIZTROOPSHOOT",&LIZTROOPSHOOT,LIZTROOPSHOOT__STATIC,1715},
    {"LIZTROOPJETPACK",&LIZTROOPJETPACK,LIZTROOPJETPACK__STATIC,1725},
    {"LIZTROOPDSPRITE",&LIZTROOPDSPRITE,LIZTROOPDSPRITE__STATIC,1734},
    {"LIZTROOPONTOILET",&LIZTROOPONTOILET,LIZTROOPONTOILET__STATIC,1741},
    {"LIZTROOPJUSTSIT",&LIZTROOPJUSTSIT,LIZTROOPJUSTSIT__STATIC,1742},
    {"LIZTROOPDUCKING",&LIZTROOPDUCKING,LIZTROOPDUCKING__STATIC,1744},
    {"HEADJIB1",&HEADJIB1,HEADJIB1__STATIC,1768},
    {"ARMJIB1",&ARMJIB1,ARMJIB1__STATIC,1772},
    {"LEGJIB1",&LEGJIB1,LEGJIB1__STATIC,1776},
    {"CANNONBALL",&CANNONBALL,CANNONBALL__STATIC,1817},
    {"OCTABRAIN",&OCTABRAIN,OCTABRAIN__STATIC,1820},
    {"OCTABRAINSTAYPUT",&OCTABRAINSTAYPUT,OCTABRAINSTAYPUT__STATIC,1821},
    {"OCTATOP",&OCTATOP,OCTATOP__STATIC,1845},
    {"OCTADEADSPRITE",&OCTADEADSPRITE,OCTADEADSPRITE__STATIC,1855},
    {"INNERJAW",&INNERJAW,INNERJAW__STATIC,1860},
    {"DRONE",&DRONE,DRONE__STATIC,1880},
    {"EXPLOSION2",&EXPLOSION2,EXPLOSION2__STATIC,1890},
    {"COMMANDER",&COMMANDER,COMMANDER__STATIC,1920},
    {"COMMANDERSTAYPUT",&COMMANDERSTAYPUT,COMMANDERSTAYPUT__STATIC,1921},
    {"RECON",&RECON,RECON__STATIC,1960},
    {"TANK",&TANK,TANK__STATIC,1975},
    {"PIGCOP",&PIGCOP,PIGCOP__STATIC,2000},
    {"PIGCOPSTAYPUT",&PIGCOPSTAYPUT,PIGCOPSTAYPUT__STATIC,2001},
    {"PIGCOPDIVE",&PIGCOPDIVE,PIGCOPDIVE__STATIC,2045},
    {"PIGCOPDEADSPRITE",&PIGCOPDEADSPRITE,PIGCOPDEADSPRITE__STATIC,2060},
    {"PIGTOP",&PIGTOP,PIGTOP__STATIC,2061},
    {"LIZMAN",&LIZMAN,LIZMAN__STATIC,2120},
    {"LIZMANSTAYPUT",&LIZMANSTAYPUT,LIZMANSTAYPUT__STATIC,2121},
    {"LIZMANSPITTING",&LIZMANSPITTING,LIZMANSPITTING__STATIC,2150},
    {"LIZMANFEEDING",&LIZMANFEEDING,LIZMANFEEDING__STATIC,2160},
    {"LIZMANJUMP",&LIZMANJUMP,LIZMANJUMP__STATIC,2165},
    {"LIZMANDEADSPRITE",&LIZMANDEADSPRITE,LIZMANDEADSPRITE__STATIC,2185},
    {"FECES",&FECES,FECES__STATIC,2200},
    {"LIZMANHEAD1",&LIZMANHEAD1,LIZMANHEAD1__STATIC,2201},
    {"LIZMANARM1",&LIZMANARM1,LIZMANARM1__STATIC,2205},
    {"LIZMANLEG1",&LIZMANLEG1,LIZMANLEG1__STATIC,2209},
    {"EXPLOSION2BOT",&EXPLOSION2BOT,EXPLOSION2BOT__STATIC,2219},
    {"USERWEAPON",&USERWEAPON,USERWEAPON__STATIC,2235},
    {"HEADERBAR",&HEADERBAR,HEADERBAR__STATIC,2242},
    {"JIBS1",&JIBS1,JIBS1__STATIC,2245},
    {"JIBS2",&JIBS2,JIBS2__STATIC,2250},
    {"JIBS3",&JIBS3,JIBS3__STATIC,2255},
    {"JIBS4",&JIBS4,JIBS4__STATIC,2260},
    {"JIBS5",&JIBS5,JIBS5__STATIC,2265},
    {"BURNING",&BURNING,BURNING__STATIC,2270},
    {"FIRE",&FIRE,FIRE__STATIC,2271},
    {"JIBS6",&JIBS6,JIBS6__STATIC,2286},
    {"BLOODSPLAT1",&BLOODSPLAT1,BLOODSPLAT1__STATIC,2296},
    {"BLOODSPLAT3",&BLOODSPLAT3,BLOODSPLAT3__STATIC,2297},
    {"BLOODSPLAT2",&BLOODSPLAT2,BLOODSPLAT2__STATIC,2298},
    {"BLOODSPLAT4",&BLOODSPLAT4,BLOODSPLAT4__STATIC,2299},
    {"OOZ",&OOZ,OOZ__STATIC,2300},
    {"OOZ2",&OOZ2,OOZ2__STATIC,2309},
    {"WALLBLOOD1",&WALLBLOOD1,WALLBLOOD1__STATIC,2301},
    {"WALLBLOOD2",&WALLBLOOD2,WALLBLOOD2__STATIC,2302},
    {"WALLBLOOD3",&WALLBLOOD3,WALLBLOOD3__STATIC,2303},
    {"WALLBLOOD4",&WALLBLOOD4,WALLBLOOD4__STATIC,2304},
    {"WALLBLOOD5",&WALLBLOOD5,WALLBLOOD5__STATIC,2305},
    {"WALLBLOOD6",&WALLBLOOD6,WALLBLOOD6__STATIC,2306},
    {"WALLBLOOD7",&WALLBLOOD7,WALLBLOOD7__STATIC,2307},
    {"WALLBLOOD8",&WALLBLOOD8,WALLBLOOD8__STATIC,2308},
    {"BURNING2",&BURNING2,BURNING2__STATIC,2310},
    {"FIRE2",&FIRE2,FIRE2__STATIC,2311},
    {"CRACKKNUCKLES",&CRACKKNUCKLES,CRACKKNUCKLES__STATIC,2324},
    {"SMALLSMOKE",&SMALLSMOKE,SMALLSMOKE__STATIC,2329},
    {"SMALLSMOKEMAKER",&SMALLSMOKEMAKER,SMALLSMOKEMAKER__STATIC,2330},
    {"FLOORFLAME",&FLOORFLAME,FLOORFLAME__STATIC,2333},
    {"ROTATEGUN",&ROTATEGUN,ROTATEGUN__STATIC,2360},
    {"GREENSLIME",&GREENSLIME,GREENSLIME__STATIC,2370},
    {"WATERDRIPSPLASH",&WATERDRIPSPLASH,WATERDRIPSPLASH__STATIC,2380},
    {"SCRAP6",&SCRAP6,SCRAP6__STATIC,2390},
    {"SCRAP1",&SCRAP1,SCRAP1__STATIC,2400},
    {"SCRAP2",&SCRAP2,SCRAP2__STATIC,2404},
    {"SCRAP3",&SCRAP3,SCRAP3__STATIC,2408},
    {"SCRAP4",&SCRAP4,SCRAP4__STATIC,2412},
    {"SCRAP5",&SCRAP5,SCRAP5__STATIC,2416},
    {"ORGANTIC",&ORGANTIC,ORGANTIC__STATIC,2420},
    {"BETAVERSION",&BETAVERSION,BETAVERSION__STATIC,2440},
    {"PLAYERISHERE",&PLAYERISHERE,PLAYERISHERE__STATIC,2442},
    {"PLAYERWASHERE",&PLAYERWASHERE,PLAYERWASHERE__STATIC,2443},
    {"SELECTDIR",&SELECTDIR,SELECTDIR__STATIC,2444},
    {"F1HELP",&F1HELP,F1HELP__STATIC,2445},
    {"NOTCHON",&NOTCHON,NOTCHON__STATIC,2446},
    {"NOTCHOFF",&NOTCHOFF,NOTCHOFF__STATIC,2447},
    {"GROWSPARK",&GROWSPARK,GROWSPARK__STATIC,2448},
    {"DUKEICON",&DUKEICON,DUKEICON__STATIC,2452},
    {"BADGUYICON",&BADGUYICON,BADGUYICON__STATIC,2453},
    {"FOODICON",&FOODICON,FOODICON__STATIC,2454},
    {"GETICON",&GETICON,GETICON__STATIC,2455},
    {"MENUSCREEN",&MENUSCREEN,MENUSCREEN__STATIC,2456},
    {"MENUBAR",&MENUBAR,MENUBAR__STATIC,2457},
    {"KILLSICON",&KILLSICON,KILLSICON__STATIC,2458},
    {"FIRSTAID_ICON",&FIRSTAID_ICON,FIRSTAID_ICON__STATIC,2460},
    {"HEAT_ICON",&HEAT_ICON,HEAT_ICON__STATIC,2461},
    {"BOTTOMSTATUSBAR",&BOTTOMSTATUSBAR,BOTTOMSTATUSBAR__STATIC,2462},
    {"BOOT_ICON",&BOOT_ICON,BOOT_ICON__STATIC,2463},
    {"FRAGBAR",&FRAGBAR,FRAGBAR__STATIC,2465},
    {"JETPACK_ICON",&JETPACK_ICON,JETPACK_ICON__STATIC,2467},
    {"AIRTANK_ICON",&AIRTANK_ICON,AIRTANK_ICON__STATIC,2468},
    {"STEROIDS_ICON",&STEROIDS_ICON,STEROIDS_ICON__STATIC,2469},
    {"HOLODUKE_ICON",&HOLODUKE_ICON,HOLODUKE_ICON__STATIC,2470},
    {"ACCESS_ICON",&ACCESS_ICON,ACCESS_ICON__STATIC,2471},
    {"DIGITALNUM",&DIGITALNUM,DIGITALNUM__STATIC,2472},
    {"DUKECAR",&DUKECAR,DUKECAR__STATIC,2491},
    {"CAMCORNER",&CAMCORNER,CAMCORNER__STATIC,2482},
    {"CAMLIGHT",&CAMLIGHT,CAMLIGHT__STATIC,2484},
    {"LOGO",&LOGO,LOGO__STATIC,2485},
    {"TITLE",&TITLE,TITLE__STATIC,2486},
    {"NUKEWARNINGICON",&NUKEWARNINGICON,NUKEWARNINGICON__STATIC,2487},
    {"MOUSECURSOR",&MOUSECURSOR,MOUSECURSOR__STATIC,2488},
    {"SLIDEBAR",&SLIDEBAR,SLIDEBAR__STATIC,2489},
    {"DREALMS",&DREALMS,DREALMS__STATIC,2492},
    {"BETASCREEN",&BETASCREEN,BETASCREEN__STATIC,2493},
    {"WINDOWBORDER1",&WINDOWBORDER1,WINDOWBORDER1__STATIC,2494},
    {"TEXTBOX",&TEXTBOX,TEXTBOX__STATIC,2495},
    {"WINDOWBORDER2",&WINDOWBORDER2,WINDOWBORDER2__STATIC,2496},
    {"DUKENUKEM",&DUKENUKEM,DUKENUKEM__STATIC,2497},
    {"THREEDEE",&THREEDEE,THREEDEE__STATIC,2498},
    {"INGAMEDUKETHREEDEE",&INGAMEDUKETHREEDEE,INGAMEDUKETHREEDEE__STATIC,2499},
    {"TENSCREEN",&TENSCREEN,TENSCREEN__STATIC,2500},
    {"PLUTOPAKSPRITE",&PLUTOPAKSPRITE,PLUTOPAKSPRITE__STATIC,2501},
    {"DEVISTATOR",&DEVISTATOR,DEVISTATOR__STATIC,2510},
    {"KNEE",&KNEE,KNEE__STATIC,2521},
    {"CROSSHAIR",&CROSSHAIR,CROSSHAIR__STATIC,2523},
    {"FIRSTGUN",&FIRSTGUN,FIRSTGUN__STATIC,2524},
    {"FIRSTGUNRELOAD",&FIRSTGUNRELOAD,FIRSTGUNRELOAD__STATIC,2528},
    {"FALLINGCLIP",&FALLINGCLIP,FALLINGCLIP__STATIC,2530},
    {"CLIPINHAND",&CLIPINHAND,CLIPINHAND__STATIC,2531},
    {"HAND",&HAND,HAND__STATIC,2532},
    {"SHELL",&SHELL,SHELL__STATIC,2533},
    {"SHOTGUNSHELL",&SHOTGUNSHELL,SHOTGUNSHELL__STATIC,2535},
    {"CHAINGUN",&CHAINGUN,CHAINGUN__STATIC,2536},
    {"RPGGUN",&RPGGUN,RPGGUN__STATIC,2544},
    {"RPGMUZZLEFLASH",&RPGMUZZLEFLASH,RPGMUZZLEFLASH__STATIC,2545},
    {"FREEZE",&FREEZE,FREEZE__STATIC,2548},
    {"CATLITE",&CATLITE,CATLITE__STATIC,2552},
    {"SHRINKER",&SHRINKER,SHRINKER__STATIC,2556},
    {"HANDHOLDINGLASER",&HANDHOLDINGLASER,HANDHOLDINGLASER__STATIC,2563},
    {"TRIPBOMB",&TRIPBOMB,TRIPBOMB__STATIC,2566},
    {"LASERLINE",&LASERLINE,LASERLINE__STATIC,2567},
    {"HANDHOLDINGACCESS",&HANDHOLDINGACCESS,HANDHOLDINGACCESS__STATIC,2568},
    {"HANDREMOTE",&HANDREMOTE,HANDREMOTE__STATIC,2570},
    {"HANDTHROW",&HANDTHROW,HANDTHROW__STATIC,2573},
    {"TIP",&TIP,TIP__STATIC,2576},
    {"GLAIR",&GLAIR,GLAIR__STATIC,2578},
    {"SCUBAMASK",&SCUBAMASK,SCUBAMASK__STATIC,2581},
    {"SPACEMASK",&SPACEMASK,SPACEMASK__STATIC,2584},
    {"FORCESPHERE",&FORCESPHERE,FORCESPHERE__STATIC,2590},
    {"SHOTSPARK1",&SHOTSPARK1,SHOTSPARK1__STATIC,2595},
    {"RPG",&RPG,RPG__STATIC,2605},
    {"LASERSITE",&LASERSITE,LASERSITE__STATIC,2612},
    {"SHOTGUN",&SHOTGUN,SHOTGUN__STATIC,2613},
    {"BOSS1",&BOSS1,BOSS1__STATIC,2630},
    {"BOSS1STAYPUT",&BOSS1STAYPUT,BOSS1STAYPUT__STATIC,2631},
    {"BOSS1SHOOT",&BOSS1SHOOT,BOSS1SHOOT__STATIC,2660},
    {"BOSS1LOB",&BOSS1LOB,BOSS1LOB__STATIC,2670},
    {"BOSSTOP",&BOSSTOP,BOSSTOP__STATIC,2696},
    {"BOSS2",&BOSS2,BOSS2__STATIC,2710},
    {"BOSS3",&BOSS3,BOSS3__STATIC,2760},
    {"SPINNINGNUKEICON",&SPINNINGNUKEICON,SPINNINGNUKEICON__STATIC,2813},
    {"BIGFNTCURSOR",&BIGFNTCURSOR,BIGFNTCURSOR__STATIC,2820},
    {"SMALLFNTCURSOR",&SMALLFNTCURSOR,SMALLFNTCURSOR__STATIC,2821},
    {"STARTALPHANUM",&STARTALPHANUM,STARTALPHANUM__STATIC,2822},
    {"ENDALPHANUM",&ENDALPHANUM,ENDALPHANUM__STATIC,2915},
    {"BIGALPHANUM",&BIGALPHANUM,BIGALPHANUM__STATIC,2940},
    {"BIGPERIOD",&BIGPERIOD,BIGPERIOD__STATIC,3002},
    {"BIGCOMMA",&BIGCOMMA,BIGCOMMA__STATIC,3003},
    {"BIGX",&BIGX,BIGX__STATIC,3004},
    {"BIGQ",&BIGQ,BIGQ__STATIC,3005},
    {"BIGSEMI",&BIGSEMI,BIGSEMI__STATIC,3006},
    {"BIGCOLIN",&BIGCOLIN,BIGCOLIN__STATIC,3007},
    {"THREEBYFIVE",&THREEBYFIVE,THREEBYFIVE__STATIC,3010},
    {"BIGAPPOS",&BIGAPPOS,BIGAPPOS__STATIC,3022},
    {"BLANK",&BLANK,BLANK__STATIC,3026},
    {"MINIFONT",&MINIFONT,MINIFONT__STATIC,3072},
    {"BUTTON1",&BUTTON1,BUTTON1__STATIC,3164},
    {"GLASS3",&GLASS3,GLASS3__STATIC,3187},
    {"RESPAWNMARKERRED",&RESPAWNMARKERRED,RESPAWNMARKERRED__STATIC,3190},
    {"RESPAWNMARKERYELLOW",&RESPAWNMARKERYELLOW,RESPAWNMARKERYELLOW__STATIC,3200},
    {"RESPAWNMARKERGREEN",&RESPAWNMARKERGREEN,RESPAWNMARKERGREEN__STATIC,3210},
    {"BONUSSCREEN",&BONUSSCREEN,BONUSSCREEN__STATIC,3240},
    {"VIEWBORDER",&VIEWBORDER,VIEWBORDER__STATIC,3250},
    {"VICTORY1",&VICTORY1,VICTORY1__STATIC,3260},
    {"ORDERING",&ORDERING,ORDERING__STATIC,3270},
    {"TEXTSTORY",&TEXTSTORY,TEXTSTORY__STATIC,3280},
    {"LOADSCREEN",&LOADSCREEN,LOADSCREEN__STATIC,3281},
    {"BORNTOBEWILDSCREEN",&BORNTOBEWILDSCREEN,BORNTOBEWILDSCREEN__STATIC,3370},
    {"BLIMP",&BLIMP,BLIMP__STATIC,3400},
    {"FEM9",&FEM9,FEM9__STATIC,3450},
    {"FOOTPRINT",&FOOTPRINT,FOOTPRINT__STATIC,3701},
    {"FRAMEEFFECT1_13",&FRAMEEFFECT1_13,FRAMEEFFECT1_13__STATIC,3999},
    {"POOP",&POOP,POOP__STATIC,4094},
    {"FRAMEEFFECT1",&FRAMEEFFECT1,FRAMEEFFECT1__STATIC,4095},
    {"PANNEL3",&PANNEL3,PANNEL3__STATIC,4099},
    {"SCREENBREAK14",&SCREENBREAK14,SCREENBREAK14__STATIC,4120},
    {"SCREENBREAK15",&SCREENBREAK15,SCREENBREAK15__STATIC,4123},
    {"SCREENBREAK19",&SCREENBREAK19,SCREENBREAK19__STATIC,4125},
    {"SCREENBREAK16",&SCREENBREAK16,SCREENBREAK16__STATIC,4127},
    {"SCREENBREAK17",&SCREENBREAK17,SCREENBREAK17__STATIC,4128},
    {"SCREENBREAK18",&SCREENBREAK18,SCREENBREAK18__STATIC,4129},
    {"W_TECHWALL11",&W_TECHWALL11,W_TECHWALL11__STATIC,4130},
    {"W_TECHWALL12",&W_TECHWALL12,W_TECHWALL12__STATIC,4131},
    {"W_TECHWALL13",&W_TECHWALL13,W_TECHWALL13__STATIC,4132},
    {"W_TECHWALL14",&W_TECHWALL14,W_TECHWALL14__STATIC,4133},
    {"W_TECHWALL5",&W_TECHWALL5,W_TECHWALL5__STATIC,4134},
    {"W_TECHWALL6",&W_TECHWALL6,W_TECHWALL6__STATIC,4136},
    {"W_TECHWALL7",&W_TECHWALL7,W_TECHWALL7__STATIC,4138},
    {"W_TECHWALL8",&W_TECHWALL8,W_TECHWALL8__STATIC,4140},
    {"W_TECHWALL9",&W_TECHWALL9,W_TECHWALL9__STATIC,4142},
    {"BPANNEL3",&BPANNEL3,BPANNEL3__STATIC,4100},
    {"W_HITTECHWALL16",&W_HITTECHWALL16,W_HITTECHWALL16__STATIC,4144},
    {"W_HITTECHWALL10",&W_HITTECHWALL10,W_HITTECHWALL10__STATIC,4145},
    {"W_HITTECHWALL15",&W_HITTECHWALL15,W_HITTECHWALL15__STATIC,4147},
    {"W_MILKSHELF",&W_MILKSHELF,W_MILKSHELF__STATIC,4181},
    {"W_MILKSHELFBROKE",&W_MILKSHELFBROKE,W_MILKSHELFBROKE__STATIC,4203},
    {"PURPLELAVA",&PURPLELAVA,PURPLELAVA__STATIC,4240},
    {"LAVABUBBLE",&LAVABUBBLE,LAVABUBBLE__STATIC,4340},
    {"DUKECUTOUT",&DUKECUTOUT,DUKECUTOUT__STATIC,4352},
    {"TARGET",&TARGET,TARGET__STATIC,4359},
    {"GUNPOWDERBARREL",&GUNPOWDERBARREL,GUNPOWDERBARREL__STATIC,4360},
    {"DUCK",&DUCK,DUCK__STATIC,4361},
    {"HATRACK",&HATRACK,HATRACK__STATIC,4367},
    {"DESKLAMP",&DESKLAMP,DESKLAMP__STATIC,4370},
    {"COFFEEMACHINE",&COFFEEMACHINE,COFFEEMACHINE__STATIC,4372},
    {"CUPS",&CUPS,CUPS__STATIC,4373},
    {"GAVALS",&GAVALS,GAVALS__STATIC,4374},
    {"GAVALS2",&GAVALS2,GAVALS2__STATIC,4375},
    {"POLICELIGHTPOLE",&POLICELIGHTPOLE,POLICELIGHTPOLE__STATIC,4377},
    {"FLOORBASKET",&FLOORBASKET,FLOORBASKET__STATIC,4388},
    {"PUKE",&PUKE,PUKE__STATIC,4389},
    {"DOORTILE23",&DOORTILE23,DOORTILE23__STATIC,4391},
    {"TOPSECRET",&TOPSECRET,TOPSECRET__STATIC,4396},
    {"SPEAKER",&SPEAKER,SPEAKER__STATIC,4397},
    {"TEDDYBEAR",&TEDDYBEAR,TEDDYBEAR__STATIC,4400},
    {"ROBOTDOG",&ROBOTDOG,ROBOTDOG__STATIC,4402},
    {"ROBOTPIRATE",&ROBOTPIRATE,ROBOTPIRATE__STATIC,4404},
    {"ROBOTMOUSE",&ROBOTMOUSE,ROBOTMOUSE__STATIC,4407},
    {"MAIL",&MAIL,MAIL__STATIC,4410},
    {"MAILBAG",&MAILBAG,MAILBAG__STATIC,4413},
    {"HOTMEAT",&HOTMEAT,HOTMEAT__STATIC,4427},
    {"COFFEEMUG",&COFFEEMUG,COFFEEMUG__STATIC,4438},
    {"DONUTS2",&DONUTS2,DONUTS2__STATIC,4440},
    {"TRIPODCAMERA",&TRIPODCAMERA,TRIPODCAMERA__STATIC,4444},
    {"METER",&METER,METER__STATIC,4453},
    {"DESKPHONE",&DESKPHONE,DESKPHONE__STATIC,4454},
    {"GUMBALLMACHINE",&GUMBALLMACHINE,GUMBALLMACHINE__STATIC,4458},
    {"GUMBALLMACHINEBROKE",&GUMBALLMACHINEBROKE,GUMBALLMACHINEBROKE__STATIC,4459},
    {"PAPER",&PAPER,PAPER__STATIC,4460},
    {"MACE",&MACE,MACE__STATIC,4464},
    {"GENERICPOLE2",&GENERICPOLE2,GENERICPOLE2__STATIC,4465},
    {"XXXSTACY",&XXXSTACY,XXXSTACY__STATIC,4470},
    {"WETFLOOR",&WETFLOOR,WETFLOOR__STATIC,4495},
    {"BROOM",&BROOM,BROOM__STATIC,4496},
    {"MOP",&MOP,MOP__STATIC,4497},
    {"LETTER",&LETTER,LETTER__STATIC,4502},
    {"PIRATE1A",&PIRATE1A,PIRATE1A__STATIC,4510},
    {"PIRATE4A",&PIRATE4A,PIRATE4A__STATIC,4511},
    {"PIRATE2A",&PIRATE2A,PIRATE2A__STATIC,4512},
    {"PIRATE5A",&PIRATE5A,PIRATE5A__STATIC,4513},
    {"PIRATE3A",&PIRATE3A,PIRATE3A__STATIC,4514},
    {"PIRATE6A",&PIRATE6A,PIRATE6A__STATIC,4515},
    {"PIRATEHALF",&PIRATEHALF,PIRATEHALF__STATIC,4516},
    {"CHESTOFGOLD",&CHESTOFGOLD,CHESTOFGOLD__STATIC,4520},
    {"SIDEBOLT1",&SIDEBOLT1,SIDEBOLT1__STATIC,4525},
    {"FOODOBJECT1",&FOODOBJECT1,FOODOBJECT1__STATIC,4530},
    {"FOODOBJECT2",&FOODOBJECT2,FOODOBJECT2__STATIC,4531},
    {"FOODOBJECT3",&FOODOBJECT3,FOODOBJECT3__STATIC,4532},
    {"FOODOBJECT4",&FOODOBJECT4,FOODOBJECT4__STATIC,4533},
    {"FOODOBJECT5",&FOODOBJECT5,FOODOBJECT5__STATIC,4534},
    {"FOODOBJECT6",&FOODOBJECT6,FOODOBJECT6__STATIC,4535},
    {"FOODOBJECT7",&FOODOBJECT7,FOODOBJECT7__STATIC,4536},
    {"FOODOBJECT8",&FOODOBJECT8,FOODOBJECT8__STATIC,4537},
    {"FOODOBJECT9",&FOODOBJECT9,FOODOBJECT9__STATIC,4538},
    {"FOODOBJECT10",&FOODOBJECT10,FOODOBJECT10__STATIC,4539},
    {"FOODOBJECT11",&FOODOBJECT11,FOODOBJECT11__STATIC,4540},
    {"FOODOBJECT12",&FOODOBJECT12,FOODOBJECT12__STATIC,4541},
    {"FOODOBJECT13",&FOODOBJECT13,FOODOBJECT13__STATIC,4542},
    {"FOODOBJECT14",&FOODOBJECT14,FOODOBJECT14__STATIC,4543},
    {"FOODOBJECT15",&FOODOBJECT15,FOODOBJECT15__STATIC,4544},
    {"FOODOBJECT16",&FOODOBJECT16,FOODOBJECT16__STATIC,4545},
    {"FOODOBJECT17",&FOODOBJECT17,FOODOBJECT17__STATIC,4546},
    {"FOODOBJECT18",&FOODOBJECT18,FOODOBJECT18__STATIC,4547},
    {"FOODOBJECT19",&FOODOBJECT19,FOODOBJECT19__STATIC,4548},
    {"FOODOBJECT20",&FOODOBJECT20,FOODOBJECT20__STATIC,4549},
    {"HEADLAMP",&HEADLAMP,HEADLAMP__STATIC,4550},
    {"TAMPON",&TAMPON,TAMPON__STATIC,4557},
    {"SKINNEDCHICKEN",&SKINNEDCHICKEN,SKINNEDCHICKEN__STATIC,4554},
    {"FEATHEREDCHICKEN",&FEATHEREDCHICKEN,FEATHEREDCHICKEN__STATIC,4555},
    {"ROBOTDOG2",&ROBOTDOG2,ROBOTDOG2__STATIC,4560},
    {"JOLLYMEAL",&JOLLYMEAL,JOLLYMEAL__STATIC,4569},
    {"DUKEBURGER",&DUKEBURGER,DUKEBURGER__STATIC,4570},
    {"SHOPPINGCART",&SHOPPINGCART,SHOPPINGCART__STATIC,4576},
    {"CANWITHSOMETHING2",&CANWITHSOMETHING2,CANWITHSOMETHING2__STATIC,4580},
    {"CANWITHSOMETHING3",&CANWITHSOMETHING3,CANWITHSOMETHING3__STATIC,4581},
    {"CANWITHSOMETHING4",&CANWITHSOMETHING4,CANWITHSOMETHING4__STATIC,4582},
    {"SNAKEP",&SNAKEP,SNAKEP__STATIC,4590},
    {"DOLPHIN1",&DOLPHIN1,DOLPHIN1__STATIC,4591},
    {"DOLPHIN2",&DOLPHIN2,DOLPHIN2__STATIC,4592},
    {"NEWBEAST",&NEWBEAST,NEWBEAST__STATIC,4610},
    {"NEWBEASTSTAYPUT",&NEWBEASTSTAYPUT,NEWBEASTSTAYPUT__STATIC,4611},
    {"NEWBEASTJUMP",&NEWBEASTJUMP,NEWBEASTJUMP__STATIC,4690},
    {"NEWBEASTHANG",&NEWBEASTHANG,NEWBEASTHANG__STATIC,4670},
    {"NEWBEASTHANGDEAD",&NEWBEASTHANGDEAD,NEWBEASTHANGDEAD__STATIC,4671},
    {"BOSS4",&BOSS4,BOSS4__STATIC,4740},
    {"BOSS4STAYPUT",&BOSS4STAYPUT,BOSS4STAYPUT__STATIC,4741},
    {"FEM10",&FEM10,FEM10__STATIC,4864},
    {"TOUGHGAL",&TOUGHGAL,TOUGHGAL__STATIC,4866},
    {"MAN",&MAN,MAN__STATIC,4871},
    {"MAN2",&MAN2,MAN2__STATIC,4872},
    {"WOMAN",&WOMAN,WOMAN__STATIC,4874},
    {"PLEASEWAIT",&PLEASEWAIT,PLEASEWAIT__STATIC,4887},
    {"NATURALLIGHTNING",&NATURALLIGHTNING,NATURALLIGHTNING__STATIC,4890},
    {"WEATHERWARN",&WEATHERWARN,WEATHERWARN__STATIC,4893},
    {"DUKETAG",&DUKETAG,DUKETAG__STATIC,4900},
    {"SIGN1",&SIGN1,SIGN1__STATIC,4909},
    {"SIGN2",&SIGN2,SIGN2__STATIC,4912},
    {"JURYGUY",&JURYGUY,JURYGUY__STATIC,4943},
    {"RESERVEDSLOT1",&RESERVEDSLOT1,RESERVEDSLOT1__STATIC,6132},
    {"RESERVEDSLOT2",&RESERVEDSLOT2,RESERVEDSLOT2__STATIC,6133},
    {"RESERVEDSLOT3",&RESERVEDSLOT3,RESERVEDSLOT3__STATIC,6134},
    {"RESERVEDSLOT4",&RESERVEDSLOT4,RESERVEDSLOT4__STATIC,6135},
    {"RESERVEDSLOT5",&RESERVEDSLOT5,RESERVEDSLOT5__STATIC,6136},
    {"RESERVEDSLOT6",&RESERVEDSLOT6,RESERVEDSLOT6__STATIC,6137},
    {"RESERVEDSLOT7",&RESERVEDSLOT7,RESERVEDSLOT7__STATIC,6138},
    {"RESERVEDSLOT8",&RESERVEDSLOT8,RESERVEDSLOT8__STATIC,6139},
    {"RESERVEDSLOT9",&RESERVEDSLOT9,RESERVEDSLOT9__STATIC,6140},
    {"RESERVEDSLOT10",&RESERVEDSLOT10,RESERVEDSLOT10__STATIC,6141},
    {"RESERVEDSLOT11",&RESERVEDSLOT11,RESERVEDSLOT11__STATIC,6142},
    {"RESERVEDSLOT12",&RESERVEDSLOT12,RESERVEDSLOT12__STATIC,6143},
    {0,NULL,0,0},
};

int SECTOREFFECTOR = 1;
int ACTIVATOR = 2;
int TOUCHPLATE = 3;
int ACTIVATORLOCKED = 4;
int MUSICANDSFX = 5;
int LOCATORS = 6;
int CYCLER = 7;
int MASTERSWITCH = 8;
int RESPAWN = 9;
int GPSPEED = 10;
int FOF = 13;
int ARROW = 20;
int FIRSTGUNSPRITE = 21;
int CHAINGUNSPRITE = 22;
int RPGSPRITE = 23;
int FREEZESPRITE = 24;
int SHRINKERSPRITE = 25;
int HEAVYHBOMB = 26;
int TRIPBOMBSPRITE = 27;
int SHOTGUNSPRITE = 28;
int DEVISTATORSPRITE = 29;
int HEALTHBOX = 30;
int AMMOBOX = 31;
int GROWSPRITEICON = 32;
int INVENTORYBOX = 33;
int FREEZEAMMO = 37;
int AMMO = 40;
int BATTERYAMMO = 41;
int DEVISTATORAMMO = 42;
int RPGAMMO = 44;
int GROWAMMO = 45;
int CRYSTALAMMO = 46;
int HBOMBAMMO = 47;
int AMMOLOTS = 48;
int SHOTGUNAMMO = 49;
int COLA = 51;
int SIXPAK = 52;
int FIRSTAID = 53;
int SHIELD = 54;
int STEROIDS = 55;
int AIRTANK = 56;
int JETPACK = 57;
int HEATSENSOR = 59;
int ACCESSCARD = 60;
int BOOTS = 61;
int MIRRORBROKE = 70;
int CLOUDYOCEAN = 78;
int CLOUDYSKIES = 79;
int MOONSKY1 = 80;
int MOONSKY2 = 81;
int MOONSKY3 = 82;
int MOONSKY4 = 83;
int BIGORBIT1 = 84;
int BIGORBIT2 = 85;
int BIGORBIT3 = 86;
int BIGORBIT4 = 87;
int BIGORBIT5 = 88;
int LA = 89;
int REDSKY1 = 98;
int REDSKY2 = 99;
int ATOMICHEALTH = 100;
int TECHLIGHT2 = 120;
int TECHLIGHTBUST2 = 121;
int TECHLIGHT4 = 122;
int TECHLIGHTBUST4 = 123;
int WALLLIGHT4 = 124;
int WALLLIGHTBUST4 = 125;
int ACCESSSWITCH = 130;
int SLOTDOOR = 132;
int LIGHTSWITCH = 134;
int SPACEDOORSWITCH = 136;
int SPACELIGHTSWITCH = 138;
int FRANKENSTINESWITCH = 140;
int NUKEBUTTON = 142;
int MULTISWITCH = 146;
int DOORTILE5 = 150;
int DOORTILE6 = 151;
int DOORTILE1 = 152;
int DOORTILE2 = 153;
int DOORTILE3 = 154;
int DOORTILE4 = 155;
int DOORTILE7 = 156;
int DOORTILE8 = 157;
int DOORTILE9 = 158;
int DOORTILE10 = 159;
int DOORSHOCK = 160;
int DIPSWITCH = 162;
int DIPSWITCH2 = 164;
int TECHSWITCH = 166;
int DIPSWITCH3 = 168;
int ACCESSSWITCH2 = 170;
int REFLECTWATERTILE = 180;
int FLOORSLIME = 200;
int BIGFORCE = 230;
int EPISODE = 247;
int MASKWALL9 = 255;
int W_LIGHT = 260;
int SCREENBREAK1 = 263;
int SCREENBREAK2 = 264;
int SCREENBREAK3 = 265;
int SCREENBREAK4 = 266;
int SCREENBREAK5 = 267;
int SCREENBREAK6 = 268;
int SCREENBREAK7 = 269;
int SCREENBREAK8 = 270;
int SCREENBREAK9 = 271;
int SCREENBREAK10 = 272;
int SCREENBREAK11 = 273;
int SCREENBREAK12 = 274;
int SCREENBREAK13 = 275;
int MASKWALL1 = 285;
int W_TECHWALL1 = 293;
int W_TECHWALL2 = 297;
int W_TECHWALL15 = 299;
int W_TECHWALL3 = 301;
int W_TECHWALL4 = 305;
int W_TECHWALL10 = 306;
int W_TECHWALL16 = 307;
int WATERTILE2 = 336;
int BPANNEL1 = 341;
int PANNEL1 = 342;
int PANNEL2 = 343;
int WATERTILE = 344;
int STATIC = 351;
int W_SCREENBREAK = 357;
int W_HITTECHWALL3 = 360;
int W_HITTECHWALL4 = 361;
int W_HITTECHWALL2 = 362;
int W_HITTECHWALL1 = 363;
int MASKWALL10 = 387;
int MASKWALL11 = 391;
int DOORTILE22 = 395;
int FANSPRITE = 407;
int FANSPRITEBROKE = 411;
int FANSHADOW = 412;
int FANSHADOWBROKE = 416;
int DOORTILE18 = 447;
int DOORTILE19 = 448;
int DOORTILE20 = 449;
int SATELLITE = 489;
int VIEWSCREEN2 = 499;
int VIEWSCREENBROKE = 501;
int VIEWSCREEN = 502;
int GLASS = 503;
int GLASS2 = 504;
int STAINGLASS1 = 510;
int MASKWALL5 = 514;
int SATELITE = 516;
int FUELPOD = 517;
int SLIMEPIPE = 538;
int CRACK1 = 546;
int CRACK2 = 547;
int CRACK3 = 548;
int CRACK4 = 549;
int FOOTPRINTS = 550;
int DOMELITE = 551;
int CAMERAPOLE = 554;
int CHAIR1 = 556;
int CHAIR2 = 557;
int BROKENCHAIR = 559;
int MIRROR = 560;
int WATERFOUNTAIN = 563;
int WATERFOUNTAINBROKE = 567;
int FEMMAG1 = 568;
int TOILET = 569;
int STALL = 571;
int STALLBROKE = 573;
int FEMMAG2 = 577;
int REACTOR2 = 578;
int REACTOR2BURNT = 579;
int REACTOR2SPARK = 580;
int GRATE1 = 595;
int BGRATE1 = 596;
int SOLARPANNEL = 602;
int NAKED1 = 603;
int ANTENNA = 607;
int MASKWALL12 = 609;
int TOILETBROKE = 615;
int PIPE2 = 616;
int PIPE1B = 617;
int PIPE3 = 618;
int PIPE1 = 619;
int CAMERA1 = 621;
int BRICK = 626;
int SPLINTERWOOD = 630;
int PIPE2B = 633;
int BOLT1 = 634;
int W_NUMBERS = 640;
int WATERDRIP = 660;
int WATERBUBBLE = 661;
int WATERBUBBLEMAKER = 662;
int W_FORCEFIELD = 663;
int VACUUM = 669;
int FOOTPRINTS2 = 672;
int FOOTPRINTS3 = 673;
int FOOTPRINTS4 = 674;
int EGG = 675;
int SCALE = 678;
int CHAIR3 = 680;
int CAMERALIGHT = 685;
int MOVIECAMERA = 686;
int IVUNIT = 689;
int POT1 = 694;
int POT2 = 695;
int POT3 = 697;
int PIPE3B = 700;
int WALLLIGHT3 = 701;
int WALLLIGHTBUST3 = 702;
int WALLLIGHT1 = 703;
int WALLLIGHTBUST1 = 704;
int WALLLIGHT2 = 705;
int WALLLIGHTBUST2 = 706;
int LIGHTSWITCH2 = 712;
int WAITTOBESEATED = 716;
int DOORTILE14 = 717;
int STATUE = 753;
int MIKE = 762;
int VASE = 765;
int SUSHIPLATE1 = 768;
int SUSHIPLATE2 = 769;
int SUSHIPLATE3 = 774;
int SUSHIPLATE4 = 779;
int DOORTILE16 = 781;
int SUSHIPLATE5 = 792;
int OJ = 806;
int MASKWALL13 = 830;
int HURTRAIL = 859;
int POWERSWITCH1 = 860;
int LOCKSWITCH1 = 862;
int POWERSWITCH2 = 864;
int ATM = 867;
int STATUEFLASH = 869;
int ATMBROKE = 888;
int BIGHOLE2 = 893;
int STRIPEBALL = 901;
int QUEBALL = 902;
int POCKET = 903;
int WOODENHORSE = 904;
int TREE1 = 908;
int TREE2 = 910;
int CACTUS = 911;
int MASKWALL2 = 913;
int MASKWALL3 = 914;
int MASKWALL4 = 915;
int FIREEXT = 916;
int TOILETWATER = 921;
int NEON1 = 925;
int NEON2 = 926;
int CACTUSBROKE = 939;
int BOUNCEMINE = 940;
int BROKEFIREHYDRENT = 950;
int BOX = 951;
int BULLETHOLE = 952;
int BOTTLE1 = 954;
int BOTTLE2 = 955;
int BOTTLE3 = 956;
int BOTTLE4 = 957;
int FEMPIC5 = 963;
int FEMPIC6 = 964;
int FEMPIC7 = 965;
int HYDROPLANT = 969;
int OCEANSPRITE1 = 971;
int OCEANSPRITE2 = 972;
int OCEANSPRITE3 = 973;
int OCEANSPRITE4 = 974;
int OCEANSPRITE5 = 975;
int GENERICPOLE = 977;
int CONE = 978;
int HANGLIGHT = 979;
int HYDRENT = 981;
int MASKWALL14 = 988;
int TIRE = 990;
int PIPE5 = 994;
int PIPE6 = 995;
int PIPE4 = 996;
int PIPE4B = 997;
int BROKEHYDROPLANT = 1003;
int PIPE5B = 1005;
int NEON3 = 1007;
int NEON4 = 1008;
int NEON5 = 1009;
int BOTTLE5 = 1012;
int BOTTLE6 = 1013;
int BOTTLE8 = 1014;
int SPOTLITE = 1020;
int HANGOOZ = 1022;
int MASKWALL15 = 1024;
int BOTTLE7 = 1025;
int HORSEONSIDE = 1026;
int GLASSPIECES = 1031;
int HORSELITE = 1034;
int DONUTS = 1045;
int NEON6 = 1046;
int MASKWALL6 = 1059;
int CLOCK = 1060;
int RUBBERCAN = 1062;
int BROKENCLOCK = 1067;
int PLUG = 1069;
int OOZFILTER = 1079;
int FLOORPLASMA = 1082;
int REACTOR = 1088;
int REACTORSPARK = 1092;
int REACTORBURNT = 1096;
int DOORTILE15 = 1102;
int HANDSWITCH = 1111;
int CIRCLEPANNEL = 1113;
int CIRCLEPANNELBROKE = 1114;
int PULLSWITCH = 1122;
int MASKWALL8 = 1124;
int BIGHOLE = 1141;
int ALIENSWITCH = 1142;
int DOORTILE21 = 1144;
int HANDPRINTSWITCH = 1155;
int BOTTLE10 = 1157;
int BOTTLE11 = 1158;
int BOTTLE12 = 1159;
int BOTTLE13 = 1160;
int BOTTLE14 = 1161;
int BOTTLE15 = 1162;
int BOTTLE16 = 1163;
int BOTTLE17 = 1164;
int BOTTLE18 = 1165;
int BOTTLE19 = 1166;
int DOORTILE17 = 1169;
int MASKWALL7 = 1174;
int JAILBARBREAK = 1175;
int DOORTILE11 = 1178;
int DOORTILE12 = 1179;
int VENDMACHINE = 1212;
int VENDMACHINEBROKE = 1214;
int COLAMACHINE = 1215;
int COLAMACHINEBROKE = 1217;
int CRANEPOLE = 1221;
int CRANE = 1222;
int BARBROKE = 1225;
int BLOODPOOL = 1226;
int NUKEBARREL = 1227;
int NUKEBARRELDENTED = 1228;
int NUKEBARRELLEAKED = 1229;
int CANWITHSOMETHING = 1232;
int MONEY = 1233;
int BANNER = 1236;
int EXPLODINGBARREL = 1238;
int EXPLODINGBARREL2 = 1239;
int FIREBARREL = 1240;
int SEENINE = 1247;
int SEENINEDEAD = 1248;
int STEAM = 1250;
int CEILINGSTEAM = 1255;
int PIPE6B = 1260;
int TRANSPORTERBEAM = 1261;
int RAT = 1267;
int TRASH = 1272;
int FEMPIC1 = 1280;
int FEMPIC2 = 1289;
int BLANKSCREEN = 1293;
int PODFEM1 = 1294;
int FEMPIC3 = 1298;
int FEMPIC4 = 1306;
int FEM1 = 1312;
int FEM2 = 1317;
int FEM3 = 1321;
int FEM5 = 1323;
int BLOODYPOLE = 1324;
int FEM4 = 1325;
int FEM6 = 1334;
int FEM6PAD = 1335;
int FEM8 = 1336;
int HELECOPT = 1346;
int FETUSJIB = 1347;
int HOLODUKE = 1348;
int SPACEMARINE = 1353;
int INDY = 1355;
int FETUS = 1358;
int FETUSBROKE = 1359;
int MONK = 1352;
int LUKE = 1354;
int COOLEXPLOSION1 = 1360;
int WATERSPLASH2 = 1380;
int FIREVASE = 1390;
int SCRATCH = 1393;
int FEM7 = 1395;
int APLAYERTOP = 1400;
int APLAYER = 1405;
int PLAYERONWATER = 1420;
int DUKELYINGDEAD = 1518;
int DUKETORSO = 1520;
int DUKEGUN = 1528;
int DUKELEG = 1536;
int SHARK = 1550;
int BLOOD = 1620;
int FIRELASER = 1625;
int TRANSPORTERSTAR = 1630;
int SPIT = 1636;
int LOOGIE = 1637;
int FIST = 1640;
int FREEZEBLAST = 1641;
int DEVISTATORBLAST = 1642;
int SHRINKSPARK = 1646;
int TONGUE = 1647;
int MORTER = 1650;
int SHRINKEREXPLOSION = 1656;
int RADIUSEXPLOSION = 1670;
int FORCERIPPLE = 1671;
int LIZTROOP = 1680;
int LIZTROOPRUNNING = 1681;
int LIZTROOPSTAYPUT = 1682;
int LIZTOP = 1705;
int LIZTROOPSHOOT = 1715;
int LIZTROOPJETPACK = 1725;
int LIZTROOPDSPRITE = 1734;
int LIZTROOPONTOILET = 1741;
int LIZTROOPJUSTSIT = 1742;
int LIZTROOPDUCKING = 1744;
int HEADJIB1 = 1768;
int ARMJIB1 = 1772;
int LEGJIB1 = 1776;
int CANNONBALL = 1817;
int OCTABRAIN = 1820;
int OCTABRAINSTAYPUT = 1821;
int OCTATOP = 1845;
int OCTADEADSPRITE = 1855;
int INNERJAW = 1860;
int DRONE = 1880;
int EXPLOSION2 = 1890;
int COMMANDER = 1920;
int COMMANDERSTAYPUT = 1921;
int RECON = 1960;
int TANK = 1975;
int PIGCOP = 2000;
int PIGCOPSTAYPUT = 2001;
int PIGCOPDIVE = 2045;
int PIGCOPDEADSPRITE = 2060;
int PIGTOP = 2061;
int LIZMAN = 2120;
int LIZMANSTAYPUT = 2121;
int LIZMANSPITTING = 2150;
int LIZMANFEEDING = 2160;
int LIZMANJUMP = 2165;
int LIZMANDEADSPRITE = 2185;
int FECES = 2200;
int LIZMANHEAD1 = 2201;
int LIZMANARM1 = 2205;
int LIZMANLEG1 = 2209;
int EXPLOSION2BOT = 2219;
int USERWEAPON = 2235;
int HEADERBAR = 2242;
int JIBS1 = 2245;
int JIBS2 = 2250;
int JIBS3 = 2255;
int JIBS4 = 2260;
int JIBS5 = 2265;
int BURNING = 2270;
int FIRE = 2271;
int JIBS6 = 2286;
int BLOODSPLAT1 = 2296;
int BLOODSPLAT3 = 2297;
int BLOODSPLAT2 = 2298;
int BLOODSPLAT4 = 2299;
int OOZ = 2300;
int OOZ2 = 2309;
int WALLBLOOD1 = 2301;
int WALLBLOOD2 = 2302;
int WALLBLOOD3 = 2303;
int WALLBLOOD4 = 2304;
int WALLBLOOD5 = 2305;
int WALLBLOOD6 = 2306;
int WALLBLOOD7 = 2307;
int WALLBLOOD8 = 2308;
int BURNING2 = 2310;
int FIRE2 = 2311;
int CRACKKNUCKLES = 2324;
int SMALLSMOKE = 2329;
int SMALLSMOKEMAKER = 2330;
int FLOORFLAME = 2333;
int ROTATEGUN = 2360;
int GREENSLIME = 2370;
int WATERDRIPSPLASH = 2380;
int SCRAP6 = 2390;
int SCRAP1 = 2400;
int SCRAP2 = 2404;
int SCRAP3 = 2408;
int SCRAP4 = 2412;
int SCRAP5 = 2416;
int ORGANTIC = 2420;
int BETAVERSION = 2440;
int PLAYERISHERE = 2442;
int PLAYERWASHERE = 2443;
int SELECTDIR = 2444;
int F1HELP = 2445;
int NOTCHON = 2446;
int NOTCHOFF = 2447;
int GROWSPARK = 2448;
int DUKEICON = 2452;
int BADGUYICON = 2453;
int FOODICON = 2454;
int GETICON = 2455;
int MENUSCREEN = 2456;
int MENUBAR = 2457;
int KILLSICON = 2458;
int FIRSTAID_ICON = 2460;
int HEAT_ICON = 2461;
int BOTTOMSTATUSBAR = 2462;
int BOOT_ICON = 2463;
int FRAGBAR = 2465;
int JETPACK_ICON = 2467;
int AIRTANK_ICON = 2468;
int STEROIDS_ICON = 2469;
int HOLODUKE_ICON = 2470;
int ACCESS_ICON = 2471;
int DIGITALNUM = 2472;
int DUKECAR = 2491;
int CAMCORNER = 2482;
int CAMLIGHT = 2484;
int LOGO = 2485;
int TITLE = 2486;
int NUKEWARNINGICON = 2487;
int MOUSECURSOR = 2488;
int SLIDEBAR = 2489;
int DREALMS = 2492;
int BETASCREEN = 2493;
int WINDOWBORDER1 = 2494;
int TEXTBOX = 2495;
int WINDOWBORDER2 = 2496;
int DUKENUKEM = 2497;
int THREEDEE = 2498;
int INGAMEDUKETHREEDEE = 2499;
int TENSCREEN = 2500;
int PLUTOPAKSPRITE = 2501;
int DEVISTATOR = 2510;
int KNEE = 2521;
int CROSSHAIR = 2523;
int FIRSTGUN = 2524;
int FIRSTGUNRELOAD = 2528;
int FALLINGCLIP = 2530;
int CLIPINHAND = 2531;
int HAND = 2532;
int SHELL = 2533;
int SHOTGUNSHELL = 2535;
int CHAINGUN = 2536;
int RPGGUN = 2544;
int RPGMUZZLEFLASH = 2545;
int FREEZE = 2548;
int CATLITE = 2552;
int SHRINKER = 2556;
int HANDHOLDINGLASER = 2563;
int TRIPBOMB = 2566;
int LASERLINE = 2567;
int HANDHOLDINGACCESS = 2568;
int HANDREMOTE = 2570;
int HANDTHROW = 2573;
int TIP = 2576;
int GLAIR = 2578;
int SCUBAMASK = 2581;
int SPACEMASK = 2584;
int FORCESPHERE = 2590;
int SHOTSPARK1 = 2595;
int RPG = 2605;
int LASERSITE = 2612;
int SHOTGUN = 2613;
int BOSS1 = 2630;
int BOSS1STAYPUT = 2631;
int BOSS1SHOOT = 2660;
int BOSS1LOB = 2670;
int BOSSTOP = 2696;
int BOSS2 = 2710;
int BOSS3 = 2760;
int SPINNINGNUKEICON = 2813;
int BIGFNTCURSOR = 2820;
int SMALLFNTCURSOR = 2821;
int STARTALPHANUM = 2822;
int ENDALPHANUM = 2915;
int BIGALPHANUM = 2940;
int BIGPERIOD = 3002;
int BIGCOMMA = 3003;
int BIGX = 3004;
int BIGQ = 3005;
int BIGSEMI = 3006;
int BIGCOLIN = 3007;
int THREEBYFIVE = 3010;
int BIGAPPOS = 3022;
int BLANK = 3026;
int MINIFONT = 3072;
int BUTTON1 = 3164;
int GLASS3 = 3187;
int RESPAWNMARKERRED = 3190;
int RESPAWNMARKERYELLOW = 3200;
int RESPAWNMARKERGREEN = 3210;
int BONUSSCREEN = 3240;
int VIEWBORDER = 3250;
int VICTORY1 = 3260;
int ORDERING = 3270;
int TEXTSTORY = 3280;
int LOADSCREEN = 3281;
int BORNTOBEWILDSCREEN = 3370;
int BLIMP = 3400;
int FEM9 = 3450;
int FOOTPRINT = 3701;
int FRAMEEFFECT1_13 = 3999;
int POOP = 4094;
int FRAMEEFFECT1 = 4095;
int PANNEL3 = 4099;
int SCREENBREAK14 = 4120;
int SCREENBREAK15 = 4123;
int SCREENBREAK19 = 4125;
int SCREENBREAK16 = 4127;
int SCREENBREAK17 = 4128;
int SCREENBREAK18 = 4129;
int W_TECHWALL11 = 4130;
int W_TECHWALL12 = 4131;
int W_TECHWALL13 = 4132;
int W_TECHWALL14 = 4133;
int W_TECHWALL5 = 4134;
int W_TECHWALL6 = 4136;
int W_TECHWALL7 = 4138;
int W_TECHWALL8 = 4140;
int W_TECHWALL9 = 4142;
int BPANNEL3 = 4100;
int W_HITTECHWALL16 = 4144;
int W_HITTECHWALL10 = 4145;
int W_HITTECHWALL15 = 4147;
int W_MILKSHELF = 4181;
int W_MILKSHELFBROKE = 4203;
int PURPLELAVA = 4240;
int LAVABUBBLE = 4340;
int DUKECUTOUT = 4352;
int TARGET = 4359;
int GUNPOWDERBARREL = 4360;
int DUCK = 4361;
int HATRACK = 4367;
int DESKLAMP = 4370;
int COFFEEMACHINE = 4372;
int CUPS = 4373;
int GAVALS = 4374;
int GAVALS2 = 4375;
int POLICELIGHTPOLE = 4377;
int FLOORBASKET = 4388;
int PUKE = 4389;
int DOORTILE23 = 4391;
int TOPSECRET = 4396;
int SPEAKER = 4397;
int TEDDYBEAR = 4400;
int ROBOTDOG = 4402;
int ROBOTPIRATE = 4404;
int ROBOTMOUSE = 4407;
int MAIL = 4410;
int MAILBAG = 4413;
int HOTMEAT = 4427;
int COFFEEMUG = 4438;
int DONUTS2 = 4440;
int TRIPODCAMERA = 4444;
int METER = 4453;
int DESKPHONE = 4454;
int GUMBALLMACHINE = 4458;
int GUMBALLMACHINEBROKE = 4459;
int PAPER = 4460;
int MACE = 4464;
int GENERICPOLE2 = 4465;
int XXXSTACY = 4470;
int WETFLOOR = 4495;
int BROOM = 4496;
int MOP = 4497;
int LETTER = 4502;
int PIRATE1A = 4510;
int PIRATE4A = 4511;
int PIRATE2A = 4512;
int PIRATE5A = 4513;
int PIRATE3A = 4514;
int PIRATE6A = 4515;
int PIRATEHALF = 4516;
int CHESTOFGOLD = 4520;
int SIDEBOLT1 = 4525;
int FOODOBJECT1 = 4530;
int FOODOBJECT2 = 4531;
int FOODOBJECT3 = 4532;
int FOODOBJECT4 = 4533;
int FOODOBJECT5 = 4534;
int FOODOBJECT6 = 4535;
int FOODOBJECT7 = 4536;
int FOODOBJECT8 = 4537;
int FOODOBJECT9 = 4538;
int FOODOBJECT10 = 4539;
int FOODOBJECT11 = 4540;
int FOODOBJECT12 = 4541;
int FOODOBJECT13 = 4542;
int FOODOBJECT14 = 4543;
int FOODOBJECT15 = 4544;
int FOODOBJECT16 = 4545;
int FOODOBJECT17 = 4546;
int FOODOBJECT18 = 4547;
int FOODOBJECT19 = 4548;
int FOODOBJECT20 = 4549;
int HEADLAMP = 4550;
int TAMPON = 4557;
int SKINNEDCHICKEN = 4554;
int FEATHEREDCHICKEN = 4555;
int ROBOTDOG2 = 4560;
int JOLLYMEAL = 4569;
int DUKEBURGER = 4570;
int SHOPPINGCART = 4576;
int CANWITHSOMETHING2 = 4580;
int CANWITHSOMETHING3 = 4581;
int CANWITHSOMETHING4 = 4582;
int SNAKEP = 4590;
int DOLPHIN1 = 4591;
int DOLPHIN2 = 4592;
int NEWBEAST = 4610;
int NEWBEASTSTAYPUT = 4611;
int NEWBEASTJUMP = 4690;
int NEWBEASTHANG = 4670;
int NEWBEASTHANGDEAD = 4671;
int BOSS4 = 4740;
int BOSS4STAYPUT = 4741;
int FEM10 = 4864;
int TOUGHGAL = 4866;
int MAN = 4871;
int MAN2 = 4872;
int WOMAN = 4874;
int PLEASEWAIT = 4887;
int NATURALLIGHTNING = 4890;
int WEATHERWARN = 4893;
int DUKETAG = 4900;
int SIGN1 = 4909;
int SIGN2 = 4912;
int JURYGUY = 4943;
int RESERVEDSLOT1 = 6132;
int RESERVEDSLOT2 = 6133;
int RESERVEDSLOT3 = 6134;
int RESERVEDSLOT4 = 6135;
int RESERVEDSLOT5 = 6136;
int RESERVEDSLOT6 = 6137;
int RESERVEDSLOT7 = 6138;
int RESERVEDSLOT8 = 6139;
int RESERVEDSLOT9 = 6140;
int RESERVEDSLOT10 = 6141;
int RESERVEDSLOT11 = 6142;
int RESERVEDSLOT12 = 6143;

short DynamicTileMap[MAXTILES];

void G_ProcessDynamicTileMapping(const char *szLabel, int lValue)
{
    int i;
    if (lValue >= MAXTILES || !szLabel)
        return;

    i = HASH_find(&dynnamesH,szLabel);
    if (i>=0) *(list[i].v)=lValue;
}

void inithashnames()
{
    int i;
    HASH_init(&dynnamesH);
    for (i=0;list[i].val;i++)
        HASH_add(&dynnamesH,list[i].s,i);
}

void freehashnames()
{
    HASH_free(&dynnamesH);
}

void G_InitDynamicTiles(void)
{
    int i = 0;
    clearbufbyte(DynamicTileMap,MAXTILES,0);
    while (list[i].val)
    {
        DynamicTileMap[list[i].val]=list[i].vstat;
        i++;
    }

    BlimpSpawnSprites[0] = RPGSPRITE;
    BlimpSpawnSprites[1] = CHAINGUNSPRITE;
    BlimpSpawnSprites[2] = DEVISTATORAMMO;
    BlimpSpawnSprites[3] = RPGAMMO;
    BlimpSpawnSprites[4] = RPGAMMO;
    BlimpSpawnSprites[5] = JETPACK;
    BlimpSpawnSprites[6] = SHIELD;
    BlimpSpawnSprites[7] = FIRSTAID;
    BlimpSpawnSprites[8] = STEROIDS;
    BlimpSpawnSprites[9] = RPGAMMO;
    BlimpSpawnSprites[10] = RPGAMMO;
    BlimpSpawnSprites[11] = RPGSPRITE;
    BlimpSpawnSprites[12] = RPGAMMO;
    BlimpSpawnSprites[13] = FREEZESPRITE;
    BlimpSpawnSprites[14] = FREEZEAMMO;

    WeaponPickupSprites[0] = KNEE;
    WeaponPickupSprites[1] = FIRSTGUNSPRITE;
    WeaponPickupSprites[2] = SHOTGUNSPRITE;
    WeaponPickupSprites[3] = CHAINGUNSPRITE;
    WeaponPickupSprites[4] = RPGSPRITE;
    WeaponPickupSprites[5] = HEAVYHBOMB;
    WeaponPickupSprites[6] = SHRINKERSPRITE;
    WeaponPickupSprites[7] = DEVISTATORSPRITE;
    WeaponPickupSprites[8] = TRIPBOMBSPRITE;
    WeaponPickupSprites[9] = FREEZESPRITE;
    WeaponPickupSprites[10] = HEAVYHBOMB;
    WeaponPickupSprites[11] = SHRINKERSPRITE;
}
